/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.IBoxDocumentableNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxClass
extends BoxNode
implements IBoxDocumentableNode {
    private List<BoxStatement> body;
    private List<BoxImport> imports;
    private List<BoxAnnotation> annotations;
    private List<BoxDocumentationAnnotation> documentation;
    private List<BoxProperty> properties;

    public BoxClass(List<BoxImport> imports, List<BoxStatement> body, List<BoxAnnotation> annotations, List<BoxDocumentationAnnotation> documentation, List<BoxProperty> properties, Position position, String sourceText) {
        super(position, sourceText);
        this.setImports(imports);
        this.setBody(body);
        this.setAnnotations(annotations);
        this.setDocumentation(documentation);
        this.setProperties(properties);
    }

    public List<BoxStatement> getBody() {
        return this.body;
    }

    public List<BoxAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<BoxDocumentationAnnotation> getDocumentation() {
        return this.documentation;
    }

    public List<BoxImport> getImports() {
        return this.imports;
    }

    public List<BoxProperty> getProperties() {
        return this.properties;
    }

    public void setBody(List<BoxStatement> body) {
        this.replaceChildren(this.body, body);
        this.body = body;
        this.body.forEach(arg -> arg.setParent(this));
    }

    public void setAnnotations(List<BoxAnnotation> annotations) {
        this.replaceChildren(this.annotations, annotations);
        this.annotations = annotations;
        this.annotations.forEach(arg -> arg.setParent(this));
    }

    @Override
    public void setDocumentation(List<BoxDocumentationAnnotation> documentation) {
        this.replaceChildren(this.documentation, documentation);
        this.documentation = documentation;
        this.documentation.forEach(arg -> arg.setParent(this));
    }

    public void setImports(List<BoxImport> imports) {
        this.replaceChildren(this.imports, imports);
        this.imports = imports;
        this.imports.forEach(arg -> arg.setParent(this));
    }

    public void setProperties(List<BoxProperty> properties) {
        this.replaceChildren(this.properties, properties);
        this.properties = properties;
        this.properties.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("imports", this.imports.stream().map(BoxImport::toMap).collect(Collectors.toList()));
        map.put("body", this.body.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        map.put("annotations", this.annotations.stream().map(BoxAnnotation::toMap).collect(Collectors.toList()));
        map.put("documentation", this.documentation.stream().map(BoxDocumentationAnnotation::toMap).collect(Collectors.toList()));
        map.put("properties", this.properties.stream().map(BoxProperty::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

