/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.IBoxDocumentableNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxInterface
extends BoxNode
implements IBoxDocumentableNode {
    private List<BoxStatement> body;
    private List<BoxImport> imports;
    private List<BoxAnnotation> annotations;
    private List<BoxAnnotation> postAnnotations;
    private List<BoxDocumentationAnnotation> documentation;

    public BoxInterface(List<BoxImport> imports, List<BoxStatement> body, List<BoxAnnotation> annotations, List<BoxAnnotation> postAnnotations, List<BoxDocumentationAnnotation> documentation, Position position, String sourceText) {
        super(position, sourceText);
        this.setImports(imports);
        this.setBody(body);
        this.setAnnotations(annotations);
        this.setPostAnnotations(postAnnotations);
        this.setDocumentation(documentation);
    }

    public List<BoxStatement> getBody() {
        return this.body;
    }

    public List<BoxAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<BoxAnnotation> getPostAnnotations() {
        return this.postAnnotations;
    }

    public List<BoxAnnotation> getAllAnnotations() {
        ArrayList<BoxAnnotation> allAnnotations = new ArrayList<BoxAnnotation>();
        allAnnotations.addAll(this.annotations);
        allAnnotations.addAll(this.postAnnotations);
        return allAnnotations;
    }

    @Override
    public List<BoxDocumentationAnnotation> getDocumentation() {
        return this.documentation;
    }

    public List<BoxImport> getImports() {
        return this.imports;
    }

    public void setBody(List<BoxStatement> body) {
        this.replaceChildren(this.body, body);
        this.body = body;
        this.body.forEach(arg -> arg.setParent(this));
    }

    public void setAnnotations(List<BoxAnnotation> annotations) {
        this.replaceChildren(this.annotations, annotations);
        this.annotations = annotations;
        this.annotations.forEach(arg -> arg.setParent(this));
    }

    public void setPostAnnotations(List<BoxAnnotation> postAnnotations) {
        this.replaceChildren(this.postAnnotations, postAnnotations);
        this.postAnnotations = postAnnotations;
        this.postAnnotations.forEach(arg -> arg.setParent(this));
    }

    @Override
    public void setDocumentation(List<BoxDocumentationAnnotation> documentation) {
        this.replaceChildren(this.documentation, documentation);
        this.documentation = documentation;
        this.documentation.forEach(arg -> arg.setParent(this));
    }

    public void setImports(List<BoxImport> imports) {
        this.replaceChildren(this.imports, imports);
        this.imports = imports;
        this.imports.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("imports", this.imports.stream().map(BoxImport::toMap).collect(Collectors.toList()));
        map.put("body", this.body.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        map.put("annotations", this.getAllAnnotations().stream().map(BoxAnnotation::toMap).collect(Collectors.toList()));
        map.put("documentation", this.documentation.stream().map(BoxDocumentationAnnotation::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

