/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.IBoxDocumentableNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.comment.BoxComment;
import ortus.boxlang.compiler.ast.comment.BoxDocComment;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.visitor.BoxVisitable;
import ortus.boxlang.compiler.ast.visitor.PrettyPrintBoxVisitor;

public abstract class BoxNode
implements BoxVisitable {
    protected Position position;
    private String sourceText;
    protected BoxNode parent = null;
    private List<BoxNode> children;
    private List<BoxComment> comments;

    protected BoxNode(Position position, String sourceText) {
        this.position = position;
        this.sourceText = sourceText;
        this.children = new ArrayList<BoxNode>();
        this.comments = new ArrayList<BoxComment>();
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public void setSourceText(String sourceText) {
        this.sourceText = sourceText;
    }

    public void setParent(BoxNode parent) {
        this.parent = parent;
        if (parent != null && !parent.children.contains(this)) {
            parent.getChildren().add(this);
        }
    }

    public BoxNode getParent() {
        return this.parent;
    }

    public List<BoxNode> getChildren() {
        return this.children;
    }

    public List<BoxComment> getComments() {
        return this.comments;
    }

    public BoxDocComment getDocComment() {
        for (int i = this.comments.size() - 1; i >= 0; --i) {
            BoxComment comment = this.comments.get(i);
            if (!(comment instanceof BoxDocComment)) continue;
            BoxDocComment bc = (BoxDocComment)comment;
            return bc;
        }
        return null;
    }

    public BoxNode associateComments(List<BoxComment> incomingComments) {
        if (incomingComments.isEmpty()) {
            return this;
        }
        this._associateComments(incomingComments);
        for (BoxComment doc : incomingComments) {
            this.addComment(doc);
        }
        return this;
    }

    private void _associateComments(List<BoxComment> incomingComments) {
        this._associateComments(incomingComments, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _associateComments(List<BoxComment> incomingComments, boolean lastNodeOnThisLine) {
        if (incomingComments.isEmpty()) {
            return;
        }
        try {
            BoxComment doc;
            BoxNode i2;
            BoxNode child;
            BoxNode boxNode = this;
            if (boxNode instanceof BoxClass) {
                BoxClass bc = (BoxClass)boxNode;
                for (int i2 = 0; i2 < bc.getImports().size(); ++i2) {
                    child = bc.getImports().get(i2);
                    lastNodeOnThisLine = i2 == bc.getImports().size() - 1 || !bc.getImports().get(i2 + 1).startsOnEndLineOf(child);
                    child._associateComments(incomingComments, lastNodeOnThisLine);
                }
            }
            if ((i2 = this) instanceof BoxInterface) {
                BoxInterface bi = (BoxInterface)i2;
                for (int i3 = 0; i3 < bi.getImports().size(); ++i3) {
                    child = bi.getImports().get(i3);
                    lastNodeOnThisLine = i3 == bi.getImports().size() - 1 || !bi.getImports().get(i3 + 1).startsOnEndLineOf(child);
                    child._associateComments(incomingComments, lastNodeOnThisLine);
                }
            }
            while (!incomingComments.isEmpty() && (doc = incomingComments.get(0)).isBefore(this)) {
                this.addComment(doc);
                incomingComments.remove(doc);
            }
            if (incomingComments.isEmpty()) {
                return;
            }
            this.children.sort((a, b) -> {
                if (a.getPosition() == null) {
                    return 0;
                }
                if (b.getPosition() == null) {
                    return 0;
                }
                int lineDiff = a.getPosition().getStart().getLine() - b.getPosition().getStart().getLine();
                if (lineDiff == 0) {
                    return a.getPosition().getStart().getColumn() - b.getPosition().getStart().getColumn();
                }
                return lineDiff;
            });
            for (int i4 = 0; i4 < this.children.size(); ++i4) {
                BoxNode child2 = this.children.get(i4);
                if (child2 instanceof BoxAnnotation || child2 instanceof BoxImport) continue;
                lastNodeOnThisLine = i4 == this.children.size() - 1 || !this.children.get(i4 + 1).startsOnEndLineOf(child2);
                child2._associateComments(incomingComments, lastNodeOnThisLine);
            }
            if (incomingComments.isEmpty()) {
                return;
            }
            while (!incomingComments.isEmpty() && (doc = incomingComments.get(0)).isInside(this)) {
                this.addComment(doc);
                incomingComments.remove(doc);
            }
            if (incomingComments.isEmpty()) {
                return;
            }
            if (lastNodeOnThisLine && (this.getParent() == null || !this.endsOnSameLineAs(this.getParent()))) {
                while (!incomingComments.isEmpty() && (doc = incomingComments.get(0)).startsOnEndLineOf(this)) {
                    this.addComment(doc);
                    incomingComments.remove(doc);
                }
            }
        }
        finally {
            BoxNode i3 = this;
            if (i3 instanceof IBoxDocumentableNode) {
                IBoxDocumentableNode bdn = (IBoxDocumentableNode)((Object)i3);
                bdn.finalizeDocumentation();
            }
        }
    }

    public boolean isBefore(BoxNode node) {
        if (this.getPosition() == null || node.getPosition() == null) {
            return false;
        }
        int thisEndLine = this.getPosition().getEnd().getLine();
        int thisEndCol = this.getPosition().getEnd().getColumn();
        int nodeStartLine = node.getPosition().getStart().getLine();
        int nodeStartCol = node.getPosition().getStart().getColumn();
        return thisEndLine < nodeStartLine || thisEndLine == nodeStartLine && thisEndCol <= nodeStartCol;
    }

    public boolean isAfter(BoxNode node) {
        if (this.getPosition() == null || node.getPosition() == null) {
            return false;
        }
        int thisStartLine = this.getPosition().getStart().getLine();
        int thisStartCol = this.getPosition().getStart().getColumn();
        int nodeEndLine = node.getPosition().getEnd().getLine();
        int nodeEndCol = node.getPosition().getEnd().getColumn();
        return thisStartLine > nodeEndLine || thisStartLine == nodeEndLine && thisStartCol >= nodeEndCol;
    }

    public boolean isInside(BoxNode node) {
        if (this.getPosition() == null || node.getPosition() == null) {
            return false;
        }
        return !this.isAfter(node) && !this.isBefore(node);
    }

    public boolean startsOnEndLineOf(BoxNode node) {
        int nodeEndLine;
        if (this.getPosition() == null || node.getPosition() == null) {
            return false;
        }
        int thisStartLine = this.getPosition().getStart().getLine();
        return thisStartLine == (nodeEndLine = node.getPosition().getEnd().getLine());
    }

    public boolean endsOnSameLineAs(BoxNode node) {
        int nodeEndLine;
        if (this.getPosition() == null || node.getPosition() == null) {
            return false;
        }
        int thisEndLine = this.getPosition().getEnd().getLine();
        return thisEndLine == (nodeEndLine = node.getPosition().getEnd().getLine());
    }

    public BoxNode setComments(List<BoxComment> comments) {
        this.comments = comments;
        comments.forEach(comment -> comment.setParent(this));
        return this;
    }

    public BoxNode addComment(BoxComment comment) {
        this.comments.add(comment);
        comment.setParent(this);
        return this;
    }

    public void replaceChildren(BoxNode oldChild, BoxNode newChild) {
        if (oldChild != null) {
            this.children.remove(oldChild);
        }
        if (newChild != null) {
            this.children.add(newChild);
        }
    }

    public void replaceChildren(List<? extends BoxNode> oldChildren, List<? extends BoxNode> newChildren) {
        if (oldChildren != null) {
            this.children.removeAll(oldChildren);
        }
        if (newChildren != null) {
            this.children.addAll(newChildren);
        }
    }

    public List<BoxNode> getDescendants() {
        ArrayList<BoxNode> result = new ArrayList<BoxNode>();
        result.add(this);
        for (BoxNode node : this.children) {
            result.addAll(node.getDescendants());
        }
        return result;
    }

    public <T> List<T> getDescendantsOfType(Class<T> type, Predicate<T> predicate) {
        ArrayList<BoxNode> result = new ArrayList<BoxNode>();
        if (type.isAssignableFrom(this.getClass()) && predicate.test(this)) {
            result.add(this);
        }
        for (BoxNode node : this.children) {
            result.addAll(node.getDescendantsOfType(type, predicate));
        }
        return result;
    }

    public <T> List<T> getDescendantsOfType(Class<T> type) {
        return this.getDescendantsOfType(type, T -> true);
    }

    public List<BoxNode> getAncestors() {
        ArrayList<BoxNode> result = new ArrayList<BoxNode>();
        BoxNode node = this.parent;
        while (node != null) {
            result.add(node);
            node = node.parent;
        }
        return result;
    }

    public <T> T getFirstAncestorOfType(Class<T> type) {
        return (T)this.getFirstAncestorOfType(type, T -> true);
    }

    public <T> T getFirstNodeOfType(Class<T> type) {
        return (T)this.getFirstNodeOfType(type, T -> true);
    }

    public <T> T getFirstNodeOfType(Class<T> type, Predicate<T> predicate) {
        if (type.isAssignableFrom(this.getClass()) && predicate.test(this)) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.getFirstNodeOfType(type, predicate);
        }
        return null;
    }

    public <T> T getFirstNodeOfTypes(Class<? extends BoxNode> ... type) {
        for (Class<? extends BoxNode> t : type) {
            if (!t.isAssignableFrom(this.getClass())) continue;
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.getFirstNodeOfTypes(type);
        }
        return null;
    }

    public <T> T getFirstAncestorOfType(Class<T> type, Predicate<T> predicate) {
        if (this.parent != null) {
            return this.parent.getFirstNodeOfType(type, predicate);
        }
        return null;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("ASTType", this.getClass().getSimpleName());
        map.put("ASTPackage", this.getClass().getPackageName());
        map.put("sourceText", this.sourceText);
        if (this.position != null) {
            map.put("position", this.position.toMap());
        }
        map.put("comments", this.comments.stream().map(BoxNode::toMap).toList());
        return map;
    }

    public Map<String, Object> enumToMap(Enum<?> e) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("ASTType", this.getClass().getSimpleName());
        map.put("ASTPackage", this.getClass().getPackageName());
        map.put("sourceText", e.name());
        return map;
    }

    public String toJSON() {
        try {
            return JSON.std.with(JSON.Feature.PRETTY_PRINT_OUTPUT, JSON.Feature.WRITE_NULL_PROPERTIES).asString(this.toMap());
        }
        catch (JSONObjectException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new RuntimeException("Failed to convert to JSON");
    }

    public String toString() {
        PrettyPrintBoxVisitor visitor = new PrettyPrintBoxVisitor();
        this.accept(visitor);
        return visitor.getOutput();
    }

    public String getDescription() {
        String name;
        String className = this.getClass().getSimpleName();
        if (className.startsWith("Box")) {
            className = className.substring(3);
        }
        if ((name = className.replaceAll("([A-Z])", " $1").toLowerCase().trim()).matches("^[aeiou].*")) {
            return "an " + name;
        }
        return "a " + name;
    }
}

