/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.Point;
import ortus.boxlang.compiler.ast.Source;

public class Position {
    private Point start;
    private Point end;
    private Source source;

    public Position(Point start, Point end) {
        this.start = start;
        this.end = end;
        this.source = null;
    }

    public Position(Point start, Point end, Source source) {
        this.start = start;
        this.end = end;
        this.source = source;
    }

    public Point getStart() {
        return this.start;
    }

    public Point getEnd() {
        return this.end;
    }

    public void setEnd(Point end) {
        this.end = end;
    }

    public void setStart(Point start) {
        this.start = start;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.source != null) {
            sb.append(this.getSource());
            sb.append(": ");
        }
        sb.append(this.getStart().getLine()).append(",").append(this.getStart().getColumn());
        sb.append(" - ");
        sb.append(this.getEnd().getLine()).append(",").append(this.getEnd().getColumn());
        return sb.toString();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("start", this.start.toMap());
        map.put("end", this.end.toMap());
        return map;
    }
}

