/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;

public abstract class Source {
    public abstract Stream<String> getCodeAsStream();

    public abstract String getCode();

    public String getSurroundingLines(int lineNo, boolean html) {
        List lines = this.getCodeAsStream().skip(Math.max(0, lineNo - 3)).limit(5L).collect(Collectors.toList());
        StringBuilder codeSnippet = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            String theLine = StringEscapeUtils.escapeHtml4((String)lines.get(i));
            if (i == 2 && html) {
                codeSnippet.append("<b>").append(lineNo - 2 + i).append(": ").append(theLine).append("</b>").append("<br>");
                continue;
            }
            codeSnippet.append(lineNo - 2 + i).append(": ").append(theLine).append(html ? "<br>" : "\n");
        }
        return codeSnippet.toString();
    }
}

