/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.stream.Stream;
import ortus.boxlang.compiler.ast.Source;

public class SourceFile
extends Source {
    private final File file;

    public SourceFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getCode() {
        try {
            return new String(Files.readAllBytes(this.file.toPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String toString() {
        return this.file != null ? this.file.getAbsolutePath() : "";
    }

    @Override
    public Stream<String> getCodeAsStream() {
        try {
            return Files.lines(this.file.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }
}

