/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxAssignment
extends BoxExpression {
    private BoxExpression left;
    private BoxExpression right;
    private BoxAssignmentOperator op;
    private List<BoxAssignmentModifier> modifiers;

    public BoxAssignment(BoxExpression left, BoxAssignmentOperator op, BoxExpression right, List<BoxAssignmentModifier> modifiers, Position position, String sourceText) {
        super(position, sourceText);
        this.setLeft(left);
        this.setRight(right);
        this.setOp(op);
        this.setModifiers(modifiers);
    }

    public BoxExpression getLeft() {
        return this.left;
    }

    public BoxExpression getRight() {
        return this.right;
    }

    public BoxAssignmentOperator getOp() {
        return this.op;
    }

    public List<BoxAssignmentModifier> getModifiers() {
        return this.modifiers;
    }

    public void setLeft(BoxExpression left) {
        this.replaceChildren(this.left, left);
        this.left = left;
        this.left.setParent(this);
    }

    public void setRight(BoxExpression right) {
        this.replaceChildren(this.right, right);
        this.right = right;
        if (right != null) {
            this.right.setParent(this);
        }
    }

    public void setOp(BoxAssignmentOperator op) {
        this.op = op;
    }

    public void setModifiers(List<BoxAssignmentModifier> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("modifiers", this.modifiers.stream().map(op -> this.enumToMap((Enum<?>)op)).toList());
        map.put("left", this.left.toMap());
        if (this.op != null) {
            map.put("op", this.enumToMap(this.op));
        } else {
            map.put("op", null);
        }
        if (this.right != null) {
            map.put("right", this.right.toMap());
        } else {
            map.put("right", null);
        }
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

