/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxClosure
extends BoxExpression {
    private List<BoxArgumentDeclaration> args;
    private List<BoxAnnotation> annotations;
    private BoxStatement body;

    public BoxClosure(List<BoxArgumentDeclaration> args, List<BoxAnnotation> annotations, BoxStatement body, Position position, String sourceText) {
        super(position, sourceText);
        this.setArgs(args);
        this.setAnnotations(annotations);
        this.setBody(body);
    }

    public List<BoxArgumentDeclaration> getArgs() {
        return this.args;
    }

    public List<BoxAnnotation> getAnnotations() {
        return this.annotations;
    }

    public BoxStatement getBody() {
        return this.body;
    }

    public void setArgs(List<BoxArgumentDeclaration> args) {
        this.replaceChildren(this.args, args);
        this.args = args;
        this.args.forEach(arg -> arg.setParent(this));
    }

    public void setAnnotations(List<BoxAnnotation> annotations) {
        this.replaceChildren(this.annotations, annotations);
        this.annotations = annotations;
        this.annotations.forEach(arg -> arg.setParent(this));
    }

    public void setBody(BoxStatement body) {
        this.replaceChildren(this.body, body);
        this.body = body;
        this.body.setParent(this);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("annotations", this.annotations.stream().map(BoxAnnotation::toMap).collect(Collectors.toList()));
        map.put("args", this.args.stream().map(BoxArgumentDeclaration::toMap).collect(Collectors.toList()));
        map.put("body", this.body.toMap());
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

