/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxExpressionInvocation
extends BoxExpression {
    private BoxExpression expr;
    private List<BoxArgument> arguments;

    public BoxExpressionInvocation(BoxExpression expr, List<BoxArgument> arguments, Position position, String sourceText) {
        super(position, sourceText);
        this.setExpr(expr);
        this.setArguments(arguments);
    }

    public BoxExpression getExpr() {
        return this.expr;
    }

    public List<BoxArgument> getArguments() {
        return this.arguments;
    }

    public void setExpr(BoxExpression expr) {
        this.replaceChildren(this.expr, expr);
        if (this.expr != null) {
            this.expr.setParent(this);
        }
        this.expr = expr;
    }

    public void setArguments(List<BoxArgument> arguments) {
        this.replaceChildren(this.arguments, arguments);
        this.arguments = arguments;
        this.arguments.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("expr", this.expr.toMap());
        map.put("arguments", this.arguments.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

