/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxFunctionInvocation
extends BoxExpression {
    private String name;
    private List<BoxArgument> arguments;

    public BoxFunctionInvocation(String name, List<BoxArgument> arguments, Position position, String sourceText) {
        super(position, sourceText);
        this.setName(name);
        this.setArguments(arguments);
    }

    public String getName() {
        return this.name;
    }

    public List<BoxArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<BoxArgument> arguments) {
        this.replaceChildren(this.arguments, arguments);
        this.arguments = arguments;
        this.arguments.forEach(arg -> arg.setParent(this));
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("name", this.name);
        map.put("arguments", this.arguments.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }

    @Override
    public String getDescription() {
        return "a function invocation";
    }
}

