/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxFunctionalMemberAccess
extends BoxExpression {
    private String name;
    private List<BoxArgument> arguments;

    public BoxFunctionalMemberAccess(String name, List<BoxArgument> arguments, Position position, String sourceText) {
        super(position, sourceText);
        this.setName(name);
        this.setArguments(arguments);
    }

    public String getName() {
        return this.name;
    }

    public List<BoxArgument> getArguments() {
        return this.arguments;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArguments(List<BoxArgument> arguments) {
        this.replaceChildren(this.arguments, arguments);
        this.arguments = arguments;
        if (this.arguments != null) {
            this.arguments.forEach(arg -> arg.setParent(this));
        }
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("name", this.name);
        if (this.arguments != null) {
            map.put("arguments", this.arguments.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        } else {
            map.put("arguments", null);
        }
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

