/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxNew
extends BoxExpression {
    private BoxExpression expression;
    private BoxIdentifier prefix;
    private List<BoxArgument> arguments;

    public BoxNew(BoxIdentifier prefix, BoxExpression expression, List<BoxArgument> arguments, Position position, String sourceText) {
        super(position, sourceText);
        this.setExpression(expression);
        this.setArguments(arguments);
        this.setPrefix(prefix);
    }

    public BoxExpression getExpression() {
        return this.expression;
    }

    public List<BoxArgument> getArguments() {
        return this.arguments;
    }

    public BoxIdentifier getPrefix() {
        return this.prefix;
    }

    public void setExpression(BoxExpression expression) {
        this.replaceChildren(this.expression, expression);
        this.expression = expression;
        if (expression != null) {
            this.expression.setParent(this);
        }
    }

    public void setArguments(List<BoxArgument> arguments) {
        this.replaceChildren(this.arguments, arguments);
        this.arguments = arguments;
        this.arguments.forEach(arg -> arg.setParent(this));
    }

    public void setPrefix(BoxIdentifier prefix) {
        this.replaceChildren(this.prefix, prefix);
        this.prefix = prefix;
        if (prefix != null) {
            this.prefix.setParent(this);
        }
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (this.prefix == null) {
            map.put("prefix", null);
        } else {
            map.put("prefix", this.prefix.toMap());
        }
        if (this.expression == null) {
            map.put("expression", null);
        } else {
            map.put("expression", this.expression.toMap());
        }
        map.put("arguments", this.arguments.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

