/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxStaticMethodInvocation
extends BoxExpression {
    private BoxIdentifier name;
    private List<BoxArgument> arguments;
    private BoxExpression obj;

    public BoxStaticMethodInvocation(BoxIdentifier name, BoxExpression obj, List<BoxArgument> arguments, Position position, String sourceText) {
        super(position, sourceText);
        this.setName(name);
        this.setObj(obj);
        this.setArguments(arguments);
    }

    public BoxIdentifier getName() {
        return this.name;
    }

    public BoxExpression getObj() {
        return this.obj;
    }

    public List<BoxArgument> getArguments() {
        return this.arguments;
    }

    public void setName(BoxIdentifier name) {
        this.replaceChildren(this.name, name);
        this.name = name;
        this.name.setParent(this);
    }

    public void setObj(BoxExpression obj) {
        this.replaceChildren(this.obj, obj);
        this.obj = obj;
        this.obj.setParent(this);
    }

    public void setArguments(List<BoxArgument> arguments) {
        this.replaceChildren(this.arguments, arguments);
        this.arguments = arguments;
        this.arguments.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("obj", this.obj.toMap());
        map.put("name", this.name.toMap());
        map.put("arguments", this.arguments.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

