/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxStringConcat
extends BoxExpression {
    private List<BoxExpression> values;

    public BoxStringConcat(List<BoxExpression> parts2, Position position, String sourceText) {
        super(position, sourceText);
        this.setValues(parts2);
    }

    public List<BoxExpression> getValues() {
        return this.values;
    }

    public void setValues(List<BoxExpression> values) {
        this.replaceChildren(this.values, values);
        this.values = values;
        this.values.forEach(arg -> arg.setParent(this));
    }

    @Override
    public boolean isLiteral() {
        return this.values.stream().allMatch(BoxExpression::isLiteral);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("values", this.values.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

