/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.expression;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxStructType;
import ortus.boxlang.compiler.ast.expression.IBoxLiteral;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxStructLiteral
extends BoxExpression
implements IBoxLiteral {
    private BoxStructType type;
    private List<BoxExpression> values;

    public BoxStructLiteral(BoxStructType type, List<BoxExpression> values, Position position, String sourceText) {
        super(position, sourceText);
        this.setType(type);
        this.setValues(values);
    }

    public List<BoxExpression> getValues() {
        return this.values;
    }

    public BoxStructType getType() {
        return this.type;
    }

    @Override
    public boolean isLiteral() {
        int i = 0;
        for (BoxExpression value : this.values) {
            if (value.isLiteral() || ++i % 2 != 0 && value instanceof BoxIdentifier) continue;
            return false;
        }
        return true;
    }

    public void setValues(List<BoxExpression> values) {
        this.replaceChildren(this.values, values);
        this.values = values;
        this.values.forEach(arg -> arg.setParent(this));
    }

    public void setType(BoxStructType type) {
        this.type = type;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("type", this.enumToMap(this.type));
        map.put("values", this.values.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }

    @Override
    public String getDescription() {
        return "a struct literal";
    }
}

