/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxArgumentDeclaration
extends BoxStatement {
    private Boolean required;
    private String name;
    private String type;
    private BoxExpression value;
    private List<BoxAnnotation> annotations;
    private List<BoxDocumentationAnnotation> documentation;

    public BoxArgumentDeclaration(Boolean required, String type, String name, BoxExpression defaultValue, List<BoxAnnotation> annotations, List<BoxDocumentationAnnotation> documentation, Position position, String sourceText) {
        super(position, sourceText);
        this.setRequired(required);
        this.setType(type);
        this.setName(name);
        this.setValue(defaultValue);
        this.setAnnotations(annotations);
        this.setDocumentation(documentation);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public BoxExpression getValue() {
        return this.value;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public List<BoxAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<BoxDocumentationAnnotation> getDocumentation() {
        return this.documentation;
    }

    public void setValue(BoxExpression value) {
        this.replaceChildren(this.value, value);
        this.value = value;
        if (this.value != null) {
            this.value.setParent(this);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setAnnotations(List<BoxAnnotation> annotations) {
        this.replaceChildren(this.annotations, annotations);
        this.annotations = annotations;
        if (this.annotations != null) {
            this.annotations.forEach(arg -> arg.setParent(this));
        }
    }

    public void setDocumentation(List<BoxDocumentationAnnotation> documentation) {
        this.replaceChildren(this.documentation, documentation);
        this.documentation = documentation;
        if (this.documentation != null) {
            this.documentation.forEach(arg -> arg.setParent(this));
        }
    }

    public void addDocumentation(BoxDocumentationAnnotation documentation) {
        this.replaceChildren(this.documentation, List.of(documentation));
        this.documentation.add(documentation);
        documentation.setParent(this);
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("name", this.name);
        if (this.value != null) {
            map.put("value", this.value.toMap());
        } else {
            map.put("value", null);
        }
        map.put("required", this.required);
        map.put("type", this.type);
        map.put("annotations", this.annotations.stream().map(BoxAnnotation::toMap).collect(Collectors.toList()));
        map.put("documentation", this.documentation.stream().map(BoxDocumentationAnnotation::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

