/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.IBoxDocumentableNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxFunctionDeclaration
extends BoxStatement
implements IBoxDocumentableNode {
    private BoxAccessModifier accessModifier;
    private List<BoxMethodDeclarationModifier> modifiers;
    private String name;
    private List<BoxArgumentDeclaration> args;
    private BoxReturnType type;
    private List<BoxStatement> body;
    private List<BoxAnnotation> annotations;
    private List<BoxDocumentationAnnotation> documentation;

    public BoxFunctionDeclaration(BoxAccessModifier accessModifier, List<BoxMethodDeclarationModifier> modifiers, String name, BoxReturnType type, List<BoxArgumentDeclaration> args, List<BoxAnnotation> annotations, List<BoxDocumentationAnnotation> documentation, List<BoxStatement> body, Position position, String sourceText) {
        super(position, sourceText);
        this.setAccessModifier(accessModifier);
        this.setModifiers(modifiers);
        this.setName(name);
        this.setType(type);
        this.setArgs(args);
        this.setBody(body);
        this.setAnnotations(annotations);
        this.setDocumentation(documentation);
    }

    public BoxFunctionDeclaration(BoxAccessModifier accessModifier, List<BoxMethodDeclarationModifier> modifiers, String name, BoxReturnType type, List<BoxArgumentDeclaration> args, List<BoxAnnotation> annotations, List<BoxDocumentationAnnotation> documentation, Position position, String sourceText) {
        this(accessModifier, modifiers, name, type, args, annotations, documentation, null, position, sourceText);
    }

    public BoxAccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public List<BoxMethodDeclarationModifier> getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public BoxReturnType getType() {
        return this.type;
    }

    public List<BoxArgumentDeclaration> getArgs() {
        return this.args;
    }

    public List<BoxStatement> getBody() {
        return this.body;
    }

    public List<BoxAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public List<BoxDocumentationAnnotation> getDocumentation() {
        return this.documentation;
    }

    public void setAccessModifier(BoxAccessModifier accessModifier) {
        this.accessModifier = accessModifier;
    }

    public void setModifiers(List<BoxMethodDeclarationModifier> modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(BoxReturnType type) {
        this.replaceChildren(this.type, type);
        this.type = type;
        if (type != null) {
            this.type.setParent(this);
        }
    }

    public void setArgs(List<BoxArgumentDeclaration> args) {
        this.replaceChildren(this.args, args);
        this.args = args;
        this.args.forEach(arg -> arg.setParent(this));
    }

    public void setBody(List<BoxStatement> body) {
        this.replaceChildren(this.body, body);
        this.body = body;
        if (this.body != null) {
            this.body.forEach(stmt -> stmt.setParent(this));
        }
    }

    public void setAnnotations(List<BoxAnnotation> annotations) {
        this.replaceChildren(this.annotations, annotations);
        this.annotations = annotations;
        this.annotations.forEach(arg -> arg.setParent(this));
    }

    @Override
    public void setDocumentation(List<BoxDocumentationAnnotation> documentation) {
        this.replaceChildren(this.documentation, documentation);
        this.documentation = documentation;
        this.documentation.forEach(arg -> arg.setParent(this));
    }

    @Override
    public void finalizeDocumentation() {
        IBoxDocumentableNode.super.finalizeDocumentation();
        ArrayList<BoxDocumentationAnnotation> docToRemove = new ArrayList<BoxDocumentationAnnotation>();
        for (BoxArgumentDeclaration arg : this.args) {
            for (BoxDocumentationAnnotation doc : this.documentation) {
                String docname = doc.getKey().getValue();
                if (docname.indexOf(46) > -1) {
                    docname = doc.getKey().getValue().substring(0, doc.getKey().getValue().indexOf("."));
                    if (!arg.getName().equalsIgnoreCase(docname)) continue;
                    BoxFQN key = new BoxFQN(doc.getKey().getValue().substring(doc.getKey().getValue().indexOf(".") + 1), doc.getPosition(), doc.getSourceText());
                    arg.addDocumentation(new BoxDocumentationAnnotation(key, doc.getValue(), doc.getPosition(), doc.getSourceText()));
                    docToRemove.add(doc);
                    continue;
                }
                if (!arg.getName().equalsIgnoreCase(docname)) continue;
                BoxFQN hint = new BoxFQN("hint", doc.getPosition(), doc.getSourceText());
                arg.addDocumentation(new BoxDocumentationAnnotation(hint, doc.getValue(), doc.getPosition(), doc.getSourceText()));
                docToRemove.add(doc);
            }
        }
        this.documentation.removeAll(docToRemove);
        this.replaceChildren(docToRemove, List.of());
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("accessModifier", this.accessModifier != null ? this.enumToMap(this.accessModifier) : null);
        map.put("modifiers", this.modifiers.stream().map(op -> this.enumToMap((Enum<?>)op)).toList());
        map.put("type", this.type != null ? this.type.toMap() : null);
        map.put("name", this.name);
        map.put("args", this.args.stream().map(BoxArgumentDeclaration::toMap).collect(Collectors.toList()));
        if (this.body != null) {
            map.put("body", this.body.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        } else {
            map.put("body", null);
        }
        map.put("annotations", this.annotations.stream().map(BoxAnnotation::toMap).collect(Collectors.toList()));
        map.put("documentation", this.documentation.stream().map(BoxDocumentationAnnotation::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

