/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.Map;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxImport
extends BoxStatement {
    private BoxExpression expression;
    private BoxIdentifier alias;

    public BoxImport(BoxExpression expression, BoxIdentifier alias, Position position, String sourceText) {
        super(position, sourceText);
        this.setExpression(expression);
        this.setAlias(alias);
    }

    public BoxExpression getExpression() {
        return this.expression;
    }

    public BoxIdentifier getAlias() {
        return this.alias;
    }

    public void setExpression(BoxExpression expression) {
        this.replaceChildren(this.expression, expression);
        this.expression = expression;
        if (expression != null) {
            this.expression.setParent(this);
        }
    }

    public void setAlias(BoxIdentifier alias) {
        this.replaceChildren(this.alias, alias);
        this.alias = alias;
        if (alias != null) {
            this.alias.setParent(this);
        }
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (this.expression != null) {
            map.put("expression", this.expression.toMap());
        } else {
            map.put("expression", null);
        }
        if (this.alias != null) {
            map.put("alias", this.alias.toMap());
        } else {
            map.put("alias", null);
        }
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

