/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.IBoxDocumentableNode;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxProperty
extends BoxStatement
implements IBoxDocumentableNode {
    private List<BoxAnnotation> annotations;
    private List<BoxAnnotation> postAnnotations;
    private List<BoxDocumentationAnnotation> documentation;

    public BoxProperty(List<BoxAnnotation> annotations, List<BoxAnnotation> postAnnotations, List<BoxDocumentationAnnotation> documentation, Position position, String sourceText) {
        super(position, sourceText);
        this.setAnnotations(annotations);
        this.setPostAnnotations(postAnnotations);
        this.setDocumentation(documentation);
    }

    public List<BoxAnnotation> getAnnotations() {
        return this.annotations;
    }

    public List<BoxAnnotation> getPostAnnotations() {
        return this.postAnnotations;
    }

    public List<BoxAnnotation> getAllAnnotations() {
        ArrayList<BoxAnnotation> allAnnotations = new ArrayList<BoxAnnotation>();
        allAnnotations.addAll(this.annotations);
        allAnnotations.addAll(this.postAnnotations);
        return allAnnotations;
    }

    public void setPostAnnotations(List<BoxAnnotation> postAnnotations) {
        this.replaceChildren(this.postAnnotations, postAnnotations);
        this.postAnnotations = postAnnotations;
        this.postAnnotations.forEach(arg -> arg.setParent(this));
    }

    @Override
    public List<BoxDocumentationAnnotation> getDocumentation() {
        return this.documentation;
    }

    public void setAnnotations(List<BoxAnnotation> annotations) {
        this.replaceChildren(this.annotations, annotations);
        this.annotations = annotations;
        this.annotations.forEach(arg -> arg.setParent(this));
    }

    @Override
    public void setDocumentation(List<BoxDocumentationAnnotation> documentation) {
        this.replaceChildren(this.documentation, documentation);
        this.documentation = documentation;
        this.documentation.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("annotations", this.getAllAnnotations().stream().map(BoxAnnotation::toMap).collect(Collectors.toList()));
        map.put("documentation", this.documentation.stream().map(BoxDocumentationAnnotation::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

