/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxSwitch
extends BoxStatement {
    private BoxExpression condition;
    private List<BoxSwitchCase> cases;

    public BoxSwitch(BoxExpression condition, List<BoxSwitchCase> cases, Position position, String sourceText) {
        super(position, sourceText);
        this.setCondition(condition);
        this.setCases(cases);
    }

    public BoxExpression getCondition() {
        return this.condition;
    }

    public List<BoxSwitchCase> getCases() {
        return this.cases;
    }

    public void setCondition(BoxExpression condition) {
        this.replaceChildren(this.condition, condition);
        this.condition = condition;
        if (this.condition != null) {
            this.condition.setParent(this);
        }
    }

    public void setCases(List<BoxSwitchCase> cases) {
        this.replaceChildren(this.cases, cases);
        this.cases = cases;
        this.cases.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("condition", this.condition.toMap());
        map.put("cases", this.cases.stream().map(BoxSwitchCase::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

