/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxSwitchCase
extends BoxStatement {
    private BoxExpression condition;
    private BoxExpression delimiter;
    private List<BoxStatement> body;

    public BoxSwitchCase(BoxExpression condition, BoxExpression delimiter, List<BoxStatement> body, Position position, String sourceText) {
        super(position, sourceText);
        this.setCondition(condition);
        this.setDelimiter(delimiter);
        this.setBody(body);
    }

    public BoxExpression getCondition() {
        return this.condition;
    }

    public List<BoxStatement> getBody() {
        return this.body;
    }

    public BoxExpression getDelimiter() {
        return this.delimiter;
    }

    public void setCondition(BoxExpression condition) {
        this.replaceChildren(this.condition, condition);
        this.condition = condition;
        if (this.condition != null) {
            this.condition.setParent(this);
        }
    }

    public void setDelimiter(BoxExpression delimiter) {
        this.replaceChildren(this.delimiter, delimiter);
        this.delimiter = delimiter;
        if (this.delimiter != null) {
            this.delimiter.setParent(this);
        }
    }

    public void setBody(List<BoxStatement> body) {
        this.replaceChildren(this.body, body);
        this.body = body;
        this.body.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        if (this.condition != null) {
            map.put("condition", this.condition.toMap());
        } else {
            map.put("condition", null);
        }
        if (this.delimiter != null) {
            map.put("delimiter", this.delimiter.toMap());
        } else {
            map.put("delimiter", null);
        }
        map.put("body", this.body.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

