/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxTry
extends BoxStatement {
    private List<BoxStatement> tryBody;
    private List<BoxTryCatch> catches;
    private List<BoxStatement> finallyBody;

    public BoxTry(List<BoxStatement> tryBody, List<BoxTryCatch> catches, List<BoxStatement> finallyBody, Position position, String sourceText) {
        super(position, sourceText);
        this.setTryBody(tryBody);
        this.setCatches(catches);
        this.setFinallyBody(finallyBody);
    }

    public List<BoxStatement> getTryBody() {
        return this.tryBody;
    }

    public List<BoxTryCatch> getCatches() {
        return this.catches;
    }

    public List<BoxStatement> getFinallyBody() {
        return this.finallyBody;
    }

    public void setTryBody(List<BoxStatement> tryBody) {
        this.replaceChildren(this.tryBody, tryBody);
        this.tryBody = tryBody;
        this.tryBody.forEach(arg -> arg.setParent(this));
    }

    public void setCatches(List<BoxTryCatch> catches) {
        this.replaceChildren(this.catches, catches);
        this.catches = catches;
        this.catches.forEach(arg -> arg.setParent(this));
    }

    public void setFinallyBody(List<BoxStatement> finallyBody) {
        this.replaceChildren(this.finallyBody, finallyBody);
        this.finallyBody = finallyBody;
        this.finallyBody.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("tryBody", this.tryBody.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        map.put("catches", this.catches.stream().map(BoxTryCatch::toMap).collect(Collectors.toList()));
        map.put("finallyBody", this.finallyBody.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

