/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxTryCatch
extends BoxStatement {
    private BoxIdentifier exception;
    private List<BoxStatement> catchBody;
    private List<BoxExpression> catchTypes;

    public BoxTryCatch(List<BoxExpression> catchTypes, BoxExpression exception, List<BoxStatement> catchBody, Position position, String sourceText) {
        super(position, sourceText);
        this.setCatchTypes(catchTypes);
        this.setException(exception);
        this.setCatchBody(catchBody);
    }

    public List<BoxStatement> getCatchBody() {
        return this.catchBody;
    }

    public BoxIdentifier getException() {
        return this.exception;
    }

    public List<BoxExpression> getCatchTypes() {
        return this.catchTypes;
    }

    public void setException(BoxExpression exception) {
        if (!(exception instanceof BoxIdentifier)) {
            throw new IllegalStateException("Exception must be a BoxIdentifier");
        }
        BoxIdentifier exp = (BoxIdentifier)exception;
        this.replaceChildren(this.exception, exp);
        this.exception = exp;
        this.exception.setParent(this);
    }

    public void setCatchBody(List<BoxStatement> catchBody) {
        this.replaceChildren(this.catchBody, catchBody);
        this.catchBody = catchBody;
        this.catchBody.forEach(arg -> arg.setParent(this));
    }

    public void setCatchTypes(List<BoxExpression> catchTypes) {
        this.replaceChildren(this.catchTypes, catchTypes);
        this.catchTypes = catchTypes;
        this.catchTypes.forEach(arg -> arg.setParent(this));
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("exception", this.exception.toMap());
        map.put("catchBody", this.catchBody.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        map.put("catchTypes", this.catchTypes.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

