/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.statement.component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Position;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class BoxComponent
extends BoxStatement {
    private String name;
    private List<BoxStatement> body;
    private List<BoxAnnotation> attributes;
    private int sourceStartIndex;
    public Boolean requiresBody = false;

    public BoxComponent(String name, List<BoxAnnotation> attributes, Position position, String sourceText) {
        this(name, attributes, null, 0, position, sourceText);
    }

    public BoxComponent(String name, List<BoxAnnotation> attributes, List<BoxStatement> body, Position position, String sourceText) {
        this(name, attributes, body, 0, position, sourceText);
    }

    public BoxComponent(String name, List<BoxAnnotation> attributes, List<BoxStatement> body, int sourceStartIndex, Position position, String sourceText) {
        super(position, sourceText);
        this.setName(name);
        this.setAttributes(attributes);
        this.setBody(body);
        this.setSourceStartIndex(sourceStartIndex);
    }

    public List<BoxStatement> getBody() {
        return this.body;
    }

    public List<BoxAnnotation> getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public int getSourceStartIndex() {
        return this.sourceStartIndex;
    }

    public void setSourceStartIndex(int sourceStartIndex) {
        this.sourceStartIndex = sourceStartIndex;
    }

    public void setBody(List<BoxStatement> body) {
        this.replaceChildren(this.body, body);
        this.body = body;
        if (this.body != null) {
            this.body.forEach(statement -> statement.setParent(this));
        }
    }

    public void setRequiresBody(Boolean requiresBody) {
        this.requiresBody = requiresBody;
    }

    public Boolean getRequiresBody() {
        return this.requiresBody;
    }

    public void setAttributes(List<BoxAnnotation> attributes) {
        this.replaceChildren(this.attributes, attributes);
        this.attributes = attributes;
        if (this.attributes != null) {
            this.attributes.forEach(arg -> arg.setParent(this));
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Object> toMap() {
        Map<String, Object> map = super.toMap();
        map.put("name", this.name);
        if (this.attributes != null) {
            map.put("attributes", this.attributes.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        } else {
            map.put("attributes", null);
        }
        if (this.body != null) {
            map.put("body", this.body.stream().map(BoxNode::toMap).collect(Collectors.toList()));
        } else {
            map.put("body", null);
        }
        return map;
    }

    @Override
    public void accept(VoidBoxVisitor v) {
        v.visit(this);
    }

    @Override
    public BoxNode accept(ReplacingBoxVisitor v) {
        return v.visit(this);
    }
}

