/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.comment.BoxSingleLineComment;
import ortus.boxlang.compiler.ast.expression.BoxAccess;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperator;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperator;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStringConcat;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructType;
import ortus.boxlang.compiler.ast.expression.BoxTernaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperator;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.visitor.ReplacingBoxVisitor;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.ModuleService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public class CFTranspilerVisitor
extends ReplacingBoxVisitor {
    private static Set<String> BIFReturnTypeFixSet = new HashSet<String>();
    private static Map<String, String> BIFMap = new HashMap<String, String>();
    private static Map<String, String> identifierMap = new HashMap<String, String>();
    private static Map<String, Map<String, String>> componentAttrMap = new HashMap<String, Map<String, String>>();
    private static Key transpilerKey = Key.of("transpiler");
    private static Key upperCaseKeysKey = Key.of("upperCaseKeys");
    private static Key forceOutputTrueKey = Key.of("forceOutputTrue");
    private static Key mergeDocsIntoAnnotationsKey = Key.of("mergeDocsIntoAnnotations");
    private static Key compatKey = Key.of("compat-cfml");
    private static BoxRuntime runtime = BoxRuntime.getInstance();
    private static ModuleService moduleService = runtime.getModuleService();
    private boolean isClass = false;
    private String className = "";
    private boolean upperCaseKeys = true;
    private boolean forceOutputTrue = true;
    private boolean mergeDocsIntoAnnotations = true;
    private Set<BoxBinaryOperator> binaryOpsHigherThanNot = Set.of(BoxBinaryOperator.Power, BoxBinaryOperator.Star, BoxBinaryOperator.Slash, BoxBinaryOperator.Backslash, BoxBinaryOperator.Mod, BoxBinaryOperator.Plus, BoxBinaryOperator.Minus, BoxBinaryOperator.Contains, BoxBinaryOperator.NotContains, BoxBinaryOperator.BitwiseAnd, BoxBinaryOperator.BitwiseOr, BoxBinaryOperator.BitwiseXor, BoxBinaryOperator.BitwiseSignedLeftShift, BoxBinaryOperator.BitwiseSignedRightShift, BoxBinaryOperator.BitwiseUnsignedRightShift);

    public CFTranspilerVisitor() {
        this(moduleService.hasModule(compatKey) ? StructCaster.cast(moduleService.getModuleSettings(compatKey)) : Struct.EMPTY);
    }

    public CFTranspilerVisitor(IStruct settings) {
        if (settings.containsKey(transpilerKey)) {
            if ((settings = StructCaster.cast(settings.get(transpilerKey))).containsKey(upperCaseKeysKey)) {
                this.upperCaseKeys = BooleanCaster.cast(settings.get(upperCaseKeysKey));
            }
            if (settings.containsKey(forceOutputTrueKey)) {
                this.forceOutputTrue = BooleanCaster.cast(settings.get(forceOutputTrueKey));
            }
            if (settings.containsKey(mergeDocsIntoAnnotationsKey)) {
                this.mergeDocsIntoAnnotations = BooleanCaster.cast(settings.get(mergeDocsIntoAnnotationsKey));
            }
        }
    }

    @Override
    public BoxNode visit(BoxClass node) {
        Source source;
        List<BoxAnnotation> annotations = node.getAnnotations();
        this.isClass = true;
        if (node.getPosition() != null && node.getPosition().getSource() != null && (source = node.getPosition().getSource()) instanceof SourceFile) {
            SourceFile sf = (SourceFile)source;
            File sourceFile = sf.getFile();
            this.className = sourceFile.getName().replaceFirst("[.][^.]+$", "");
        }
        this.mergeDocsIntoAnnotations(annotations, node.getDocumentation());
        if (annotations.stream().noneMatch(a -> a.getKey().getValue().equalsIgnoreCase("accessors")) && annotations.stream().noneMatch(a -> a.getKey().getValue().equalsIgnoreCase("extends"))) {
            annotations.add(new BoxAnnotation(new BoxFQN("accessors", null, null), new BoxBooleanLiteral(false, null, null), null, null));
        }
        this.enableOutput(annotations);
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxFunctionDeclaration node) {
        this.mergeDocsIntoAnnotations(node.getAnnotations(), node.getDocumentation());
        if (this.isClass) {
            this.enableOutput(node.getAnnotations());
            if (node.getName().equalsIgnoreCase("onCFCRequest") && this.className.equalsIgnoreCase("application")) {
                node.setName("onClassRequest");
            }
        }
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxProperty node) {
        this.mergeDocsIntoAnnotations(node.getAnnotations(), node.getDocumentation());
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxIdentifier node) {
        this.renameTopLevelVars(node);
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxArrayAccess node) {
        BoxStringLiteral str;
        String name;
        BoxExpression boxExpression = node.getAccess();
        if (boxExpression instanceof BoxStringLiteral && identifierMap.containsKey(name = (str = (BoxStringLiteral)boxExpression).getValue().toLowerCase())) {
            str.setValue(identifierMap.get(name));
        }
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxDotAccess node) {
        this.upperCaseDotAceessKeys(node);
        return super.visit(node);
    }

    private void upperCaseDotAceessKeys(BoxDotAccess node) {
        if (!this.upperCaseKeys) {
            return;
        }
        BoxExpression access = node.getAccess();
        if (access instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)access;
            id.setName(id.getName().toUpperCase());
        }
    }

    @Override
    public BoxNode visit(BoxStructLiteral node) {
        this.upperCaseStructLiteralKeys(node);
        return super.visit(node);
    }

    private void upperCaseStructLiteralKeys(BoxStructLiteral node) {
        if (!this.upperCaseKeys) {
            return;
        }
        for (int i = 0; i < node.getValues().size(); i += 2) {
            BoxExpression key = node.getValues().get(i);
            if (key instanceof BoxIdentifier) {
                BoxIdentifier id = (BoxIdentifier)key;
                id.setName(id.getName().toUpperCase());
                continue;
            }
            if (!(key instanceof BoxScope)) continue;
            BoxScope s = (BoxScope)key;
            s.setName(s.getName().toUpperCase());
        }
    }

    @Override
    public BoxNode visit(BoxFunctionInvocation node) {
        String name = node.getName().toLowerCase();
        if (BIFMap.containsKey(name)) {
            node.setName(BIFMap.get(name));
        }
        if (name.equalsIgnoreCase("structKeyExists") && node.getArguments().size() == 2) {
            return this.transpileStructKeyExists(node);
        }
        if (name.equalsIgnoreCase("valueList") && node.getArguments().size() > 0 && node.getArguments().get(0).getValue() instanceof BoxAccess) {
            return this.transpileValueList(node);
        }
        if (name.equalsIgnoreCase("quotedValueList") && node.getArguments().size() > 0 && node.getArguments().get(0).getValue() instanceof BoxAccess) {
            return this.transpileQuotedValueList(node);
        }
        if (BIFReturnTypeFixSet.contains(name) && this.returnValueIsUsed(node)) {
            return this.transpileBIFReturnType(node, name);
        }
        return super.visit(node);
    }

    private BoxNode transpileBIFReturnType(BoxFunctionInvocation node, String name) {
        List<BoxArgument> args = node.getArguments();
        ArrayList<BoxStatement> bodyStatements = new ArrayList<BoxStatement>();
        bodyStatements.add(new BoxExpressionStatement(new BoxFunctionInvocation(node.getName(), this.generateBIFArgs(args), null, null), null, null));
        if (name.equals("arraydelete")) {
            bodyStatements.addFirst(new BoxExpressionStatement(new BoxAssignment(new BoxDotAccess(new BoxIdentifier("local", null, null), false, new BoxIdentifier("__len", null, null), null, null), BoxAssignmentOperator.Equal, new BoxFunctionInvocation("arrayLen", this.generateArrayLenArgs(args), null, null), List.of(), null, null), null, null));
            bodyStatements.add(new BoxReturn(new BoxComparisonOperation(new BoxFunctionInvocation("arrayLen", this.generateArrayLenArgs(args), null, null), BoxComparisonOperator.LessThan, new BoxDotAccess(new BoxIdentifier("local", null, null), false, new BoxIdentifier("__len", null, null), null, null), null, null), null, null));
        } else if (name.equals("structdelete")) {
            bodyStatements.addFirst(new BoxExpressionStatement(new BoxAssignment(new BoxDotAccess(new BoxIdentifier("local", null, null), false, new BoxIdentifier("__existed", null, null), null, null), BoxAssignmentOperator.Equal, new BoxFunctionInvocation("structKeyExists", this.generateBIFArgs(args), null, null), List.of(), null, null), null, null));
            BoxIdentifier indicateNotExistsExpresssion = null;
            if (args.get(0).getName() == null && args.size() > 2) {
                indicateNotExistsExpresssion = new BoxIdentifier("arg3", null, null);
            } else if (args.get(0).getName() != null) {
                for (BoxArgument arg : args) {
                    String argName = ((BoxStringLiteral)arg.getName()).getValue();
                    if (!argName.equalsIgnoreCase("indicateNotExisting")) continue;
                    indicateNotExistsExpresssion = new BoxIdentifier(argName, null, null);
                    break;
                }
            }
            if (indicateNotExistsExpresssion != null) {
                bodyStatements.add(new BoxReturn(new BoxTernaryOperation(indicateNotExistsExpresssion, new BoxDotAccess(new BoxIdentifier("local", null, null), false, new BoxIdentifier("__existed", null, null), null, null), new BoxBooleanLiteral(true, null, null), null, null), null, null));
            }
        }
        bodyStatements.add(new BoxReturn(new BoxBooleanLiteral(true, null, null), null, null));
        BoxLambda lambda = new BoxLambda(this.generateIIFEArgs(args), List.of(), new BoxStatementBlock(bodyStatements, null, null), null, null);
        return new BoxExpressionInvocation(new BoxParenthesis(lambda, null, null), args, null, null).addComment(new BoxSingleLineComment("Transpiler workaround for BIF return type", null, null));
    }

    private List<BoxArgument> generateBIFArgs(List<BoxArgument> args) {
        if (args.size() == 0 || args.get(0).getName() == null) {
            return args.stream().map(a -> new BoxArgument(new BoxIdentifier("arg" + (args.indexOf(a) + 1), null, null), null, null)).collect(Collectors.toList());
        }
        return args.stream().map(a -> new BoxArgument(a.getName(), new BoxIdentifier(((BoxStringLiteral)a.getName()).getValue(), null, null), null, null)).collect(Collectors.toList());
    }

    private List<BoxArgument> generateArrayLenArgs(List<BoxArgument> args) {
        if (args.size() == 0 || args.get(0).getName() == null) {
            return List.of(new BoxArgument(new BoxIdentifier("arg1", null, null), null, null));
        }
        return List.of(new BoxArgument(new BoxIdentifier("array", null, null), null, null));
    }

    private List<BoxArgumentDeclaration> generateIIFEArgs(List<BoxArgument> args) {
        if (args.size() == 0 || args.get(0).getName() == null) {
            return args.stream().map(a -> new BoxArgumentDeclaration(false, null, "arg" + (args.indexOf(a) + 1), null, List.of(), List.of(), null, null)).collect(Collectors.toList());
        }
        return args.stream().map(a -> new BoxArgumentDeclaration(false, null, ((BoxStringLiteral)a.getName()).getValue(), null, List.of(), List.of(), null, null)).collect(Collectors.toList());
    }

    private boolean returnValueIsUsed(BoxExpression node) {
        BoxForIndex f;
        BoxSwitch s;
        BoxDo d;
        BoxWhile w;
        BoxIfElse ife;
        if (node.getParent() instanceof BoxExpression) {
            return true;
        }
        if (node.getParent() instanceof BoxReturn) {
            return true;
        }
        BoxNode boxNode = node.getParent();
        if (boxNode instanceof BoxIfElse && (ife = (BoxIfElse)boxNode).getCondition() == node) {
            return true;
        }
        boxNode = node.getParent();
        if (boxNode instanceof BoxWhile && (w = (BoxWhile)boxNode).getCondition() == node) {
            return true;
        }
        boxNode = node.getParent();
        if (boxNode instanceof BoxDo && (d = (BoxDo)boxNode).getCondition() == node) {
            return true;
        }
        boxNode = node.getParent();
        if (boxNode instanceof BoxSwitch && (s = (BoxSwitch)boxNode).getCondition() == node) {
            return true;
        }
        boxNode = node.getParent();
        return boxNode instanceof BoxForIndex && (f = (BoxForIndex)boxNode).getCondition() == node;
    }

    private BoxNode transpileQuotedValueList(BoxFunctionInvocation node) {
        BoxAccess queryCol = (BoxAccess)node.getArguments().get(0).getValue();
        ArrayList<BoxArgument> toListArguments = new ArrayList<BoxArgument>();
        if (node.getArguments().size() > 1) {
            toListArguments.add(node.getArguments().get(1));
        }
        BoxMethodInvocation mapExpr = new BoxMethodInvocation(new BoxIdentifier("map", null, null), new BoxFunctionInvocation("queryColumnData", List.of(new BoxArgument(queryCol.getContext(), null, null), new BoxArgument(queryCol instanceof BoxDotAccess ? new BoxStringLiteral(((BoxIdentifier)queryCol.getAccess()).getName(), null, null) : queryCol.getAccess(), null, null)), null, null), List.of(new BoxArgument(new BoxLambda(List.of(new BoxArgumentDeclaration(true, "any", "arr", null, List.of(), List.of(), null, null)), List.of(), new BoxExpressionStatement(new BoxStringConcat(List.of(new BoxStringLiteral("\"", null, null), new BoxIdentifier("arr", null, null), new BoxStringLiteral("\"", null, null)), null, null), null, null), null, null), null, null)), null, null);
        BoxMethodInvocation newInvocation = new BoxMethodInvocation(new BoxIdentifier("toList", null, null), mapExpr, toListArguments, null, null);
        return super.visit(newInvocation);
    }

    private BoxNode transpileValueList(BoxFunctionInvocation node) {
        BoxAccess queryCol = (BoxAccess)node.getArguments().get(0).getValue();
        ArrayList<BoxArgument> toListArguments = new ArrayList<BoxArgument>();
        if (node.getArguments().size() > 1) {
            toListArguments.add(node.getArguments().get(1));
        }
        BoxMethodInvocation newInvocation = new BoxMethodInvocation(new BoxIdentifier("toList", null, null), new BoxFunctionInvocation("queryColumnData", List.of(new BoxArgument(queryCol.getContext(), null, null), new BoxArgument(queryCol instanceof BoxDotAccess ? new BoxStringLiteral(((BoxIdentifier)queryCol.getAccess()).getName(), null, null) : queryCol.getAccess(), null, null)), null, null), toListArguments, false, true, null, null);
        return super.visit(newInvocation);
    }

    private BoxNode transpileStructKeyExists(BoxFunctionInvocation node) {
        BoxUnaryOperation newNode = new BoxUnaryOperation(new BoxFunctionInvocation("isNull", List.of(new BoxArgument(new BoxArrayAccess(node.getArguments().get(0).getValue(), true, node.getArguments().get(1).getValue(), null, null), null, null)), null, null), BoxUnaryOperator.Not, null, null);
        return super.visit(newNode);
    }

    @Override
    public BoxNode visit(BoxComponent node) {
        if (componentAttrMap.containsKey(node.getName().toLowerCase())) {
            List<BoxAnnotation> attrs = node.getAttributes();
            Map<String, String> attrMap = componentAttrMap.get(node.getName().toLowerCase());
            for (BoxAnnotation attr2 : attrs) {
                String key = attr2.getKey().getValue().toLowerCase();
                if (!attrMap.containsKey(key)) continue;
                attr2.getKey().setValue(attrMap.get(key));
            }
            attrs.stream().forEach(attr -> {
                if (attr.getKey().getValue().equalsIgnoreCase("attributeCollection")) {
                    node.addComment(new BoxSingleLineComment("Transpiler workaround for runtime transpilation of attributeCollection", null, null));
                    List<BoxExpression> keyList = attrMap.keySet().stream().flatMap(k -> Stream.of(new BoxStringLiteral((String)k, null, null), new BoxStringLiteral((String)attrMap.get(k), null, null))).collect(Collectors.toList());
                    attr.setValue(new BoxFunctionInvocation("transpileCollectionKeySwap", List.of(new BoxArgument(attr.getValue(), null, null), new BoxArgument(new BoxStructLiteral(BoxStructType.Unordered, keyList, null, null), null, null)), null, null));
                }
            });
        }
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxBinaryOperation node) {
        BoxUnaryOperation buo;
        BoxExpression left = node.getLeft();
        if (this.binaryOpsHigherThanNot.contains((Object)node.getOperator()) && left instanceof BoxUnaryOperation && (buo = (BoxUnaryOperation)left).getOperator() == BoxUnaryOperator.Not) {
            node.setLeft(buo.getExpr());
            BoxParenthesis parenNode = new BoxParenthesis(node, node.getPosition(), node.getSourceText());
            return this.visit(new BoxUnaryOperation(parenNode, BoxUnaryOperator.Not, node.getPosition(), node.getSourceText()));
        }
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxComparisonOperation node) {
        BoxUnaryOperation buo;
        BoxExpression left = node.getLeft();
        if (left instanceof BoxUnaryOperation && (buo = (BoxUnaryOperation)left).getOperator() == BoxUnaryOperator.Not) {
            node.setLeft(buo.getExpr());
            BoxParenthesis parenNode = new BoxParenthesis(node, node.getPosition(), node.getSourceText());
            return this.visit(new BoxUnaryOperation(parenNode, BoxUnaryOperator.Not, node.getPosition(), node.getSourceText()));
        }
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxStringConcat node) {
        BoxUnaryOperation buo;
        BoxExpression boxExpression;
        List<BoxExpression> values = node.getValues();
        if (values.size() == 2 && (boxExpression = values.get(0)) instanceof BoxUnaryOperation && (buo = (BoxUnaryOperation)boxExpression).getOperator() == BoxUnaryOperator.Not) {
            values.set(0, buo.getExpr());
            node.setValues(values);
            BoxParenthesis parenNode = new BoxParenthesis(node, node.getPosition(), node.getSourceText());
            return this.visit(new BoxUnaryOperation(parenNode, BoxUnaryOperator.Not, node.getPosition(), node.getSourceText()));
        }
        return super.visit(node);
    }

    private void mergeDocsIntoAnnotations(List<BoxAnnotation> annotations, List<BoxDocumentationAnnotation> documentation) {
        if (!this.mergeDocsIntoAnnotations) {
            return;
        }
        Set existingAnnotations = annotations.stream().map(BoxAnnotation::getKey).map(BoxFQN::getValue).map(k -> k.toLowerCase()).collect(Collectors.toSet());
        for (BoxDocumentationAnnotation doc : documentation) {
            if (doc.getKey().getValue().equalsIgnoreCase("hint") || existingAnnotations.contains(doc.getKey().getValue().toLowerCase())) continue;
            BoxExpression value = doc.getValue();
            if (value instanceof BoxStringLiteral) {
                BoxStringLiteral bsl = (BoxStringLiteral)value;
                bsl.setValue(bsl.getValue().trim());
                if (bsl.getValue().isEmpty()) {
                    value = null;
                }
            }
            annotations.add(new BoxAnnotation(new BoxFQN(doc.getKey().getValue(), null, null), value, null, null));
        }
    }

    @Override
    public BoxNode visit(BoxBufferOutput node) {
        BoxStringLiteral str;
        BoxExpression expr;
        if (this.isClass && (expr = node.getExpression()) instanceof BoxStringLiteral && (str = (BoxStringLiteral)expr).getValue().trim().isEmpty()) {
            return null;
        }
        return super.visit(node);
    }

    @Override
    public BoxNode visit(BoxNew node) {
        BoxFQN fqn;
        String name;
        BoxExpression boxExpression;
        if (!node.getArguments().isEmpty() && node.getPrefix() == null && (boxExpression = node.getExpression()) instanceof BoxFQN && ((name = (fqn = (BoxFQN)boxExpression).getValue().toLowerCase()).equals("java") || name.equals("component"))) {
            ArrayList<BoxArgument> args = new ArrayList<BoxArgument>();
            args.add(new BoxArgument(new BoxStringLiteral(name, fqn.getPosition(), fqn.getSourceText()), fqn.getPosition(), fqn.getSourceText()));
            args.addAll(node.getArguments());
            BoxFunctionInvocation newExpr = new BoxFunctionInvocation("createObject", args, node.getPosition(), node.getSourceText());
            return super.visit(newExpr);
        }
        return super.visit(node);
    }

    private void enableOutput(List<BoxAnnotation> annotations) {
        if (!this.forceOutputTrue) {
            return;
        }
        if (annotations.stream().noneMatch(a -> a.getKey().getValue().equalsIgnoreCase("output"))) {
            annotations.add(new BoxAnnotation(new BoxFQN("output", null, null), new BoxBooleanLiteral(true, null, null), null, null));
        }
    }

    private void renameTopLevelVars(BoxIdentifier id) {
        String name = id.getName().toLowerCase();
        if (identifierMap.containsKey(name) && !this.isInFunctionWithArgNamed(id, name)) {
            id.setName(identifierMap.get(name));
        }
    }

    private boolean isInFunctionWithArgNamed(BoxNode node, String name) {
        return node.getFirstAncestorOfType(BoxFunctionDeclaration.class, funcDec -> funcDec.getArgs().stream().anyMatch(a -> a.getName().equalsIgnoreCase(name))) != null;
    }

    static {
        BIFMap.put("asc", "ascii");
        BIFMap.put("chr", "char");
        BIFMap.put("deserializejson", "JSONDeserialize");
        BIFMap.put("getapplicationsettings", "getApplicationMetadata");
        BIFMap.put("gettemplatepath", "getBaseTemplatePath");
        BIFMap.put("serializejson", "JSONSerialize");
        BIFMap.put("valuearray", "queryColumnData");
        BIFMap.put("objectSave", "objectSerialize");
        BIFMap.put("objectLoad", "objectDeserialize");
        BIFMap.put("querygetrow", "queryrowdata");
        identifierMap.put("cfthread", "bxthread");
        identifierMap.put("cfcatch", "bxcatch");
        identifierMap.put("cffile", "bxfile");
        identifierMap.put("cfftp", "bxftp");
        identifierMap.put("cfhttp", "bxhttp");
        identifierMap.put("cfquery", "bxquery");
        identifierMap.put("cfdocument", "bxdocument");
        identifierMap.put("cfstoredproc", "bxstoredproc");
        componentAttrMap.put("setting", Map.of("enablecfoutputonly", "enableoutputonly"));
        componentAttrMap.put("invoke", Map.of("component", "class"));
        componentAttrMap.put("procparam", Map.of("cfsqltype", "sqltype"));
        componentAttrMap.put("queryparam", Map.of("cfsqltype", "sqltype"));
        BIFReturnTypeFixSet.add("arrayappend");
        BIFReturnTypeFixSet.add("arrayclear");
        BIFReturnTypeFixSet.add("arraydeleteat");
        BIFReturnTypeFixSet.add("arrayinsertat");
        BIFReturnTypeFixSet.add("arrayprepend");
        BIFReturnTypeFixSet.add("arrayresize");
        BIFReturnTypeFixSet.add("arrayset");
        BIFReturnTypeFixSet.add("arrayswap");
        BIFReturnTypeFixSet.add("structclear");
        BIFReturnTypeFixSet.add("structkeytranslate");
        BIFReturnTypeFixSet.add("structinsert");
        BIFReturnTypeFixSet.add("structdelete");
        BIFReturnTypeFixSet.add("structappend");
        BIFReturnTypeFixSet.add("structget");
        BIFReturnTypeFixSet.add("querysetrow");
        BIFReturnTypeFixSet.add("querydeleterow");
        BIFReturnTypeFixSet.add("querysort");
        BIFReturnTypeFixSet.add("arraydelete");
    }
}

