/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.expression.IBoxSimpleLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;
import ortus.boxlang.compiler.javaboxpiler.transformer.BoxClassTransformer;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.loader.resolvers.BoxResolver;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.types.exceptions.ParseException;
import ortus.boxlang.runtime.util.FQN;
import ortus.boxlang.runtime.util.FileSystemUtil;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class ClassMetadataVisitor
extends VoidBoxVisitor {
    private IStruct meta = Struct.of(new Object[]{Key._NAME, null, Key.nameAsKey, null, Key.documentation, Struct.of(new Object[0]), Key.annotations, Struct.of(new Object[0]), Key._EXTENDS, Struct.of(new Object[0]), Key.functions, Array.of(new Object[0]), Key.properties, Array.of(new Object[0]), Key.type, null, Key.fullname, null, Key.path, null});
    private boolean accessors = false;
    private Path sourcePath;
    private IBoxContext context;
    private BoxResolver boxResolver;

    public ClassMetadataVisitor(IBoxContext context) {
        this.context = context;
        this.boxResolver = ClassLocator.getInstance().getBoxResolver();
    }

    public ClassMetadataVisitor() {
        this(BoxRuntime.getInstance().getRuntimeContext());
    }

    public IStruct getMetadata() {
        return this.meta;
    }

    @Override
    public void visit(BoxClass node) {
        CastAttempt<Boolean> boolAccessors;
        this.meta.put(Key.type, (Object)"class");
        this.meta.put(Key._NAME, (Object)"");
        this.meta.put(Key.fullname, (Object)"");
        this.meta.put(Key.nameAsKey, (Object)Key.of(""));
        this.meta.put(Key.annotations, (Object)this.processAnnotations(node.getAnnotations()));
        this.meta.put(Key.documentation, (Object)this.processDocumentation(node.getDocumentation()));
        Object accessorsAnnotation = this.meta.getAsStruct(Key.annotations).get(Key.accessors);
        this.accessors = accessorsAnnotation != null ? (boolAccessors = BooleanCaster.attempt(accessorsAnnotation)).wasSuccessful() && boolAccessors.get() != false : true;
        this.processName(node);
        if (this.meta.getAsStruct(Key.annotations).containsKey(Key._EXTENDS)) {
            this.meta.put(Key._EXTENDS, (Object)this.processSuper(this.meta.getAsStruct(Key.annotations).getAsString(Key._EXTENDS)));
        }
        super.visit(node);
    }

    @Override
    public void visit(BoxInterface node) {
        this.meta.put(Key.type, (Object)"interface");
        this.meta.put(Key._NAME, (Object)"");
        this.meta.put(Key.fullname, (Object)"");
        this.meta.put(Key.nameAsKey, (Object)Key.of(""));
        this.processName(node);
        super.visit(node);
    }

    @Override
    public void visit(BoxProperty prop) {
        List<BoxAnnotation> finalAnnotations = BoxClassTransformer.normlizePropertyAnnotations(prop);
        BoxAnnotation nameAnnotation = finalAnnotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("name")).findFirst().orElseThrow(() -> new ExpressionException("Property [" + prop.getSourceText() + "] missing name annotation", prop));
        BoxAnnotation typeAnnotation = finalAnnotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("type")).findFirst().orElseThrow(() -> new ExpressionException("Property [" + prop.getSourceText() + "] missing type annotation", prop));
        BoxAnnotation defaultAnnotation = finalAnnotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("default")).findFirst().orElse(null);
        String name = this.getBoxExprAsSimpleValue(nameAnnotation.getValue()).toString();
        String type = this.getBoxExprAsSimpleValue(typeAnnotation.getValue()).toString();
        this.meta.getAsArray(Key.properties).add(Struct.of(new Object[]{Key._NAME, name, Key.nameAsKey, Key.of(name), Key.type, type, Key.defaultValue, this.getBoxExprAsSimpleValue(defaultAnnotation.getValue(), "[Runtime Expression]", false), Key.annotations, this.processAnnotations(prop.getAllAnnotations()), Key.documentation, this.processDocumentation(prop.getDocumentation())}));
        if (this.accessors) {
            this.meta.getAsArray(Key.functions).add(Struct.of(new Object[]{Key._NAME, "get" + name, Key.nameAsKey, Key.of("get" + name), Key.returnType, type, Key.access, "public", Key.documentation, Struct.of(new Object[0]), Key.annotations, Struct.of(new Object[0]), Key.parameters, Array.of(new Object[0]), Key.closure, false, Key.lambda, false}));
            this.meta.getAsArray(Key.functions).add(Struct.of(new Object[]{Key._NAME, "set" + name, Key.nameAsKey, Key.of("set" + name), Key.returnType, "void", Key.access, "public", Key.documentation, Struct.of(new Object[0]), Key.annotations, Struct.of(new Object[0]), Key.parameters, this.processArguments(List.of(new BoxArgumentDeclaration(true, type, name, null, List.of(), List.of(), null, null))), Key.closure, false, Key.lambda, false}));
        }
    }

    @Override
    public void visit(BoxFunctionDeclaration func) {
        BoxReturnType boxReturnType = func.getType();
        BoxType returnType = BoxType.Any;
        String fqn = null;
        if (boxReturnType != null && (returnType = boxReturnType.getType()).equals((Object)BoxType.Fqn)) {
            fqn = boxReturnType.getFqn();
        }
        this.meta.getAsArray(Key.functions).add(Struct.of(new Object[]{Key._NAME, func.getName(), Key.nameAsKey, func.getName(), Key.returnType, returnType.equals((Object)BoxType.Fqn) ? fqn : returnType.name(), Key.access, func.getAccessModifier() != null ? func.getAccessModifier().name().toLowerCase() : "public", Key.documentation, this.processDocumentation(func.getDocumentation()), Key.annotations, this.processAnnotations(func.getAnnotations()), Key.parameters, this.processArguments(func.getArgs()), Key.closure, false, Key.lambda, false}));
    }

    private IStruct processSuper(String superName) {
        if (this.sourcePath != null) {
            this.context.pushTemplate(ResolvedFilePath.of(this.sourcePath));
        }
        Optional<ClassLocator.ClassLocation> superLookup = this.boxResolver.resolve(this.context, superName, false);
        if (this.sourcePath != null) {
            this.context.popTemplate();
        }
        if (!superLookup.isPresent()) {
            throw new BoxRuntimeException("Super class [" + superName + "] not found");
        }
        String superDiskPath = superLookup.get().path();
        ParsingResult result = new Parser().parse(Paths.get(superDiskPath, new String[0]).toAbsolutePath().toFile());
        if (!result.isCorrect()) {
            throw new ParseException(result.getIssues(), "");
        }
        ClassMetadataVisitor visitor = new ClassMetadataVisitor();
        result.getRoot().accept(visitor);
        return visitor.getMetadata();
    }

    private void processName(BoxNode node) {
        Source source;
        if (node.getPosition() != null && node.getPosition().getSource() != null && (source = node.getPosition().getSource()) instanceof SourceFile) {
            SourceFile sf = (SourceFile)source;
            File sourceFile = sf.getFile();
            this.sourcePath = sourceFile.toPath();
            ResolvedFilePath contractedPath = FileSystemUtil.contractPath(this.context, sourceFile.toString());
            String name = sourceFile.getName().replaceFirst("[.][^.]+$", "");
            String packageName = FQN.of(Paths.get(contractedPath.relativePath(), new String[0])).getPackageString();
            String fullName = packageName.length() > 0 ? packageName + "." + name : name;
            this.meta.put(Key._NAME, (Object)name);
            this.meta.put(Key.fullname, (Object)fullName);
            this.meta.put(Key.nameAsKey, (Object)Key.of(fullName));
            this.meta.put(Key.path, (Object)sourceFile.getAbsolutePath());
        }
    }

    private Array processArguments(List<BoxArgumentDeclaration> arguments) {
        Array arr = Array.of(new Object[0]);
        arguments.forEach(argument -> arr.add(Struct.of(new Object[]{Key._NAME, argument.getName(), Key.nameAsKey, Key.of(argument.getName()), Key.required, argument.getRequired(), Key.type, argument.getType() != null ? argument.getType() : "any", Key._DEFAULT, this.getBoxExprAsSimpleValue(argument.getValue(), "[Runtime Expression]", false), Key.documentation, this.processDocumentation(argument.getDocumentation()), Key.annotations, this.processAnnotations(argument.getAnnotations())})));
        return arr;
    }

    private IStruct processAnnotations(List<BoxAnnotation> annotations) {
        IStruct struct = Struct.of(new Object[0]);
        annotations.forEach(annotation -> {
            String key = this.getBoxExprAsSimpleValue(annotation.getKey()).toString();
            Object value = this.getBoxExprAsLiteralValue(annotation.getValue());
            struct.put(key, value);
        });
        return struct;
    }

    private IStruct processDocumentation(List<BoxDocumentationAnnotation> documentation) {
        IStruct struct = Struct.of(new Object[0]);
        documentation.forEach(annotation -> {
            String key = this.getBoxExprAsSimpleValue(annotation.getKey()).toString();
            Object value = this.getBoxExprAsSimpleValue(annotation.getValue());
            struct.put(key, value);
        });
        return struct;
    }

    private Object getBoxExprAsSimpleValue(BoxExpression expr) {
        return this.getBoxExprAsSimpleValue(expr, null, false);
    }

    private Object getBoxExprAsSimpleValue(BoxExpression expr, Object defaultValue, boolean identifierAsText) {
        if (expr == null) {
            return "";
        }
        if (expr instanceof IBoxSimpleLiteral) {
            IBoxSimpleLiteral lit = (IBoxSimpleLiteral)((Object)expr);
            return lit.getValue();
        }
        if (expr instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)expr;
            return fqn.getValue();
        }
        if (identifierAsText && expr instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)expr;
            return id.getName();
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new ExpressionException("Unsupported BoxExpr type: " + expr.getClass().getSimpleName(), expr);
    }

    private Object getBoxExprAsLiteralValue(BoxExpression expr) {
        if (expr == null) {
            return "";
        }
        if (expr instanceof IBoxSimpleLiteral) {
            IBoxSimpleLiteral lit = (IBoxSimpleLiteral)((Object)expr);
            return lit.getValue();
        }
        if (expr instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)expr;
            return fqn.getValue();
        }
        if (expr instanceof BoxArrayLiteral) {
            BoxArrayLiteral arr = (BoxArrayLiteral)expr;
            Array array = Array.of(new Object[0]);
            arr.getValues().forEach(value -> array.add(this.getBoxExprAsLiteralValue((BoxExpression)value)));
            return array;
        }
        if (expr instanceof BoxStructLiteral) {
            BoxStructLiteral str = (BoxStructLiteral)expr;
            IStruct struct = Struct.of(new Object[0]);
            Iterator<BoxExpression> iterator = str.getValues().iterator();
            while (iterator.hasNext()) {
                BoxExpression key = iterator.next();
                if (iterator.hasNext()) {
                    BoxExpression value2 = iterator.next();
                    struct.put(Key.of(this.getBoxExprAsSimpleValue(key, null, true)), this.getBoxExprAsLiteralValue(value2));
                    continue;
                }
                throw new IllegalArgumentException("Invalid number of values in BoxStructLiteral");
            }
            return struct;
        }
        throw new ExpressionException("Non-literal value in BoxExpr type: " + expr.getClass().getSimpleName(), expr);
    }
}

