/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.util.ArrayList;
import java.util.List;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class MissingQueryParamVisitor
extends VoidBoxVisitor {
    List<Issue> issues = new ArrayList<Issue>();

    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public void visit(BoxComponent node) {
        if (node.getName().equalsIgnoreCase("query")) {
            node.getBody().forEach(s -> this.checkNode((BoxNode)s));
        }
        super.visit(node);
    }

    private void checkNode(BoxNode node) {
        BoxComponent bc;
        if (node instanceof BoxStringInterpolation) {
            if (node.getFirstAncestorOfType(BoxComponent.class, n -> n.getName().equalsIgnoreCase("queryparam")) == null) {
                this.issues.add(new Issue("Query contains unparameterized variable output on line " + node.getPosition().getStart().getLine() + " -- " + node.toString(), node));
            }
        } else if (!(node instanceof BoxComponent) || !(bc = (BoxComponent)node).getName().equalsIgnoreCase("queryparam")) {
            node.getChildren().forEach(this::checkNode);
        }
    }

    public record Issue(String message, BoxNode expr) {
    }
}

