/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.util.Stack;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.BoxStaticInitializer;
import ortus.boxlang.compiler.ast.BoxTemplate;
import ortus.boxlang.compiler.ast.comment.BoxComment;
import ortus.boxlang.compiler.ast.comment.BoxDocComment;
import ortus.boxlang.compiler.ast.comment.BoxMultiLineComment;
import ortus.boxlang.compiler.ast.comment.BoxSingleLineComment;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxDecimalLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalBIFAccess;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalMemberAccess;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNegateOperation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStaticAccess;
import ortus.boxlang.compiler.ast.expression.BoxStaticMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxStringConcat;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructType;
import ortus.boxlang.compiler.ast.expression.BoxTernaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxAssert;
import ortus.boxlang.compiler.ast.statement.BoxBreak;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.BoxContinue;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxParam;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxRethrow;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxScriptIsland;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.statement.BoxThrow;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.statement.component.BoxTemplateIsland;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class PrettyPrintBoxVisitor
extends VoidBoxVisitor {
    private StringBuffer buffer = new StringBuffer();
    private String indent = "\t";
    private String lineBreak = "\n";
    private int indentLevel = 0;
    BoxNode lastNodeToPrint = new BoxNull(null, null);
    private Stack<BoxSourceType> currentSourceType = new Stack();

    public PrettyPrintBoxVisitor() {
        this.currentSourceType.push(BoxSourceType.BOXSCRIPT);
    }

    private boolean isTemplate() {
        return this.currentSourceType.peek().equals((Object)BoxSourceType.BOXTEMPLATE);
    }

    private void trimTrailingSpaceFromBuffer() {
        int lastLineBreak = this.buffer.lastIndexOf(this.lineBreak);
        if (lastLineBreak != -1) {
            int lastChar;
            for (int i = lastChar = this.buffer.length() - 1; i > lastLineBreak && (this.buffer.charAt(i) == ' ' || this.buffer.charAt(i) == '\t'); --i) {
                this.buffer.deleteCharAt(i);
            }
        }
    }

    private void newLine() {
        this.trimTrailingSpaceFromBuffer();
        this.buffer.append(this.lineBreak);
        this.printIndent();
    }

    private void newLineIfNeeded() {
        if (this.buffer.isEmpty()) {
            return;
        }
        if (this.isTemplate()) {
            return;
        }
        this.trimTrailingSpaceFromBuffer();
        if (this.buffer.length() == 0 || !this.buffer.substring(this.buffer.length() - this.lineBreak.length()).equals(this.lineBreak)) {
            this.buffer.append(this.lineBreak);
        }
        this.printIndent();
    }

    private void print(String s) {
        this.buffer.append(s);
    }

    private void println(String s) {
        this.buffer.append(s);
        this.newLine();
    }

    public void printMultiLine(String text) {
        String[] lines = text.split("\\r?\\n", -1);
        int numLines = lines.length;
        boolean first = true;
        for (int i = 0; i < numLines; ++i) {
            boolean last;
            boolean bl = last = i == numLines - 1;
            if (!first && !last) {
                this.print(" * ");
            } else if (numLines > 1 && last) {
                this.print(" ");
            }
            if (last) {
                this.print(lines[i]);
            } else {
                this.println(lines[i]);
            }
            first = false;
        }
    }

    private void printPreOnlyComments(BoxNode node) {
        boolean printed = false;
        for (BoxComment comment : node.getComments()) {
            if (!comment.isBefore(node)) continue;
            if (!comment.startsOnEndLineOf(this.lastNodeToPrint)) {
                this.newLineIfNeeded();
            }
            comment.accept(this);
            printed = true;
            this.lastNodeToPrint = comment;
        }
        if (printed && !node.startsOnEndLineOf(this.lastNodeToPrint)) {
            this.newLineIfNeeded();
        }
    }

    private void printPreComments(BoxNode node) {
        boolean printed = false;
        for (BoxComment comment : node.getComments()) {
            if (comment.isAfter(node)) continue;
            if (!comment.startsOnEndLineOf(this.lastNodeToPrint)) {
                this.newLineIfNeeded();
            }
            comment.accept(this);
            printed = true;
            this.lastNodeToPrint = comment;
        }
        if (printed && !node.startsOnEndLineOf(this.lastNodeToPrint)) {
            this.newLineIfNeeded();
        }
    }

    private void printInsideComments(BoxNode node) {
        for (BoxComment comment : node.getComments()) {
            if (!comment.isInside(node)) continue;
            comment.accept(this);
            this.lastNodeToPrint = comment;
            this.newLine();
        }
    }

    private void printPostComments(BoxNode node) {
        this.lastNodeToPrint = node;
        for (BoxComment comment : node.getComments()) {
            if (!comment.isAfter(node)) continue;
            this.print(" ");
            comment.accept(this);
            this.lastNodeToPrint = comment;
        }
    }

    public String getOutput() {
        return this.buffer.toString();
    }

    private void increaseIndent() {
        ++this.indentLevel;
    }

    private void decreaseIndent() {
        --this.indentLevel;
        if (!this.isTemplate() && this.buffer.length() >= this.indent.length() && this.buffer.substring(this.buffer.length() - this.indent.length()).equals(this.indent)) {
            this.buffer.delete(this.buffer.length() - this.indent.length(), this.buffer.length());
        }
    }

    private void printIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.buffer.append(this.indent);
        }
    }

    @Override
    public void visit(BoxScript node) {
        this.printPreComments(node);
        for (BoxStatement statement : node.getStatements()) {
            statement.accept(this);
            this.newLineIfNeeded();
        }
        this.printPostComments(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(BoxBufferOutput node) {
        this.printPreComments(node);
        this.printPreComments(node.getExpression());
        if (this.isTemplate()) {
            BoxExpression boxExpression = node.getExpression();
            if (boxExpression instanceof BoxStringLiteral) {
                BoxStringLiteral sLit = (BoxStringLiteral)boxExpression;
                String value = sLit.getValue();
                if (node.getFirstAncestorOfType(BoxComponent.class, comp -> comp.getName().equalsIgnoreCase("output")) != null) {
                    value = value.replace("#", "##");
                }
                this.print(value);
            } else {
                boxExpression = node.getExpression();
                if (!(boxExpression instanceof BoxStringInterpolation)) throw new BoxRuntimeException("Unexpected expression in buffer output: " + node.getExpression().getClass().getName());
                BoxStringInterpolation sInt = (BoxStringInterpolation)boxExpression;
                this.processStringInterp(sInt, false);
            }
        } else {
            this.print("echo( \"");
            this.doQuotedExpression(node.getExpression());
            this.print("\" )");
        }
        this.printPostComments(node.getExpression());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxClass node) {
        for (BoxImport importNode : node.getImports()) {
            importNode.accept(this);
            this.newLine();
        }
        this.printPreOnlyComments(node);
        for (BoxAnnotation anno : node.getAnnotations()) {
            anno.accept(this);
            this.newLineIfNeeded();
        }
        this.increaseIndent();
        this.print("class {");
        this.newLine();
        for (BoxProperty property : node.getProperties()) {
            property.accept(this);
            this.newLineIfNeeded();
        }
        this.newLine();
        for (BoxStatement statement : node.getBody()) {
            statement.accept(this);
            this.newLineIfNeeded();
        }
        this.printInsideComments(node);
        this.decreaseIndent();
        this.print("}");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStaticInitializer node) {
        if (!this.isTemplate()) {
            this.printPreOnlyComments(node);
            this.increaseIndent();
            this.print("static {");
            this.newLine();
            for (BoxStatement statement : node.getBody()) {
                statement.accept(this);
                this.newLineIfNeeded();
            }
            this.printInsideComments(node);
            this.decreaseIndent();
            this.print("}");
            this.printPostComments(node);
            this.newLine();
        }
    }

    @Override
    public void visit(BoxInterface node) {
        for (BoxImport importNode : node.getImports()) {
            importNode.accept(this);
            this.newLine();
            this.newLineIfNeeded();
        }
        this.printPreOnlyComments(node);
        for (BoxAnnotation anno : node.getAnnotations()) {
            anno.accept(this);
            this.newLine();
        }
        this.increaseIndent();
        this.print("interface");
        this.currentSourceType.push(BoxSourceType.BOXTEMPLATE);
        for (BoxAnnotation anno : node.getPostAnnotations()) {
            anno.accept(this);
            this.newLine();
        }
        this.currentSourceType.pop();
        this.print(" {");
        this.newLine();
        for (BoxStatement statement : node.getBody()) {
            statement.accept(this);
            this.newLineIfNeeded();
        }
        this.printInsideComments(node);
        this.decreaseIndent();
        this.print("}");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxSingleLineComment node) {
        if (this.isTemplate()) {
            this.print("<!--- ");
            this.print(node.getCommentText());
            this.print(" --->");
        } else {
            this.print("// ");
            this.println(node.getCommentText());
        }
    }

    @Override
    public void visit(BoxMultiLineComment node) {
        if (this.isTemplate()) {
            this.print("<!--- ");
            this.print(node.getCommentText());
            this.print(" --->");
        } else {
            this.print("/*");
            if (!node.getCommentText().startsWith("*") && !node.getCommentText().startsWith("\n")) {
                this.print(" ");
            }
            this.printMultiLine(node.getCommentText());
            if (!node.getCommentText().endsWith("*") && !node.getCommentText().endsWith("\n")) {
                this.print(" ");
            }
            this.print("*/");
        }
    }

    @Override
    public void visit(BoxDocComment node) {
        if (this.isTemplate()) {
            this.print("<!--- ");
            this.print(node.getCommentText());
            this.print(" --->");
        } else {
            this.print("/**");
            if (!node.getCommentText().startsWith("*") && !node.getCommentText().startsWith("\n")) {
                this.print(" ");
            }
            this.printMultiLine(node.getCommentText());
            if (!node.getCommentText().endsWith("*") && !node.getCommentText().endsWith("\n")) {
                this.print(" ");
            }
            this.print("*/");
        }
    }

    @Override
    public void visit(BoxScriptIsland node) {
        this.printPreComments(node);
        boolean isTemplate = this.isTemplate();
        this.currentSourceType.push(BoxSourceType.BOXSCRIPT);
        if (isTemplate) {
            this.increaseIndent();
            this.println("<bx:script>");
        }
        for (BoxStatement statement : node.getStatements()) {
            statement.accept(this);
            this.newLineIfNeeded();
        }
        if (isTemplate) {
            this.decreaseIndent();
            this.println("</bx:script>");
        }
        this.currentSourceType.pop();
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxTemplate node) {
        this.currentSourceType.push(BoxSourceType.BOXTEMPLATE);
        this.printPreOnlyComments(node);
        for (BoxStatement statement : node.getStatements()) {
            statement.accept(this);
        }
        this.printInsideComments(node);
        this.printPostComments(node);
        this.currentSourceType.pop();
    }

    @Override
    public void visit(BoxTemplateIsland node) {
        this.printPreComments(node);
        this.println("```");
        this.currentSourceType.push(BoxSourceType.BOXTEMPLATE);
        for (BoxStatement statement : node.getStatements()) {
            statement.accept(this);
        }
        this.currentSourceType.pop();
        this.println("```");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxArgument node) {
        this.printPreComments(node);
        if (node.getName() == null) {
            node.getValue().accept(this);
        } else {
            BoxExpression boxExpression = node.getName();
            if (boxExpression instanceof BoxStringLiteral) {
                BoxStringLiteral str = (BoxStringLiteral)boxExpression;
                this.print(str.getValue());
            } else {
                node.getName().accept(this);
            }
            this.print("=");
            node.getValue().accept(this);
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxArrayAccess node) {
        this.printPreComments(node);
        node.getContext().accept(this);
        this.print("[ ");
        node.getAccess().accept(this);
        this.print(" ]");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxArrayLiteral node) {
        this.printPreComments(node);
        this.increaseIndent();
        int size = node.getValues().size();
        if (size > 0) {
            this.println("[ ");
        } else {
            this.print("[");
        }
        for (int i = 0; i < size; ++i) {
            node.getValues().get(i).accept(this);
            if (i < size - 1) {
                this.println(", ");
                continue;
            }
            this.newLine();
        }
        this.decreaseIndent();
        this.print("]");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxAssignment node) {
        this.printPreComments(node);
        if (node.getModifiers().contains((Object)BoxAssignmentModifier.VAR)) {
            this.print("var ");
        }
        node.getLeft().accept(this);
        if (node.getRight() != null) {
            this.print(" ");
            this.print(node.getOp().getSymbol());
            this.print(" ");
            node.getRight().accept(this);
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxBinaryOperation node) {
        this.printPreComments(node);
        node.getLeft().accept(this);
        this.print(" ");
        this.print(node.getOperator().getSymbol());
        this.print(" ");
        node.getRight().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxBooleanLiteral node) {
        this.printPreComments(node);
        this.print(node.getValue() != false ? "true" : "false");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxClosure node) {
        this.printPreComments(node);
        boolean hasArgs = !node.getArgs().isEmpty();
        this.print("(");
        if (hasArgs) {
            this.print(" ");
        }
        int size = node.getArgs().size();
        for (int i = 0; i < size; ++i) {
            node.getArgs().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (hasArgs) {
            this.print(" ");
        }
        this.print(") => ");
        node.getBody().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxComparisonOperation node) {
        this.printPreComments(node);
        node.getLeft().accept(this);
        this.print(" ");
        this.print(node.getOperator().getSymbol());
        this.print(" ");
        node.getRight().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxDecimalLiteral node) {
        this.printPreComments(node);
        this.print(node.getValue());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxDotAccess node) {
        this.printPreComments(node);
        node.getContext().accept(this);
        if (node.isSafe().booleanValue()) {
            this.print("?");
        }
        this.print(".");
        node.getAccess().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStaticAccess node) {
        this.printPreComments(node);
        node.getContext().accept(this);
        this.print("::");
        node.getAccess().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxExpressionInvocation node) {
        this.printPreComments(node);
        node.getExpr().accept(this);
        this.print("(");
        int size = node.getArguments().size();
        if (size > 0) {
            this.print(" ");
        }
        for (int i = 0; i < size; ++i) {
            node.getArguments().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (size > 0) {
            this.print(" ");
        }
        this.print(")");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxFQN node) {
        this.printPreComments(node);
        this.print(node.getValue());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxFunctionInvocation node) {
        this.printPreOnlyComments(node);
        this.print(node.getName());
        boolean hasArgs = !node.getArguments().isEmpty();
        this.print("(");
        if (hasArgs) {
            this.print(" ");
        }
        int size = node.getArguments().size();
        for (int i = 0; i < size; ++i) {
            node.getArguments().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (hasArgs) {
            this.print(" ");
        }
        this.printInsideComments(node);
        this.print(")");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxIdentifier node) {
        this.printPreComments(node);
        this.print(node.getName());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxIntegerLiteral node) {
        this.printPreComments(node);
        this.print(node.getValue());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxLambda node) {
        this.printPreComments(node);
        boolean hasArgs = !node.getArgs().isEmpty();
        this.print("(");
        if (hasArgs) {
            this.print(" ");
        }
        int size = node.getArgs().size();
        for (int i = 0; i < size; ++i) {
            node.getArgs().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (hasArgs) {
            this.print(" ");
        }
        this.print(") -> ");
        node.getBody().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxMethodInvocation node) {
        this.printPreComments(node);
        node.getObj().accept(this);
        if (node.getUsedDotAccess().booleanValue()) {
            if (node.isSafe().booleanValue()) {
                this.print("?");
            }
            this.print(".");
            node.getName().accept(this);
        } else {
            this.print("[ ");
            node.getName().accept(this);
            this.print(" ]");
        }
        boolean hasArgs = !node.getArguments().isEmpty();
        this.print("(");
        if (hasArgs) {
            this.print(" ");
        }
        int size = node.getArguments().size();
        for (int i = 0; i < size; ++i) {
            node.getArguments().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (hasArgs) {
            this.print(" ");
        }
        this.print(")");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStaticMethodInvocation node) {
        this.printPreComments(node);
        node.getObj().accept(this);
        this.print("::");
        node.getName().accept(this);
        boolean hasArgs = !node.getArguments().isEmpty();
        this.print("(");
        if (hasArgs) {
            this.print(" ");
        }
        int size = node.getArguments().size();
        for (int i = 0; i < size; ++i) {
            node.getArguments().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (hasArgs) {
            this.print(" ");
        }
        this.print(")");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxNegateOperation node) {
        this.printPreComments(node);
        this.print("not ");
        node.getExpr().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxNew node) {
        this.printPreComments(node);
        this.print("new ");
        if (node.getPrefix() != null) {
            node.getPrefix().accept(this);
            this.print(":");
        }
        node.getExpression().accept(this);
        this.print("(");
        int size = node.getArguments().size();
        if (size > 0) {
            this.print(" ");
        }
        for (int i = 0; i < size; ++i) {
            node.getArguments().get(i).accept(this);
            if (i >= size - 1) continue;
            this.print(", ");
        }
        if (size > 0) {
            this.print(" ");
        }
        this.print(")");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxNull node) {
        this.printPreComments(node);
        this.print("null");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxParenthesis node) {
        this.printPreComments(node);
        this.print("(");
        node.getExpression().accept(this);
        this.print(")");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxScope node) {
        this.printPreComments(node);
        this.print(node.getName());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStringConcat node) {
        this.printPreComments(node);
        int size = node.getValues().size();
        for (int i = 0; i < size; ++i) {
            BoxExpression expr = node.getValues().get(i);
            expr.accept(this);
            if (i >= size - 1) continue;
            this.print(" & ");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStringInterpolation node) {
        this.printPreComments(node);
        this.print("\"");
        this.processStringInterp(node, true);
        this.print("\"");
        this.printPostComments(node);
    }

    public void processStringInterp(BoxStringInterpolation node, boolean isQuoted) {
        for (BoxExpression expr : node.getValues()) {
            if (expr instanceof BoxStringLiteral) {
                BoxStringLiteral str = (BoxStringLiteral)expr;
                if (isQuoted) {
                    this.print(str.getValue().replace("\"", "\"\"").replace("#", "##"));
                    continue;
                }
                String value = str.getValue();
                if (node.getFirstAncestorOfType(BoxComponent.class, comp -> comp.getName().equalsIgnoreCase("output")) != null) {
                    value = value.replace("#", "##");
                }
                this.print(value);
                continue;
            }
            this.print("#");
            expr.accept(this);
            this.print("#");
        }
    }

    @Override
    public void visit(BoxStringLiteral node) {
        this.printPreComments(node);
        this.print("\"");
        this.print(node.getValue().replace("\"", "\"\"").replace("#", "##"));
        this.print("\"");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStructLiteral node) {
        this.printPreComments(node);
        this.increaseIndent();
        int size = node.getValues().size();
        if (node.getType().equals((Object)BoxStructType.Ordered)) {
            if (size > 0) {
                this.println("[ ");
            } else {
                this.print("[");
            }
        } else if (size > 0) {
            this.println("{ ");
        } else {
            this.print("{");
        }
        for (int i = 0; i < size; i += 2) {
            BoxExpression key = node.getValues().get(i);
            key.accept(this);
            this.print(" : ");
            BoxExpression value = node.getValues().get(i + 1);
            value.accept(this);
            if (i < size - 2) {
                this.println(", ");
                continue;
            }
            this.newLine();
        }
        this.decreaseIndent();
        if (node.getType().equals((Object)BoxStructType.Ordered)) {
            this.print("]");
        } else {
            this.print("}");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxTernaryOperation node) {
        this.printPreComments(node);
        node.getCondition().accept(this);
        this.print(" ? ");
        node.getWhenTrue().accept(this);
        this.print(" : ");
        node.getWhenFalse().accept(this);
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxUnaryOperation node) {
        this.printPreComments(node);
        String symbol = node.getOperator().getSymbol();
        if (node.getOperator().isPre().booleanValue()) {
            this.print(symbol);
            node.getExpr().accept(this);
        } else {
            node.getExpr().accept(this);
            this.print(symbol);
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxAnnotation node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print(" ");
            node.getKey().accept(this);
            if (node.getValue() != null) {
                this.print("=\"");
                this.doQuotedExpression(node.getValue());
                this.print("\"");
            }
        } else {
            this.print("@");
            node.getKey().accept(this);
            if (node.getValue() != null) {
                this.print(" ");
                node.getValue().accept(this);
            }
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxArgumentDeclaration node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:argument");
            for (BoxAnnotation annotation : node.getAnnotations()) {
                annotation.accept(this);
            }
            this.print(">");
        } else {
            if (node.getRequired() != null && node.getRequired().booleanValue()) {
                this.print("required ");
            }
            if (node.getType() != null) {
                this.print(node.getType());
                this.print(" ");
            }
            this.print(node.getName());
            if (node.getValue() != null) {
                this.print(" = ");
                node.getValue().accept(this);
            }
        }
        this.printPostComments(node);
    }

    private void doQuotedExpression(BoxExpression node) {
        if (node instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)node;
            this.print(str.getValue().replace("\"", "\"\"").replace("#", "##"));
        } else if (node instanceof BoxStringInterpolation) {
            BoxStringInterpolation interp = (BoxStringInterpolation)node;
            this.processStringInterp(interp, true);
        } else if (node instanceof BoxFQN) {
            BoxFQN fqn = (BoxFQN)node;
            this.print(fqn.getValue());
        } else {
            this.print("#");
            node.accept(this);
            this.print("#");
        }
    }

    @Override
    public void visit(BoxAssert node) {
        this.printPreComments(node);
        this.print("assert ");
        node.getExpression().accept(this);
        this.print(";");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxBreak node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:break");
            if (node.getLabel() != null) {
                this.print(" label=\"");
                this.print(node.getLabel());
                this.print("\"");
            }
            this.print(">");
        } else {
            this.print("break");
            if (node.getLabel() != null) {
                this.print(" ");
                this.print(node.getLabel());
            }
            this.print(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxContinue node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:continue");
            if (node.getLabel() != null) {
                this.print(" label=\"");
                this.print(node.getLabel());
                this.print("\"");
            }
            this.print(">");
        } else {
            this.print("continue");
            if (node.getLabel() != null) {
                this.print(" ");
                this.print(node.getLabel());
            }
            this.print(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxDo node) {
        this.printPreComments(node);
        if (node.getLabel() != null) {
            this.print(node.getLabel());
            this.print(": ");
        }
        this.print("do ");
        node.getBody().accept(this);
        this.newLine();
        this.print(" while (");
        node.getCondition().accept(this);
        this.print(");");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxDocumentationAnnotation node) {
        this.printPreComments(node);
        node.getKey().accept(this);
        if (node.getValue() != null) {
            this.print(" ");
            node.getValue().accept(this);
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxExpressionStatement node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:set ");
            node.getExpression().accept(this);
            this.print(" >");
        } else {
            node.getExpression().accept(this);
            this.print(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxForIn node) {
        this.printPreComments(node);
        if (node.getLabel() != null) {
            this.print(node.getLabel());
            this.print(": ");
        }
        this.print("for( ");
        if (node.getHasVar().booleanValue()) {
            this.print("var ");
        }
        node.getVariable().accept(this);
        this.print(" in ");
        node.getExpression().accept(this);
        this.print(" ) ");
        node.getBody().accept(this);
        this.newLine();
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxForIndex node) {
        this.printPreComments(node);
        if (node.getLabel() != null) {
            this.print(node.getLabel());
            this.print(": ");
        }
        this.print("for( ");
        if (node.getInitializer() != null) {
            node.getInitializer().accept(this);
        } else {
            this.print(" ");
        }
        this.print("; ");
        if (node.getCondition() != null) {
            node.getCondition().accept(this);
        } else {
            this.print(" ");
        }
        this.print("; ");
        if (node.getStep() != null) {
            node.getStep().accept(this);
        } else {
            this.print(" ");
        }
        this.print(" ) ");
        node.getBody().accept(this);
        this.newLine();
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxFunctionDeclaration node) {
        this.newLine();
        this.printPreComments(node);
        Boolean defaultInterfaceMethod = node.getFirstNodeOfType(BoxInterface.class) != null;
        if (this.isTemplate()) {
            this.print("<bx:function");
            for (BoxAnnotation annotation : node.getAnnotations()) {
                annotation.accept(this);
            }
            this.print(">");
            this.increaseIndent();
            this.newLine();
            for (BoxArgumentDeclaration args : node.getArgs()) {
                args.accept(this);
                this.newLine();
            }
            this.newLine();
            if (node.getBody() != null) {
                for (BoxStatement statement : node.getBody()) {
                    statement.accept(this);
                }
            }
            this.decreaseIndent();
            this.print("</bx:function>");
        } else {
            if (defaultInterfaceMethod.booleanValue()) {
                this.print("default ");
            }
            if (node.getAccessModifier() != null) {
                this.print(node.getAccessModifier().toString().toLowerCase());
                this.print(" ");
            }
            if (node.getType() != null) {
                node.getType().accept(this);
                this.print(" ");
            }
            this.print("function ");
            this.print(node.getName());
            boolean hasArgs = !node.getArgs().isEmpty();
            this.print("(");
            if (hasArgs) {
                this.print(" ");
            }
            int size = node.getArgs().size();
            for (int i = 0; i < size; ++i) {
                node.getArgs().get(i).accept(this);
                if (i >= size - 1) continue;
                this.print(", ");
            }
            if (hasArgs) {
                this.print(" ");
            }
            this.print(")");
            if (node.getBody() != null) {
                this.increaseIndent();
                this.println(" {");
                for (BoxStatement statement : node.getBody()) {
                    statement.accept(this);
                    this.newLineIfNeeded();
                }
                this.decreaseIndent();
                this.println("}");
            } else {
                this.println(";");
            }
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxIfElse node) {
        this.printPreComments(node);
        this.doBoxIfElse(node, false);
        this.printPostComments(node);
    }

    private void doBoxIfElse(BoxIfElse node, boolean elseif) {
        if (this.isTemplate()) {
            if (elseif) {
                this.print("if ");
            } else {
                this.print("<bx:if ");
            }
            node.getCondition().accept(this);
            this.print(" >");
            this.increaseIndent();
            node.getThenBody().accept(this);
            this.decreaseIndent();
            if (node.getElseBody() != null) {
                BoxStatement boxStatement = node.getElseBody();
                if (boxStatement instanceof BoxIfElse) {
                    BoxIfElse elseNode = (BoxIfElse)boxStatement;
                    this.print("<bx:else");
                    this.doBoxIfElse(elseNode, true);
                } else {
                    this.print("<bx:else>");
                    this.increaseIndent();
                    node.getElseBody().accept(this);
                    this.decreaseIndent();
                    this.print("</bx:if>");
                }
            } else {
                this.print("</bx:if>");
            }
        } else {
            this.print("if( ");
            node.getCondition().accept(this);
            this.print(" ) ");
            node.getThenBody().accept(this);
            this.newLine();
            if (node.getElseBody() != null) {
                this.print(" else ");
                node.getElseBody().accept(this);
                this.newLine();
            }
        }
    }

    @Override
    public void visit(BoxImport node) {
        this.printPreComments(node);
        if (node.getExpression() == null) {
            return;
        }
        if (this.isTemplate()) {
            BoxFQN fqn = (BoxFQN)node.getExpression();
            String prefix = null;
            String className = null;
            if (fqn.getValue().contains(":")) {
                String[] parts2 = fqn.getValue().split(":");
                prefix = parts2[0];
                className = parts2[1];
            } else {
                className = fqn.getValue();
            }
            this.print("<bx:import");
            if (prefix != null) {
                this.print(" prefix=\"");
                this.print(prefix);
                this.print("\"");
            }
            this.print(" name=\"");
            this.print(className);
            this.print("\"");
            if (node.getAlias() != null) {
                this.print(" alias=\"");
                node.getAlias().accept(this);
                this.print("\"");
            }
            this.print(">");
        } else {
            this.print("import ");
            node.getExpression().accept(this);
            if (node.getAlias() != null) {
                this.print(" as ");
                node.getAlias().accept(this);
            }
            this.print(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxParam node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:param");
            if (node.getType() != null) {
                this.print(" type=\"");
                node.getType().accept(this);
                this.print("\"");
            }
            this.print(" name=\"");
            node.getVariable().accept(this);
            this.print("\"");
            if (node.getDefaultValue() != null) {
                this.print(" default=\"");
                this.doQuotedExpression(node.getDefaultValue());
                this.print("\"");
            }
            this.print(">");
        } else {
            this.print("param ");
            if (node.getType() != null) {
                node.getType().accept(this);
                this.print(" ");
            }
            node.getVariable().accept(this);
            if (node.getDefaultValue() != null) {
                this.print(" = ");
                node.getDefaultValue().accept(this);
            }
            this.println(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxProperty node) {
        this.newLine();
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:property");
            for (BoxAnnotation anno : node.getAnnotations()) {
                anno.accept(this);
            }
            this.print(">");
        } else {
            for (BoxAnnotation anno : node.getAnnotations()) {
                anno.accept(this);
                this.newLine();
            }
            this.print("property");
            for (BoxAnnotation anno : node.getPostAnnotations()) {
                this.print(" ");
                anno.getKey().accept(this);
                if (anno.getValue() == null) continue;
                this.print("=");
                anno.getValue().accept(this);
            }
            this.println(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxRethrow node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:rethrow>");
        } else {
            this.print("rethrow;");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxReturn node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:return");
            if (node.getExpression() != null) {
                this.print(" ");
                node.getExpression().accept(this);
            }
            this.print(">");
        } else {
            this.print("return");
            if (node.getExpression() != null) {
                this.print(" ");
                node.getExpression().accept(this);
            }
            this.print(";");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxReturnType node) {
        this.printPreComments(node);
        if (node.getType().equals((Object)BoxType.Fqn)) {
            this.print(node.getFqn());
        } else {
            this.print(node.getType().toString().toLowerCase());
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxSwitch node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:switch expression=\"");
            this.doQuotedExpression(node.getCondition());
            this.print("\">");
            this.increaseIndent();
            for (BoxSwitchCase caseNode : node.getCases()) {
                caseNode.accept(this);
                this.newLine();
            }
            this.decreaseIndent();
            this.print("</bx:switch>");
        } else {
            this.print("switch ( ");
            node.getCondition().accept(this);
            this.increaseIndent();
            this.println(" ) {");
            for (BoxSwitchCase caseNode : node.getCases()) {
                caseNode.accept(this);
            }
            this.decreaseIndent();
            this.print("}");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxSwitchCase node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            if (node.getCondition() != null) {
                this.print("<bx:case value=\"");
                this.doQuotedExpression(node.getCondition());
                this.print("\">");
            } else {
                this.print("<bx:defaultcase>");
            }
            this.increaseIndent();
            for (BoxStatement statement : node.getBody()) {
                statement.accept(this);
            }
            this.decreaseIndent();
            this.newLine();
            if (node.getCondition() != null) {
                this.print("</bx:case>");
            } else {
                this.print("</bx:defaultcase>");
            }
        } else {
            if (node.getCondition() == null) {
                this.print("default:");
            } else {
                this.print("case ");
                node.getCondition().accept(this);
                this.print(":");
            }
            if (node.getBody().size() == 1 && node.getBody().get(0) instanceof BoxStatementBlock) {
                this.print(" ");
                node.getBody().get(0).accept(this);
                this.newLine();
            } else {
                this.increaseIndent();
                this.newLine();
                for (BoxStatement statement : node.getBody()) {
                    statement.accept(this);
                    this.newLineIfNeeded();
                }
                this.decreaseIndent();
            }
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxThrow node) {
        this.printPreComments(node);
        this.print("throw");
        if (node.getExpression() != null) {
            this.print(" ");
            node.getExpression().accept(this);
        }
        this.print(";");
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxTry node) {
        if (this.isTemplate()) {
            this.printPreComments(node);
            this.print("<bx:try>");
            this.increaseIndent();
            for (BoxStatement statement : node.getTryBody()) {
                statement.accept(this);
            }
            for (BoxTryCatch catchNode : node.getCatches()) {
                catchNode.accept(this);
            }
            if (node.getFinallyBody() != null && !node.getFinallyBody().isEmpty()) {
                this.print("<bx:finally>");
                this.increaseIndent();
                for (BoxStatement statement : node.getFinallyBody()) {
                    statement.accept(this);
                }
                this.decreaseIndent();
                this.print("</bx:finally>");
            }
            this.decreaseIndent();
            this.print("</bx:try>");
        } else {
            this.printPreOnlyComments(node);
            this.increaseIndent();
            this.println("try {");
            for (BoxStatement statement : node.getTryBody()) {
                statement.accept(this);
                this.newLineIfNeeded();
            }
            this.printInsideComments(node);
            this.decreaseIndent();
            this.print("}");
            if (!node.getCatches().isEmpty()) {
                for (BoxTryCatch catchNode : node.getCatches()) {
                    catchNode.accept(this);
                }
            }
            if (node.getFinallyBody() != null && !node.getFinallyBody().isEmpty()) {
                this.increaseIndent();
                this.print("finally {");
                this.newLine();
                for (BoxStatement statement : node.getFinallyBody()) {
                    statement.accept(this);
                    this.newLineIfNeeded();
                }
                this.decreaseIndent();
                this.print("}");
            }
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxTryCatch node) {
        if (this.isTemplate()) {
            this.printPreComments(node);
            this.print("<bx:catch");
            if (!node.getCatchTypes().isEmpty()) {
                this.print(" type=\"");
                this.doQuotedExpression(node.getCatchTypes().get(0));
                this.print("\"");
            }
            this.print(">");
            this.increaseIndent();
            for (BoxStatement statement : node.getCatchBody()) {
                statement.accept(this);
            }
            this.decreaseIndent();
            this.print("</bx:catch>");
        } else {
            this.printPreOnlyComments(node);
            this.print(" catch (");
            int numCatchTypes = node.getCatchTypes().size();
            for (int i = 0; i < numCatchTypes; ++i) {
                BoxExpression type = node.getCatchTypes().get(i);
                type.accept(this);
                if (i >= numCatchTypes - 1) continue;
                this.print(" | ");
            }
            this.print(" ");
            node.getException().accept(this);
            this.increaseIndent();
            this.print(") {");
            this.newLine();
            for (BoxStatement statement : node.getCatchBody()) {
                statement.accept(this);
                this.newLineIfNeeded();
            }
            this.printInsideComments(node);
            this.decreaseIndent();
            this.print("}");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxWhile node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:while condition=\"");
            this.doQuotedExpression(node.getCondition());
            this.print("\"");
            if (node.getLabel() != null) {
                this.print(" label=\"");
                this.print(node.getLabel());
                this.print("\"");
            }
            this.print(">");
            this.increaseIndent();
            node.getBody().accept(this);
            this.decreaseIndent();
            this.print("</bx:while>");
        } else {
            if (node.getLabel() != null) {
                this.print(node.getLabel());
                this.print(": ");
            }
            this.print("while (");
            node.getCondition().accept(this);
            this.print(") ");
            node.getBody().accept(this);
            this.newLine();
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxComponent node) {
        this.printPreComments(node);
        if (this.isTemplate()) {
            this.print("<bx:");
            this.print(node.getName());
            for (BoxAnnotation attr : node.getAttributes()) {
                this.print(" ");
                attr.getKey().accept(this);
                this.print("=\"");
                this.doQuotedExpression(attr.getValue());
                this.print("\"");
            }
            if (node.getBody() != null) {
                if (node.getBody().isEmpty()) {
                    this.print("/>");
                } else {
                    this.print(">");
                    this.increaseIndent();
                    for (BoxStatement statement : node.getBody()) {
                        statement.accept(this);
                    }
                    this.decreaseIndent();
                    this.print("</bx:");
                    this.print(node.getName());
                    this.print(">");
                }
            } else {
                this.print(">");
            }
        } else {
            this.print(node.getName());
            for (BoxAnnotation attr : node.getAttributes()) {
                this.print(" ");
                attr.getKey().accept(this);
                this.print("=");
                attr.getValue().accept(this);
            }
            if (node.getBody() != null && !node.getBody().isEmpty()) {
                this.increaseIndent();
                this.print(" {");
                this.newLine();
                for (BoxStatement statement : node.getBody()) {
                    statement.accept(this);
                    this.newLineIfNeeded();
                }
                this.decreaseIndent();
                this.print("}");
            } else {
                this.print(";");
            }
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxStatementBlock node) {
        this.printPreOnlyComments(node);
        if (this.isTemplate()) {
            for (BoxStatement statement : node.getBody()) {
                statement.accept(this);
            }
        } else {
            this.increaseIndent();
            this.print("{");
            this.newLine();
            for (BoxStatement statement : node.getBody()) {
                statement.accept(this);
                this.newLineIfNeeded();
            }
            this.printInsideComments(node);
            this.decreaseIndent();
            this.print("}");
        }
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxFunctionalBIFAccess node) {
        this.printPreComments(node);
        this.print("::");
        this.print(node.getName());
        this.printPostComments(node);
    }

    @Override
    public void visit(BoxFunctionalMemberAccess node) {
        this.printPreComments(node);
        this.print(".");
        this.print(node.getName());
        if (node.getArguments() != null) {
            this.print("(");
            int size = node.getArguments().size();
            if (size > 0) {
                this.print(" ");
            }
            for (int i = 0; i < size; ++i) {
                node.getArguments().get(i).accept(this);
                if (i >= size - 1) continue;
                this.print(", ");
            }
            if (size > 0) {
                this.print(" ");
            }
            this.print(")");
        }
        this.printPostComments(node);
    }
}

