/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.util.List;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxStringConcat;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;

public class QueryEscapeSingleQuoteVisitor
extends VoidBoxVisitor {
    @Override
    public void visit(BoxComponent node) {
        if (node.getName().equalsIgnoreCase("query")) {
            node.getDescendantsOfType(BoxBufferOutput.class).forEach(s -> this.escapeBufferOutput((BoxBufferOutput)s));
            node.getDescendantsOfType(BoxFunctionInvocation.class, f -> f.getName().equalsIgnoreCase("writeoutput") || f.getName().equalsIgnoreCase("echo")).forEach(s -> this.escapeWriteOutput((BoxFunctionInvocation)s));
        }
        super.visit(node);
    }

    private void escapeBufferOutput(BoxBufferOutput s) {
        if (this.isStringConcat(s.getExpression())) {
            this.escapeExpressions((BoxStringConcat)s.getExpression());
        }
    }

    private void escapeWriteOutput(BoxFunctionInvocation s) {
        if (s.getArguments().size() > 0) {
            BoxArgument arg = s.getArguments().get(0);
            BoxExpression value = arg.getValue();
            if (this.isStringConcat(value)) {
                this.escapeExpressions((BoxStringConcat)value);
            } else if (!this.isStringLiteral(value) && !this.isPreserveSingleQuotes(value)) {
                arg.setValue(this.escapeExpression(value));
            }
        }
    }

    private void escapeExpressions(BoxStringConcat bsc) {
        bsc.setValues(bsc.getValues().stream().map(e -> {
            if (!this.isStringLiteral((BoxNode)e) && !this.isPreserveSingleQuotes((BoxNode)e)) {
                return this.escapeExpression((BoxExpression)e);
            }
            return e;
        }).toList());
    }

    private BoxExpression escapeExpression(BoxExpression e) {
        return new BoxFunctionInvocation("replaceNoCase", List.of(new BoxArgument(e, null, null), new BoxArgument(new BoxStringLiteral("'", null, null), null, null), new BoxArgument(new BoxStringLiteral("''", null, null), null, null)), e.getPosition(), e.getSourceText());
    }

    private boolean isStringLiteral(BoxNode node) {
        return node instanceof BoxStringLiteral;
    }

    private boolean isStringConcat(BoxNode node) {
        return node instanceof BoxStringConcat;
    }

    private boolean isPreserveSingleQuotes(BoxNode node) {
        BoxFunctionInvocation bfi;
        return node instanceof BoxFunctionInvocation && (bfi = (BoxFunctionInvocation)node).getName().equalsIgnoreCase("preserveSingleQuotes");
    }
}

