/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.util.List;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.BoxStaticInitializer;
import ortus.boxlang.compiler.ast.BoxTemplate;
import ortus.boxlang.compiler.ast.comment.BoxDocComment;
import ortus.boxlang.compiler.ast.comment.BoxMultiLineComment;
import ortus.boxlang.compiler.ast.comment.BoxSingleLineComment;
import ortus.boxlang.compiler.ast.expression.BoxAccess;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxDecimalLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalBIFAccess;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalMemberAccess;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNegateOperation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStaticAccess;
import ortus.boxlang.compiler.ast.expression.BoxStaticMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxStringConcat;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.expression.BoxTernaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxAssert;
import ortus.boxlang.compiler.ast.statement.BoxBreak;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.BoxContinue;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxParam;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxRethrow;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxScriptIsland;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxSwitchCase;
import ortus.boxlang.compiler.ast.statement.BoxThrow;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxTryCatch;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.statement.component.BoxTemplateIsland;

public abstract class ReplacingBoxVisitor {
    protected ReplacingBoxVisitor() {
    }

    public BoxNode visit(BoxScript node) {
        this.handleStatements(node.getStatements(), node);
        return node;
    }

    public BoxNode visit(BoxStatementBlock node) {
        this.handleStatements(node.getBody(), node);
        return node;
    }

    public BoxNode visit(BoxInterface node) {
        BoxNode newAnnotation;
        BoxAnnotation annotationNode;
        int i;
        this.handleStatements(node.getBody(), node);
        for (i = 0; i < node.getImports().size(); ++i) {
            BoxImport importNode = node.getImports().get(i);
            BoxNode newImport = importNode.accept(this);
            if (newImport == importNode) continue;
            node.replaceChildren(newImport, importNode);
            node.getImports().set(i, (BoxImport)newImport);
        }
        for (i = 0; i < node.getAnnotations().size(); ++i) {
            annotationNode = node.getAnnotations().get(i);
            newAnnotation = annotationNode.accept(this);
            if (newAnnotation == annotationNode) continue;
            node.replaceChildren(newAnnotation, annotationNode);
            node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        for (i = 0; i < node.getPostAnnotations().size(); ++i) {
            annotationNode = node.getPostAnnotations().get(i);
            newAnnotation = annotationNode.accept(this);
            if (newAnnotation == annotationNode) continue;
            node.replaceChildren(newAnnotation, annotationNode);
            node.getPostAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        for (i = 0; i < node.getDocumentation().size(); ++i) {
            BoxDocumentationAnnotation documentationNode = node.getDocumentation().get(i);
            BoxNode newDocumentation = documentationNode.accept(this);
            if (newDocumentation == documentationNode) continue;
            node.replaceChildren(newDocumentation, documentationNode);
            node.getDocumentation().set(i, (BoxDocumentationAnnotation)newDocumentation);
        }
        return node;
    }

    public BoxNode visit(BoxBufferOutput node) {
        BoxExpression expr = node.getExpression();
        BoxNode newExpr = expr.accept(this);
        if (newExpr != expr) {
            node.setExpression((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxClass node) {
        int i;
        this.handleStatements(node.getBody(), node);
        for (i = 0; i < node.getImports().size(); ++i) {
            BoxImport importNode = node.getImports().get(i);
            BoxNode newImport = importNode.accept(this);
            if (newImport == importNode) continue;
            node.replaceChildren(newImport, importNode);
            node.getImports().set(i, (BoxImport)newImport);
        }
        for (i = 0; i < node.getAnnotations().size(); ++i) {
            BoxAnnotation annotationNode = node.getAnnotations().get(i);
            BoxNode newAnnotation = annotationNode.accept(this);
            if (newAnnotation == annotationNode) continue;
            node.replaceChildren(newAnnotation, annotationNode);
            node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        for (i = 0; i < node.getDocumentation().size(); ++i) {
            BoxDocumentationAnnotation documentationNode = node.getDocumentation().get(i);
            BoxNode newDocumentation = documentationNode.accept(this);
            if (newDocumentation == documentationNode) continue;
            node.replaceChildren(newDocumentation, documentationNode);
            node.getDocumentation().set(i, (BoxDocumentationAnnotation)newDocumentation);
        }
        for (i = 0; i < node.getProperties().size(); ++i) {
            BoxProperty propertyNode = node.getProperties().get(i);
            BoxNode newProperty = propertyNode.accept(this);
            if (newProperty == propertyNode) continue;
            node.replaceChildren(newProperty, propertyNode);
            node.getProperties().set(i, (BoxProperty)newProperty);
        }
        return node;
    }

    public BoxNode visit(BoxStaticInitializer node) {
        this.handleStatements(node.getBody(), node);
        return node;
    }

    public BoxNode visit(BoxDocComment node) {
        for (int i = 0; i < node.getAnnotations().size(); ++i) {
            BoxDocumentationAnnotation annotationNode = node.getAnnotations().get(i);
            BoxDocumentationAnnotation newAnnotation = (BoxDocumentationAnnotation)annotationNode.accept(this);
            if (newAnnotation == annotationNode) continue;
            node.replaceChildren(newAnnotation, annotationNode);
            node.getAnnotations().set(i, newAnnotation);
        }
        return node;
    }

    public BoxNode visit(BoxSingleLineComment node) {
        return node;
    }

    public BoxNode visit(BoxMultiLineComment node) {
        return node;
    }

    public BoxNode visit(BoxScriptIsland node) {
        this.handleStatements(node.getStatements(), node);
        return node;
    }

    public BoxNode visit(BoxTemplateIsland node) {
        this.handleStatements(node.getStatements(), node);
        return node;
    }

    public BoxNode visit(BoxTemplate node) {
        this.handleStatements(node.getStatements(), node);
        return node;
    }

    public BoxNode visit(BoxArgument node) {
        BoxExpression value;
        BoxNode newValue;
        BoxNode newName;
        BoxExpression name = node.getName();
        if (name != null && (newName = name.accept(this)) != name) {
            node.setName((BoxExpression)newName);
        }
        if ((newValue = (value = node.getValue()).accept(this)) != value) {
            node.setValue((BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxArrayAccess node) {
        return this.doAccess(node);
    }

    public BoxNode visit(BoxDotAccess node) {
        return this.doAccess(node);
    }

    public BoxNode visit(BoxStaticAccess node) {
        return this.doAccess(node);
    }

    public BoxNode doAccess(BoxAccess node) {
        BoxExpression access;
        BoxNode newAccess;
        BoxExpression context = node.getContext();
        BoxNode newContext = context.accept(this);
        if (newContext != context) {
            node.setContext((BoxExpression)newContext);
        }
        if ((newAccess = (access = node.getAccess()).accept(this)) != access) {
            node.setAccess((BoxExpression)newAccess);
        }
        return node;
    }

    public BoxNode visit(BoxArrayLiteral node) {
        for (int i = 0; i < node.getValues().size(); ++i) {
            BoxExpression value = node.getValues().get(i);
            BoxNode newValue = value.accept(this);
            if (newValue == value) continue;
            node.replaceChildren(newValue, value);
            node.getValues().set(i, (BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxAssignment node) {
        BoxNode newRight;
        BoxExpression right;
        BoxExpression left = node.getLeft();
        BoxNode newLeft = left.accept(this);
        if (newLeft != left) {
            node.setLeft((BoxExpression)newLeft);
        }
        if ((right = node.getRight()) != null && (newRight = right.accept(this)) != right) {
            node.setRight((BoxExpression)newRight);
        }
        return node;
    }

    public BoxNode visit(BoxBinaryOperation node) {
        BoxExpression right;
        BoxNode newRight;
        BoxExpression left = node.getLeft();
        BoxNode newLeft = left.accept(this);
        if (newLeft != left) {
            node.setLeft((BoxExpression)newLeft);
        }
        if ((newRight = (right = node.getRight()).accept(this)) != right) {
            node.setRight((BoxExpression)newRight);
        }
        return node;
    }

    public BoxNode visit(BoxBooleanLiteral node) {
        return node;
    }

    public BoxNode visit(BoxClosure node) {
        int i;
        for (i = 0; i < node.getArgs().size(); ++i) {
            BoxArgumentDeclaration arg = node.getArgs().get(i);
            BoxNode newArg = arg.accept(this);
            if (newArg == arg) continue;
            node.replaceChildren(newArg, arg);
            node.getArgs().set(i, (BoxArgumentDeclaration)newArg);
        }
        for (i = 0; i < node.getAnnotations().size(); ++i) {
            BoxAnnotation annotation = node.getAnnotations().get(i);
            BoxNode newAnnotation = annotation.accept(this);
            if (newAnnotation == annotation) continue;
            node.replaceChildren(newAnnotation, annotation);
            node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        node.getBody().accept(this);
        return node;
    }

    public BoxNode visit(BoxComparisonOperation node) {
        BoxExpression right;
        BoxNode newRight;
        BoxExpression left = node.getLeft();
        BoxNode newLeft = left.accept(this);
        if (newLeft != left) {
            node.setLeft((BoxExpression)newLeft);
        }
        if ((newRight = (right = node.getRight()).accept(this)) != right) {
            node.setRight((BoxExpression)newRight);
        }
        return node;
    }

    public BoxNode visit(BoxDecimalLiteral node) {
        return node;
    }

    public BoxNode visit(BoxExpressionInvocation node) {
        BoxNode newExpr;
        BoxExpression expr = node.getExpr();
        if (expr != null && (newExpr = expr.accept(this)) != expr) {
            node.setExpr((BoxExpression)newExpr);
        }
        for (int i = 0; i < node.getArguments().size(); ++i) {
            BoxArgument argument = node.getArguments().get(i);
            BoxNode newArgument = argument.accept(this);
            if (newArgument == argument) continue;
            node.replaceChildren(newArgument, argument);
            node.getArguments().set(i, (BoxArgument)newArgument);
        }
        return node;
    }

    public BoxNode visit(BoxFQN node) {
        return node;
    }

    public BoxNode visit(BoxFunctionInvocation node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            BoxArgument argument = node.getArguments().get(i);
            BoxNode newArgument = argument.accept(this);
            if (newArgument == argument) continue;
            node.replaceChildren(newArgument, argument);
            node.getArguments().set(i, (BoxArgument)newArgument);
        }
        return node;
    }

    public BoxNode visit(BoxIdentifier node) {
        return node;
    }

    public BoxNode visit(BoxIntegerLiteral node) {
        return node;
    }

    public BoxNode visit(BoxLambda node) {
        int i;
        for (i = 0; i < node.getArgs().size(); ++i) {
            BoxArgumentDeclaration arg = node.getArgs().get(i);
            BoxNode newArg = arg.accept(this);
            if (newArg == arg) continue;
            node.replaceChildren(newArg, arg);
            node.getArgs().set(i, (BoxArgumentDeclaration)newArg);
        }
        for (i = 0; i < node.getAnnotations().size(); ++i) {
            BoxAnnotation annotation = node.getAnnotations().get(i);
            BoxNode newAnnotation = annotation.accept(this);
            if (newAnnotation == annotation) continue;
            node.replaceChildren(newAnnotation, annotation);
            node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        node.getBody().accept(this);
        return node;
    }

    public BoxNode visit(BoxMethodInvocation node) {
        BoxExpression name = node.getName();
        BoxNode newName = name.accept(this);
        if (newName != name) {
            node.setName((BoxExpression)newName);
        }
        for (int i = 0; i < node.getArguments().size(); ++i) {
            BoxArgument argument = node.getArguments().get(i);
            BoxNode newArgument = argument.accept(this);
            if (newArgument == argument) continue;
            node.replaceChildren(newArgument, argument);
            node.getArguments().set(i, (BoxArgument)newArgument);
        }
        BoxExpression obj = node.getObj();
        BoxNode newObj = obj.accept(this);
        if (newObj != obj) {
            node.setObj((BoxExpression)newObj);
        }
        return node;
    }

    public BoxNode visit(BoxStaticMethodInvocation node) {
        BoxIdentifier name = node.getName();
        BoxNode newName = name.accept(this);
        if (newName != name) {
            node.setName((BoxIdentifier)newName);
        }
        for (int i = 0; i < node.getArguments().size(); ++i) {
            BoxArgument argument = node.getArguments().get(i);
            BoxNode newArgument = argument.accept(this);
            if (newArgument == argument) continue;
            node.replaceChildren(newArgument, argument);
            node.getArguments().set(i, (BoxArgument)newArgument);
        }
        BoxExpression obj = node.getObj();
        BoxNode newObj = obj.accept(this);
        if (newObj != obj) {
            node.setObj((BoxExpression)newObj);
        }
        return node;
    }

    public BoxNode visit(BoxNegateOperation node) {
        BoxExpression expr = node.getExpr();
        BoxNode newExpr = expr.accept(this);
        if (newExpr != expr) {
            node.setExpr((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxNew node) {
        BoxNode newPrefix;
        BoxIdentifier prefix;
        BoxNode newExpr;
        BoxExpression expression = node.getExpression();
        if (expression != null && (newExpr = expression.accept(this)) != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        if ((prefix = node.getPrefix()) != null && (newPrefix = prefix.accept(this)) != prefix) {
            node.setPrefix((BoxIdentifier)newPrefix);
        }
        for (int i = 0; i < node.getArguments().size(); ++i) {
            BoxArgument argument = node.getArguments().get(i);
            BoxNode newArgument = argument.accept(this);
            if (newArgument == argument) continue;
            node.replaceChildren(newArgument, argument);
            node.getArguments().set(i, (BoxArgument)newArgument);
        }
        return node;
    }

    public BoxNode visit(BoxNull node) {
        return node;
    }

    public BoxNode visit(BoxParenthesis node) {
        BoxExpression expression = node.getExpression();
        BoxNode newExpr = expression.accept(this);
        if (newExpr != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxScope node) {
        return node;
    }

    public BoxNode visit(BoxStringConcat node) {
        for (int i = 0; i < node.getValues().size(); ++i) {
            BoxExpression value = node.getValues().get(i);
            BoxNode newValue = value.accept(this);
            if (newValue == value) continue;
            node.replaceChildren(newValue, value);
            node.getValues().set(i, (BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxStringInterpolation node) {
        for (int i = 0; i < node.getValues().size(); ++i) {
            BoxExpression value = node.getValues().get(i);
            BoxNode newValue = value.accept(this);
            if (newValue == value) continue;
            node.replaceChildren(newValue, value);
            node.getValues().set(i, (BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxStringLiteral node) {
        return node;
    }

    public BoxNode visit(BoxStructLiteral node) {
        for (int i = 0; i < node.getValues().size(); ++i) {
            BoxExpression value = node.getValues().get(i);
            BoxNode newValue = value.accept(this);
            if (newValue == value) continue;
            node.replaceChildren(newValue, value);
            node.getValues().set(i, (BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxTernaryOperation node) {
        BoxExpression whenFalse;
        BoxNode newFalse;
        BoxExpression whenTrue;
        BoxNode newTrue;
        BoxExpression condition = node.getCondition();
        BoxNode newCond = condition.accept(this);
        if (newCond != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        if ((newTrue = (whenTrue = node.getWhenTrue()).accept(this)) != whenTrue) {
            node.setWhenTrue((BoxExpression)newTrue);
        }
        if ((newFalse = (whenFalse = node.getWhenFalse()).accept(this)) != whenFalse) {
            node.setWhenFalse((BoxExpression)newFalse);
        }
        return node;
    }

    public BoxNode visit(BoxUnaryOperation node) {
        BoxExpression expr = node.getExpr();
        BoxNode newExpr = expr.accept(this);
        if (newExpr != expr) {
            node.setExpr((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxAnnotation node) {
        BoxNode newValue;
        BoxExpression value;
        BoxFQN key = node.getKey();
        BoxNode newKey = key.accept(this);
        if (newKey != key) {
            node.setKey((BoxFQN)newKey);
        }
        if ((value = node.getValue()) != null && (newValue = value.accept(this)) != value) {
            node.setValue((BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxArgumentDeclaration node) {
        BoxNode newValue;
        BoxExpression value = node.getValue();
        if (value != null && (newValue = value.accept(this)) != value) {
            node.setValue((BoxExpression)newValue);
        }
        if (node.getAnnotations() != null) {
            for (int i = 0; i < node.getAnnotations().size(); ++i) {
                BoxAnnotation annotation = node.getAnnotations().get(i);
                BoxNode newAnnotation = annotation.accept(this);
                if (newAnnotation == annotation) continue;
                node.replaceChildren(newAnnotation, annotation);
                node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
            }
        }
        if (node.getDocumentation() != null) {
            for (int i = 0; i < node.getDocumentation().size(); ++i) {
                BoxDocumentationAnnotation documentation = node.getDocumentation().get(i);
                BoxNode newDocumentation = documentation.accept(this);
                if (newDocumentation == documentation) continue;
                node.replaceChildren(newDocumentation, documentation);
                node.getDocumentation().set(i, (BoxDocumentationAnnotation)newDocumentation);
            }
        }
        return node;
    }

    public BoxNode visit(BoxAssert node) {
        BoxExpression expression = node.getExpression();
        BoxNode newExpr = expression.accept(this);
        if (newExpr != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxBreak node) {
        return node;
    }

    public BoxNode visit(BoxContinue node) {
        return node;
    }

    public BoxNode visit(BoxDo node) {
        BoxStatement body;
        BoxNode newBody;
        BoxExpression condition = node.getCondition();
        BoxNode newCond = condition.accept(this);
        if (newCond != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        if ((newBody = (body = node.getBody()).accept(this)) != body) {
            node.setBody((BoxStatement)newBody);
        }
        return node;
    }

    public BoxNode visit(BoxDocumentationAnnotation node) {
        BoxExpression value;
        BoxNode newValue;
        BoxFQN key = node.getKey();
        BoxNode newKey = key.accept(this);
        if (newKey != key) {
            node.setKey((BoxFQN)newKey);
        }
        if ((newValue = (value = node.getValue()).accept(this)) != value) {
            node.setValue((BoxExpression)newValue);
        }
        return node;
    }

    public BoxNode visit(BoxExpressionStatement node) {
        BoxExpression expression = node.getExpression();
        BoxNode newExpr = expression.accept(this);
        if (newExpr != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxForIn node) {
        BoxStatement body;
        BoxNode newBody;
        BoxExpression expression;
        BoxNode newExpr;
        BoxExpression variable = node.getVariable();
        BoxNode newVar = variable.accept(this);
        if (newVar != variable) {
            node.setVariable((BoxExpression)newVar);
        }
        if ((newExpr = (expression = node.getExpression()).accept(this)) != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        if ((newBody = (body = node.getBody()).accept(this)) != body) {
            node.setBody((BoxStatement)newBody);
        }
        return node;
    }

    public BoxNode visit(BoxForIndex node) {
        BoxStatement body;
        BoxNode newBody;
        BoxNode newStep;
        BoxExpression step;
        BoxNode newCond;
        BoxExpression condition;
        BoxNode newInit;
        BoxExpression initializer = node.getInitializer();
        if (initializer != null && (newInit = initializer.accept(this)) != initializer) {
            node.setInitializer((BoxExpression)newInit);
        }
        if ((condition = node.getCondition()) != null && (newCond = condition.accept(this)) != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        if ((step = node.getStep()) != null && (newStep = step.accept(this)) != step) {
            node.setStep((BoxExpression)newStep);
        }
        if ((newBody = (body = node.getBody()).accept(this)) != body) {
            node.setBody((BoxStatement)newBody);
        }
        return node;
    }

    public BoxNode visit(BoxFunctionDeclaration node) {
        int i;
        BoxNode newType;
        for (int i2 = 0; i2 < node.getArgs().size(); ++i2) {
            BoxArgumentDeclaration arg = node.getArgs().get(i2);
            BoxNode newArg = arg.accept(this);
            if (newArg == arg) continue;
            node.replaceChildren(newArg, arg);
            node.getArgs().set(i2, (BoxArgumentDeclaration)newArg);
        }
        BoxReturnType type = node.getType();
        if (type != null && (newType = type.accept(this)) != type) {
            node.setType((BoxReturnType)newType);
        }
        if (node.getBody() != null) {
            this.handleStatements(node.getBody(), node);
        }
        for (i = 0; i < node.getAnnotations().size(); ++i) {
            BoxAnnotation annotation = node.getAnnotations().get(i);
            BoxNode newAnnotation = annotation.accept(this);
            if (newAnnotation == annotation) continue;
            node.replaceChildren(newAnnotation, annotation);
            node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        for (i = 0; i < node.getDocumentation().size(); ++i) {
            BoxDocumentationAnnotation documentation = node.getDocumentation().get(i);
            BoxNode newDocumentation = documentation.accept(this);
            if (newDocumentation == documentation) continue;
            node.replaceChildren(newDocumentation, documentation);
            node.getDocumentation().set(i, (BoxDocumentationAnnotation)newDocumentation);
        }
        return node;
    }

    public BoxNode visit(BoxIfElse node) {
        BoxStatement body;
        BoxNode newBody;
        BoxExpression condition = node.getCondition();
        BoxNode newCond = condition.accept(this);
        if (newCond != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        if ((newBody = (body = node.getThenBody()).accept(this)) != body) {
            node.setThenBody((BoxStatement)newBody);
        }
        if (node.getElseBody() != null && (newBody = (body = node.getElseBody()).accept(this)) != body) {
            node.setElseBody((BoxStatement)newBody);
        }
        return node;
    }

    public BoxNode visit(BoxImport node) {
        BoxNode newAlias;
        BoxIdentifier alias;
        BoxNode newExpr;
        BoxExpression expression = node.getExpression();
        if (expression != null && (newExpr = expression.accept(this)) != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        if ((alias = node.getAlias()) != null && (newAlias = alias.accept(this)) != alias) {
            node.setAlias((BoxIdentifier)newAlias);
        }
        return node;
    }

    public BoxNode visit(BoxParam node) {
        BoxNode newDefault;
        BoxExpression defaultValue;
        BoxNode newType;
        BoxExpression type;
        BoxExpression variable = node.getVariable();
        BoxNode newVar = variable.accept(this);
        if (newVar != variable) {
            node.setVariable((BoxExpression)newVar);
        }
        if ((type = node.getType()) != null && (newType = type.accept(this)) != type) {
            node.setType((BoxExpression)newType);
        }
        if ((defaultValue = node.getDefaultValue()) != null && (newDefault = defaultValue.accept(this)) != defaultValue) {
            node.setDefaultValue((BoxExpression)newDefault);
        }
        return node;
    }

    public BoxNode visit(BoxProperty node) {
        BoxNode newAnnotation;
        BoxAnnotation annotation;
        int i;
        for (i = 0; i < node.getAnnotations().size(); ++i) {
            annotation = node.getAnnotations().get(i);
            newAnnotation = annotation.accept(this);
            if (newAnnotation == annotation) continue;
            node.replaceChildren(newAnnotation, annotation);
            node.getAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        for (i = 0; i < node.getPostAnnotations().size(); ++i) {
            annotation = node.getPostAnnotations().get(i);
            newAnnotation = annotation.accept(this);
            if (newAnnotation == annotation) continue;
            node.replaceChildren(newAnnotation, annotation);
            node.getPostAnnotations().set(i, (BoxAnnotation)newAnnotation);
        }
        for (i = 0; i < node.getDocumentation().size(); ++i) {
            BoxDocumentationAnnotation documentation = node.getDocumentation().get(i);
            BoxNode newDocumentation = documentation.accept(this);
            if (newDocumentation == documentation) continue;
            node.replaceChildren(newDocumentation, documentation);
            node.getDocumentation().set(i, (BoxDocumentationAnnotation)newDocumentation);
        }
        return node;
    }

    public BoxNode visit(BoxRethrow node) {
        return node;
    }

    public BoxNode visit(BoxReturn node) {
        BoxNode newExpr;
        BoxExpression expression = node.getExpression();
        if (expression != null && (newExpr = expression.accept(this)) != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        return node;
    }

    public BoxNode visit(BoxFunctionalBIFAccess node) {
        return node;
    }

    public BoxNode visit(BoxFunctionalMemberAccess node) {
        for (int i = 0; i < node.getArguments().size(); ++i) {
            BoxArgument argument = node.getArguments().get(i);
            BoxNode newArgument = argument.accept(this);
            if (newArgument == argument) continue;
            node.replaceChildren(newArgument, argument);
            node.getArguments().set(i, (BoxArgument)newArgument);
        }
        return node;
    }

    public BoxNode visit(BoxReturnType node) {
        return node;
    }

    public BoxNode visit(BoxSwitch node) {
        BoxExpression condition = node.getCondition();
        BoxNode newCond = condition.accept(this);
        if (newCond != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        for (int i = 0; i < node.getCases().size(); ++i) {
            BoxSwitchCase caseNode = node.getCases().get(i);
            BoxNode newCase = caseNode.accept(this);
            if (newCase == caseNode) continue;
            node.replaceChildren(newCase, caseNode);
            node.getCases().set(i, (BoxSwitchCase)newCase);
        }
        return node;
    }

    public BoxNode visit(BoxSwitchCase node) {
        BoxNode newDelim;
        BoxExpression delimiter;
        BoxNode newCond;
        BoxExpression condition = node.getCondition();
        if (condition != null && (newCond = condition.accept(this)) != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        if ((delimiter = node.getDelimiter()) != null && (newDelim = delimiter.accept(this)) != delimiter) {
            node.setDelimiter((BoxExpression)newDelim);
        }
        this.handleStatements(node.getBody(), node);
        return node;
    }

    public BoxNode visit(BoxThrow node) {
        BoxNode newInfo;
        BoxExpression extendedinfo;
        BoxNode newCode;
        BoxExpression errorcode;
        BoxNode newDetail;
        BoxExpression detail;
        BoxNode newMsg;
        BoxExpression message;
        BoxNode newType;
        BoxExpression type;
        BoxNode newExpr;
        BoxExpression expression = node.getExpression();
        if (expression != null && (newExpr = expression.accept(this)) != expression) {
            node.setExpression((BoxExpression)newExpr);
        }
        if ((type = node.getType()) != null && (newType = type.accept(this)) != type) {
            node.setType((BoxExpression)newType);
        }
        if ((message = node.getMessage()) != null && (newMsg = message.accept(this)) != message) {
            node.setMessage((BoxExpression)newMsg);
        }
        if ((detail = node.getDetail()) != null && (newDetail = detail.accept(this)) != detail) {
            node.setDetail((BoxExpression)newDetail);
        }
        if ((errorcode = node.getErrorCode()) != null && (newCode = errorcode.accept(this)) != errorcode) {
            node.setErrorCode((BoxExpression)newCode);
        }
        if ((extendedinfo = node.getExtendedInfo()) != null && (newInfo = extendedinfo.accept(this)) != extendedinfo) {
            node.setExtendedInfo((BoxExpression)newInfo);
        }
        return node;
    }

    public BoxNode visit(BoxTry node) {
        this.handleStatements(node.getTryBody(), node);
        for (int i = 0; i < node.getCatches().size(); ++i) {
            BoxTryCatch catchNode = node.getCatches().get(i);
            BoxNode newCatch = catchNode.accept(this);
            if (newCatch == catchNode) continue;
            node.replaceChildren(newCatch, catchNode);
            node.getCatches().set(i, (BoxTryCatch)newCatch);
        }
        this.handleStatements(node.getFinallyBody(), node);
        return node;
    }

    public BoxNode visit(BoxTryCatch node) {
        BoxIdentifier exception = node.getException();
        BoxNode newExc = exception.accept(this);
        if (newExc != exception) {
            node.setException((BoxIdentifier)newExc);
        }
        this.handleStatements(node.getCatchBody(), node);
        for (int i = 0; i < node.getCatchTypes().size(); ++i) {
            BoxExpression type = node.getCatchTypes().get(i);
            BoxNode newType = type.accept(this);
            if (newType == type) continue;
            node.replaceChildren(newType, type);
            node.getCatchTypes().set(i, (BoxExpression)newType);
        }
        return node;
    }

    public BoxNode visit(BoxWhile node) {
        BoxStatement body;
        BoxNode newBody;
        BoxExpression condition = node.getCondition();
        BoxNode newCond = condition.accept(this);
        if (newCond != condition) {
            node.setCondition((BoxExpression)newCond);
        }
        if ((newBody = (body = node.getBody()).accept(this)) != body) {
            node.setBody((BoxStatement)newBody);
        }
        return node;
    }

    public BoxNode visit(BoxComponent node) {
        if (node.getAttributes() != null) {
            for (int i = 0; i < node.getAttributes().size(); ++i) {
                BoxAnnotation annotation = node.getAttributes().get(i);
                BoxNode newAnnotation = annotation.accept(this);
                if (newAnnotation == annotation) continue;
                node.replaceChildren(newAnnotation, annotation);
                node.getAttributes().set(i, (BoxAnnotation)newAnnotation);
            }
        }
        this.handleStatements(node.getBody(), node);
        return node;
    }

    private void handleStatements(List<BoxStatement> statements, BoxNode node) {
        if (statements == null) {
            return;
        }
        for (int i = 0; i < statements.size(); ++i) {
            BoxStatement statement = statements.get(i);
            BoxNode newStatement = statement.accept(this);
            if (newStatement == statement) continue;
            node.replaceChildren(newStatement, statement);
            if (newStatement != null) {
                statements.set(i, (BoxStatement)newStatement);
                continue;
            }
            statements.remove(i);
            --i;
        }
    }
}

