/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.ast.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.visitor.VoidBoxVisitor;
import ortus.boxlang.runtime.BoxRuntime;

public class UnencodedVariableOutputVisitor
extends VoidBoxVisitor {
    List<Issue> issues = new ArrayList<Issue>();
    Set<String> encodeBIFs = Set.of("encodeforhtml", "encodeforhtmlattribute", "encodeforjavascript", "encodeforcss", "encodeforurl", "htmleditformat");

    public List<Issue> getIssues() {
        return this.issues;
    }

    @Override
    public void visit(BoxBufferOutput node) {
        if (node.getExpression() instanceof BoxStringInterpolation) {
            this.checkNode(node.getExpression());
        }
        super.visit(node);
    }

    private void checkNode(BoxExpression node) {
        if (!(node instanceof BoxStringInterpolation) && !node.isLiteral() && !this.isBIFCall(node) && this.isNotEncoded(node)) {
            this.issues.add(new Issue("Un-encoded " + node.getClass().getSimpleName() + " output on line " + node.getPosition().getStart().getLine() + " -- " + node.toString(), node));
        } else {
            node.getChildren().forEach(e -> this.checkNode((BoxExpression)e));
        }
    }

    private boolean isBIFCall(BoxExpression node) {
        if (node instanceof BoxFunctionInvocation) {
            BoxFunctionInvocation bfi = (BoxFunctionInvocation)node;
            return BoxRuntime.getInstance().getFunctionService().hasGlobalFunction(bfi.getName());
        }
        return false;
    }

    private boolean isNotEncoded(BoxExpression expr) {
        return expr.getFirstAncestorOfType(BoxFunctionInvocation.class, n -> this.encodeBIFs.contains(n.getName().toLowerCase())) == null;
    }

    public record Issue(String message, BoxExpression expr) {
    }
}

