/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import ortus.boxlang.compiler.Boxpiler;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.JavaSourceString;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.visitor.QueryEscapeSingleQuoteVisitor;
import ortus.boxlang.compiler.javaboxpiler.CustomPrettyPrinter;
import ortus.boxlang.compiler.javaboxpiler.TranspiledCode;
import ortus.boxlang.compiler.javaboxpiler.Transpiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.ProxyTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.indexer.BoxNodeKey;
import ortus.boxlang.compiler.parser.Parser;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.util.ResolvedFilePath;

public class JavaBoxpiler
extends Boxpiler {
    private static JavaBoxpiler instance;
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    private JavaBoxpiler() {
    }

    public static synchronized JavaBoxpiler getInstance() {
        if (instance == null) {
            instance = new JavaBoxpiler();
        }
        return instance;
    }

    @Override
    public void printTranspiledCode(ParsingResult result, ClassInfo classInfo, PrintStream target) {
        target.print(this.generateJavaSource(result.getRoot(), classInfo));
    }

    public String generateJavaSource(BoxNode node, ClassInfo classInfo) {
        TranspiledCode javaASTs;
        node.accept(new QueryEscapeSingleQuoteVisitor());
        Transpiler transpiler = Transpiler.getTranspiler();
        transpiler.setProperty("classname", classInfo.className());
        transpiler.setProperty("packageName", classInfo.packageName().toString());
        transpiler.setProperty("boxFQN", classInfo.boxFqn().toString());
        transpiler.setProperty("baseclass", classInfo.baseclass());
        transpiler.setProperty("returnType", classInfo.returnType());
        transpiler.setProperty("sourceType", classInfo.sourceType().name());
        transpiler.setProperty("mappingName", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().mappingName());
        transpiler.setProperty("mappingPath", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().mappingPath());
        transpiler.setProperty("relativePath", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().relativePath());
        DynamicObject trans = this.frTransService.startTransaction("Java Transpilation", classInfo.toString());
        try {
            javaASTs = transpiler.transpile(node);
        }
        catch (ExpressionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BoxRuntimeException("Error transpiling BoxLang to Java. " + classInfo.toString(), e);
        }
        finally {
            this.frTransService.endTransaction(trans);
        }
        ClassOrInterfaceDeclaration outerClass = javaASTs.getEntryPoint().getClassByName(classInfo.className()).get();
        for (CompilationUnit callable : javaASTs.getCallables()) {
            ClassOrInterfaceDeclaration innerClass = callable.findFirst(ClassOrInterfaceDeclaration.class).get();
            outerClass.addMember((BodyDeclaration)((ClassOrInterfaceDeclaration)innerClass.setPublic(true)).setStatic(true));
        }
        CustomPrettyPrinter prettyPrinter = new CustomPrettyPrinter();
        String javaSource = prettyPrinter.print(javaASTs.getEntryPoint());
        this.diskClassUtil.writeLineNumbers(classInfo.classPoolName(), classInfo.fqn().toString(), this.generateLineNumberJSON(classInfo, prettyPrinter.getVisitor().getLineNumbers()));
        return javaSource;
    }

    @Override
    public void compileClassInfo(String classPoolName, String FQN2) {
        ClassInfo classInfo;
        if (BoxRuntime.getInstance().inDebugMode().booleanValue()) {
            System.out.println("Compiling " + FQN2);
        }
        if ((classInfo = this.getClassPool(classPoolName).get(FQN2)) == null) {
            throw new BoxRuntimeException("ClassInfo not found for " + FQN2);
        }
        if (classInfo.resolvedFilePath() != null) {
            File sourceFile = classInfo.resolvedFilePath().absolutePath().toFile();
            if (this.diskClassUtil.isJavaBytecode(sourceFile)) {
                classInfo.getClassLoader().defineClasses(FQN2, sourceFile);
                return;
            }
            ParsingResult result = this.parseOrFail(sourceFile);
            this.compileSource(this.generateJavaSource(result.getRoot(), classInfo), classInfo.fqn().toString(), classPoolName);
        } else if (classInfo.source() != null) {
            ParsingResult result = this.parseOrFail(classInfo.source(), classInfo.sourceType(), classInfo.isClass());
            this.compileSource(this.generateJavaSource(result.getRoot(), classInfo), classInfo.fqn().toString(), classPoolName);
        } else if (classInfo.interfaceProxyDefinition() != null) {
            this.compileSource(this.generateProxyJavaSource(classInfo), classInfo.fqn().toString(), classPoolName);
        } else {
            throw new BoxRuntimeException("Unknown class info type: " + classInfo.toString());
        }
    }

    private void compileSource(String javaSource, String fqn, String classPoolName) {
        DynamicObject trans = this.frTransService.startTransaction("Java Compilation", fqn);
        this.diskClassUtil.writeJavaSource(classPoolName, fqn, javaSource);
        try {
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(diagnostics, null, null);
            String classPoolDiskPrefix = classPoolName.replaceAll("[^a-zA-Z0-9]", "_");
            fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(this.classGenerationDirectory.resolve(classPoolDiskPrefix).toFile()));
            String javaRT = System.getProperty("java.class.path");
            String jarPath = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toString();
            List<JavaSourceString> sourceFiles = Collections.singletonList(new JavaSourceString(fqn, javaSource));
            List<String> options = List.of("-g", "-cp", jarPath, "-source", "21", "-target", "21");
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, diagnostics, options, null, sourceFiles);
            boolean compilerResult = task.call();
            if (!compilerResult) {
                String errors = diagnostics.getDiagnostics().stream().map(d -> d.toString()).collect(Collectors.joining("\n"));
                throw new BoxRuntimeException(errors + "\n" + javaSource);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new BoxRuntimeException("Error compiling source " + fqn, e);
        }
        finally {
            this.frTransService.endTransaction(trans);
        }
    }

    private String generateLineNumberJSON(ClassInfo classInfo, List<Object[]> lineNumbers) {
        List stuff = lineNumbers.stream().map(e -> {
            Node jNode = (Node)e[0];
            int jLineStart = (Integer)e[1];
            int jLineEnd = (Integer)e[2];
            String jClassName = (String)e[3];
            if (!jNode.containsData(BoxNodeKey.BOX_NODE_DATA_KEY)) {
                return null;
            }
            BoxNode boxNode = jNode.getData(BoxNodeKey.BOX_NODE_DATA_KEY);
            if (boxNode.getPosition() == null) {
                return null;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("javaSourceLineStart", jLineStart);
            map.put("javaSourceLineEnd", jLineEnd);
            map.put("originSourceLineStart", boxNode.getPosition().getStart().getLine());
            map.put("originSourceLineEnd", boxNode.getPosition().getEnd().getLine());
            map.put("javaSourceClassName", jClassName);
            map.put("javaSourceNode", jNode.getClass().getSimpleName());
            map.put("originSourceNode", boxNode.getClass().getSimpleName());
            return map;
        }).filter(e -> e != null).sorted((e1, e2) -> {
            int result2 = ((Integer)e1.get("originSourceLineStart")).compareTo((Integer)e2.get("originSourceLineStart"));
            if (result2 == 0) {
                result2 = ((Integer)e1.get("javaSourceLineStart")).compareTo((Integer)e2.get("javaSourceLineStart"));
            }
            return result2;
        }).collect(Collectors.toList());
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put("sourceMapRecords", stuff);
        output.put("source", classInfo.resolvedFilePath() == null ? null : classInfo.resolvedFilePath().absolutePath().toString());
        try {
            return JSON.std.with(JSON.Feature.PRETTY_PRINT_OUTPUT).asString(output);
        }
        catch (JSONObjectException e3) {
            e3.printStackTrace();
            return null;
        }
        catch (IOException e4) {
            e4.printStackTrace();
            return null;
        }
    }

    private String generateProxyJavaSource(ClassInfo classInfo) {
        return ProxyTransformer.transform(classInfo);
    }

    @Override
    public List<byte[]> compileTemplateBytes(ResolvedFilePath resolvedFilePath) {
        Path path = resolvedFilePath.absolutePath();
        ClassInfo classInfo = null;
        classInfo = path.toString().endsWith(".bx") || path.toString().endsWith(".cfc") ? ClassInfo.forClass(resolvedFilePath, Parser.detectFile(path.toFile()), (IBoxpiler)this) : ClassInfo.forTemplate(resolvedFilePath, Parser.detectFile(path.toFile()), this);
        Map<String, ClassInfo> classPool = this.getClassPool(classInfo.classPoolName());
        classPool.putIfAbsent(classInfo.fqn().toString(), classInfo);
        this.compileClassInfo(classInfo.classPoolName(), classInfo.fqn().toString());
        return this.diskClassUtil.readClassBytes(classInfo.classPoolName(), classInfo.fqn().toString());
    }
}

