/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.compiler.JavaSourceString;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxInterface;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxScript;
import ortus.boxlang.compiler.ast.BoxStaticInitializer;
import ortus.boxlang.compiler.ast.BoxTemplate;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxArrayAccess;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxDecimalLiteral;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalBIFAccess;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalMemberAccess;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxNegateOperation;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxParenthesis;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStaticAccess;
import ortus.boxlang.compiler.ast.expression.BoxStaticMethodInvocation;
import ortus.boxlang.compiler.ast.expression.BoxStringConcat;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStructLiteral;
import ortus.boxlang.compiler.ast.expression.BoxTernaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.statement.BoxAccessModifier;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxAssert;
import ortus.boxlang.compiler.ast.statement.BoxBreak;
import ortus.boxlang.compiler.ast.statement.BoxBufferOutput;
import ortus.boxlang.compiler.ast.statement.BoxContinue;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxIfElse;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxParam;
import ortus.boxlang.compiler.ast.statement.BoxRethrow;
import ortus.boxlang.compiler.ast.statement.BoxReturn;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxScriptIsland;
import ortus.boxlang.compiler.ast.statement.BoxStatementBlock;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxThrow;
import ortus.boxlang.compiler.ast.statement.BoxTry;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.ast.statement.component.BoxTemplateIsland;
import ortus.boxlang.compiler.javaboxpiler.TranspiledCode;
import ortus.boxlang.compiler.javaboxpiler.Transpiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.BoxClassTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.BoxInterfaceTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.BoxStaticInitializerTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.Transformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxAccessTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxArgumentTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxArrayLiteralTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxAssignmentTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxBinaryOperationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxBooleanLiteralTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxClosureTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxComparisonOperationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxDecimalLiteralTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxExpressionInvocationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxFQNTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxFunctionInvocationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxFunctionalBIFAccessTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxFunctionalMemberAccessTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxIdentifierTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxIntegerLiteralTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxLambdaTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxMethodInvocationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxNegateOperationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxNewTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxNullTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxParenthesisTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxScopeTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxStaticAccessTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxStaticMethodInvocationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxStringConcatTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxStringInterpolationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxStringLiteralTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxStructLiteralTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxTernaryOperationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.expression.BoxUnaryOperationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxArgumentDeclarationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxAssertTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxBreakTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxBufferOutputTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxContinueTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxDoTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxExpressionStatementTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxForInTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxForIndexTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxFunctionDeclarationTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxIfElseTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxImportTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxParamTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxRethrowTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxReturnTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxScriptTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxStatementBlockTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxSwitchTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxTemplateTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxThrowTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxTryTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.BoxWhileTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.component.BoxComponentTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.component.BoxScriptIslandTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.statement.component.BoxTemplateIslandTransformer;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class JavaTranspiler
extends Transpiler {
    static Logger logger = LoggerFactory.getLogger(JavaTranspiler.class);
    private HashMap<Class, Transformer> registry = new HashMap();
    private List<Statement> statements = new ArrayList<Statement>();
    private Map<Key, CompilationUnit> UDFcallables = new HashMap<Key, CompilationUnit>();
    private List<CompilationUnit> callables = new ArrayList<CompilationUnit>();
    private List<Statement> UDFDeclarations = new ArrayList<Statement>();
    private List<Statement> staticUDFDeclarations = new ArrayList<Statement>();

    public JavaTranspiler() {
        this.registry.put(BoxScript.class, new BoxScriptTransformer(this));
        this.registry.put(BoxExpressionStatement.class, new BoxExpressionStatementTransformer(this));
        this.registry.put(BoxIdentifier.class, new BoxIdentifierTransformer(this));
        this.registry.put(BoxScope.class, new BoxScopeTransformer(this));
        this.registry.put(BoxStringLiteral.class, new BoxStringLiteralTransformer(this));
        this.registry.put(BoxIntegerLiteral.class, new BoxIntegerLiteralTransformer(this));
        this.registry.put(BoxBooleanLiteral.class, new BoxBooleanLiteralTransformer(this));
        this.registry.put(BoxDecimalLiteral.class, new BoxDecimalLiteralTransformer(this));
        this.registry.put(BoxStringInterpolation.class, new BoxStringInterpolationTransformer(this));
        this.registry.put(BoxStringConcat.class, new BoxStringConcatTransformer(this));
        this.registry.put(BoxArgument.class, new BoxArgumentTransformer(this));
        this.registry.put(BoxFQN.class, new BoxFQNTransformer(this));
        this.registry.put(BoxParenthesis.class, new BoxParenthesisTransformer(this));
        this.registry.put(BoxBinaryOperation.class, new BoxBinaryOperationTransformer(this));
        this.registry.put(BoxTernaryOperation.class, new BoxTernaryOperationTransformer(this));
        this.registry.put(BoxNegateOperation.class, new BoxNegateOperationTransformer(this));
        this.registry.put(BoxComparisonOperation.class, new BoxComparisonOperationTransformer(this));
        this.registry.put(BoxUnaryOperation.class, new BoxUnaryOperationTransformer(this));
        this.registry.put(BoxDotAccess.class, new BoxAccessTransformer(this));
        this.registry.put(BoxStaticAccess.class, new BoxStaticAccessTransformer(this));
        this.registry.put(BoxArrayAccess.class, new BoxAccessTransformer(this));
        this.registry.put(BoxStaticMethodInvocation.class, new BoxStaticMethodInvocationTransformer(this));
        this.registry.put(BoxMethodInvocation.class, new BoxMethodInvocationTransformer(this));
        this.registry.put(BoxFunctionInvocation.class, new BoxFunctionInvocationTransformer(this));
        this.registry.put(BoxIfElse.class, new BoxIfElseTransformer(this));
        this.registry.put(BoxWhile.class, new BoxWhileTransformer(this));
        this.registry.put(BoxDo.class, new BoxDoTransformer(this));
        this.registry.put(BoxSwitch.class, new BoxSwitchTransformer(this));
        this.registry.put(BoxBreak.class, new BoxBreakTransformer(this));
        this.registry.put(BoxContinue.class, new BoxContinueTransformer(this));
        this.registry.put(BoxForIn.class, new BoxForInTransformer(this));
        this.registry.put(BoxForIndex.class, new BoxForIndexTransformer(this));
        this.registry.put(BoxAssert.class, new BoxAssertTransformer(this));
        this.registry.put(BoxTry.class, new BoxTryTransformer(this));
        this.registry.put(BoxThrow.class, new BoxThrowTransformer(this));
        this.registry.put(BoxNew.class, new BoxNewTransformer(this));
        this.registry.put(BoxFunctionDeclaration.class, new BoxFunctionDeclarationTransformer(this));
        this.registry.put(BoxArgumentDeclaration.class, new BoxArgumentDeclarationTransformer(this));
        this.registry.put(BoxReturn.class, new BoxReturnTransformer(this));
        this.registry.put(BoxRethrow.class, new BoxRethrowTransformer(this));
        this.registry.put(BoxImport.class, new BoxImportTransformer(this));
        this.registry.put(BoxArrayLiteral.class, new BoxArrayLiteralTransformer(this));
        this.registry.put(BoxStructLiteral.class, new BoxStructLiteralTransformer(this));
        this.registry.put(BoxAssignment.class, new BoxAssignmentTransformer(this));
        this.registry.put(BoxNull.class, new BoxNullTransformer(this));
        this.registry.put(BoxLambda.class, new BoxLambdaTransformer(this));
        this.registry.put(BoxExpressionInvocation.class, new BoxExpressionInvocationTransformer(this));
        this.registry.put(BoxClosure.class, new BoxClosureTransformer(this));
        this.registry.put(BoxClass.class, new BoxClassTransformer(this));
        this.registry.put(BoxParam.class, new BoxParamTransformer(this));
        this.registry.put(BoxStatementBlock.class, new BoxStatementBlockTransformer(this));
        this.registry.put(BoxStaticInitializer.class, new BoxStaticInitializerTransformer(this));
        this.registry.put(BoxFunctionalMemberAccess.class, new BoxFunctionalMemberAccessTransformer(this));
        this.registry.put(BoxFunctionalBIFAccess.class, new BoxFunctionalBIFAccessTransformer(this));
        this.registry.put(BoxTemplate.class, new BoxTemplateTransformer(this));
        this.registry.put(BoxBufferOutput.class, new BoxBufferOutputTransformer(this));
        this.registry.put(BoxScriptIsland.class, new BoxScriptIslandTransformer(this));
        this.registry.put(BoxTemplateIsland.class, new BoxTemplateIslandTransformer(this));
        this.registry.put(BoxComponent.class, new BoxComponentTransformer(this));
        this.registry.put(BoxInterface.class, new BoxInterfaceTransformer(this));
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        Transformer transformer = this.registry.get(node.getClass());
        if (transformer != null) {
            Node javaNode = transformer.transform(node, context);
            return javaNode;
        }
        throw new IllegalStateException("unsupported: " + node.getClass().getSimpleName() + " : " + node.getSourceText());
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public String compileJava(CompilationUnit cu, String outputPath, List<String> classPath) throws IllegalStateException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        String pkg = cu.getPackageDeclaration().orElseThrow().getName().toString();
        String name = cu.getType(0).getName().asString();
        String fqn = pkg + "." + name;
        List<JavaSourceString> sourceFiles = Collections.singletonList(new JavaSourceString(fqn, cu.toString()));
        Writer output = null;
        ArrayList<String> classPathList = new ArrayList<String>();
        classPathList.add(System.getProperty("java.class.path"));
        classPathList.addAll(classPath);
        classPathList.add(outputPath);
        String compilerClassPath = classPathList.stream().map(it -> it).collect(Collectors.joining(File.pathSeparator));
        StandardJavaFileManager stdFileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<String> options = new ArrayList<String>(List.of("-g", "-cp", compilerClassPath, "-d", outputPath));
        JavaCompiler.CompilationTask task = compiler.getTask(output, stdFileManager, diagnostics, options, null, sourceFiles);
        boolean result = task.call();
        if (!result) {
            diagnostics.getDiagnostics().forEach(d -> logger.error(String.valueOf(d)));
            throw new IllegalStateException("Compiler Error");
        }
        try {
            stdFileManager.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Compiler Error");
        }
        return fqn;
    }

    @Override
    public TranspiledCode transpile(BoxNode node) throws BoxRuntimeException {
        CompilationUnit entryPoint = (CompilationUnit)this.transform(node);
        List<CompilationUnit> allCallables = this.getCallables();
        allCallables.addAll(this.getUDFcallables().values());
        return new TranspiledCode(entryPoint, allCallables);
    }

    public List<CompilationUnit> getCallables() {
        return this.callables;
    }

    public Map<Key, CompilationUnit> getUDFcallables() {
        return this.UDFcallables;
    }

    public List<Statement> getUDFDeclarations() {
        return this.UDFDeclarations;
    }

    public List<Statement> getStaticUDFDeclarations() {
        return this.staticUDFDeclarations;
    }

    public Expression createAbstractMethod(BoxFunctionDeclaration bfd, AbstractTransformer transformer, String sourceObjectName, String sourceObjectType) {
        String returnTypeString;
        BoxAccessModifier access = bfd.getAccessModifier();
        BoxReturnType boxReturnType = bfd.getType();
        BoxType returnType = BoxType.Any;
        String fqn = null;
        if (boxReturnType != null && (returnType = boxReturnType.getType()).equals((Object)BoxType.Fqn)) {
            fqn = boxReturnType.getFqn();
        }
        String string = returnTypeString = returnType.equals((Object)BoxType.Fqn) ? fqn : returnType.name();
        if (access == null) {
            access = BoxAccessModifier.Public;
        }
        ArrayInitializerExpr argInitializer = new ArrayInitializerExpr();
        bfd.getArgs().forEach(arg -> {
            Expression argument = (Expression)this.transform((BoxNode)arg);
            argInitializer.getValues().add(argument);
        });
        ArrayCreationExpr argumentsArray = new ArrayCreationExpr().setElementType("Argument").setInitializer(argInitializer);
        return (Expression)((MethodCallExpr)new MethodCallExpr((Expression)new NameExpr("abstractMethods"), "put").addArgument(transformer.createKey(bfd.getName()))).addArgument((Expression)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)((ObjectCreationExpr)new ObjectCreationExpr().setType("AbstractFunction")).addArgument(transformer.createKey(bfd.getName()))).addArgument(argumentsArray)).addArgument(new StringLiteralExpr(returnTypeString))).addArgument(new FieldAccessExpr(new FieldAccessExpr(new NameExpr("Function"), "Access"), access.toString().toUpperCase()))).addArgument(transformer.transformAnnotations(bfd.getAnnotations()))).addArgument(transformer.transformDocumentation(bfd.getDocumentation()))).addArgument(new StringLiteralExpr(sourceObjectName))).addArgument(new StringLiteralExpr(sourceObjectType)));
    }
}

