/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.BlockStmt;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.javaboxpiler.ITranspiler;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.TranspiledCode;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.loader.ImportDefinition;
import ortus.boxlang.runtime.runnables.BoxScript;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public abstract class Transpiler
implements ITranspiler {
    private final HashMap<String, String> properties = new HashMap();
    private int tryCatchCounter = 0;
    private int switchCounter = 0;
    private int forInCounter = 0;
    private int lambdaCounter = 0;
    private int closureCounter = 0;
    private int lambdaContextCounter = 0;
    private int componentCounter = 0;
    private int componentOptionalCounter = 0;
    private int functionBodyCounter = 0;
    private ArrayDeque<String> currentContextName = new ArrayDeque();
    private List<ImportDefinition> imports = new ArrayList<ImportDefinition>();
    private List<Expression> jimports = new ArrayList<Expression>();
    private Map<String, BoxExpression> keys = new LinkedHashMap<String, BoxExpression>();
    private List<BlockStmt> staticInitializers = new ArrayList<BlockStmt>();

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public static Transpiler getTranspiler() {
        return new JavaTranspiler();
    }

    @Override
    public abstract TranspiledCode transpile(BoxNode var1) throws BoxRuntimeException;

    public Node transform(BoxNode node) throws IllegalStateException {
        return this.transform(node, TransformerContext.NONE);
    }

    public abstract Node transform(BoxNode var1, TransformerContext var2);

    @Override
    public void run(String fqn, List<String> classPath) throws Throwable {
        ArrayList<URL> finalClassPath = new ArrayList<URL>();
        for (String path : classPath) {
            try {
                finalClassPath.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        URL[] classLoaderClassPath = finalClassPath.toArray(new URL[0]);
        URLClassLoader classLoader = new URLClassLoader(classLoaderClassPath, this.getClass().getClassLoader());
        Class<?> boxClass = Class.forName(fqn, true, classLoader);
        Method method = boxClass.getDeclaredMethod("getInstance", new Class[0]);
        BoxScript scriptRunnable = (BoxScript)method.invoke(boxClass, new Object[0]);
        BoxRuntime instance = BoxRuntime.getInstance(true);
        ScriptingRequestBoxContext context = new ScriptingRequestBoxContext(instance.getRuntimeContext());
        Object object = scriptRunnable.invoke(context);
    }

    public int incrementAndGetTryCatchCounter() {
        return ++this.tryCatchCounter;
    }

    public int incrementAndGetSwitchCounter() {
        return ++this.switchCounter;
    }

    public int incrementAndGetForInCounter() {
        return ++this.forInCounter;
    }

    public void pushContextName(String name) {
        if (name == null) {
            throw new BoxRuntimeException("Context name cannot be null");
        }
        this.currentContextName.push(name);
    }

    public String popContextName() {
        return this.currentContextName.pop();
    }

    public String peekContextName() {
        return this.currentContextName.peek();
    }

    public void addImport(String importString) {
        this.imports.add(ImportDefinition.parse(importString));
    }

    public boolean matchesImport(String token) {
        return this.imports.stream().anyMatch(i -> token.equalsIgnoreCase(i.alias()) || token.equalsIgnoreCase(i.className()));
    }

    public int incrementAndGetLambdaCounter() {
        return ++this.lambdaCounter;
    }

    public int incrementAndGetClosureCounter() {
        return ++this.closureCounter;
    }

    public int incrementAndGetLambdaContextCounter() {
        return ++this.lambdaContextCounter;
    }

    public int incrementAndGetComponentOptionalCounter() {
        return ++this.componentOptionalCounter;
    }

    public void pushComponent() {
        ++this.componentCounter;
    }

    public void popComponent() {
        --this.componentCounter;
    }

    public int getComponentCounter() {
        return this.componentCounter;
    }

    public void setComponentCounter(int componentCounter) {
        this.componentCounter = componentCounter;
    }

    public boolean isInsideComponent() {
        return this.componentCounter > 0;
    }

    public void pushfunctionBodyCounter() {
        ++this.functionBodyCounter;
    }

    public void popfunctionBodyCounter() {
        --this.functionBodyCounter;
    }

    public void addJImport(Expression jImport) {
        this.jimports.add(jImport);
    }

    public List<Expression> getJImports() {
        return this.jimports;
    }

    public void addStaticInitializer(BlockStmt block) {
        this.staticInitializers.add(block);
    }

    public List<BlockStmt> getStaticInitializers() {
        return this.staticInitializers;
    }

    public boolean canReturn() {
        if (this.functionBodyCounter > 0) {
            return true;
        }
        String returnType = this.getProperty("returnType");
        return returnType != null && !returnType.equals("void");
    }

    public int registerKey(BoxExpression key) {
        String name;
        if (key instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)key;
            name = str.getValue();
        } else if (key instanceof BoxIntegerLiteral) {
            BoxIntegerLiteral intr = (BoxIntegerLiteral)key;
            name = intr.getValue();
        } else {
            throw new IllegalStateException("Key must be a string or integer literal");
        }
        if (this.keys.keySet().contains(name)) {
            return new ArrayList<String>(this.keys.keySet()).indexOf(name);
        }
        this.keys.put(name, key);
        return this.keys.size() - 1;
    }

    public Map<String, BoxExpression> getKeys() {
        return this.keys;
    }

    public String getDateTime(LocalDateTime locaTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ss");
        return "LocalDateTime.parse(\"" + formatter.format(locaTime) + "\")";
    }

    public String getResolvedFilePath(String mappingName, String mappingPath, String relativePath, String filePath) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResolvedFilePath.of(\"");
        sb.append(mappingName == null ? "" : this.escapeJavaString(mappingName));
        sb.append("\", \"");
        sb.append(mappingPath == null ? "" : this.escapeJavaString(mappingPath));
        sb.append("\", \"");
        sb.append(relativePath == null ? "" : this.escapeJavaString(relativePath));
        sb.append("\", \"");
        sb.append(this.escapeJavaString(filePath));
        sb.append("\")");
        return sb.toString();
    }

    public String escapeJavaString(String str) {
        return str.replaceAll("\\\\", "\\\\\\\\");
    }
}

