/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperator;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxLambda;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxUnaryOperator;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxDo;
import ortus.boxlang.compiler.ast.statement.BoxDocumentationAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxForIn;
import ortus.boxlang.compiler.ast.statement.BoxForIndex;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxSwitch;
import ortus.boxlang.compiler.ast.statement.BoxWhile;
import ortus.boxlang.compiler.ast.statement.component.BoxComponent;
import ortus.boxlang.compiler.javaboxpiler.Transpiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.Transformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.compiler.javaboxpiler.transformer.indexer.BoxNodeKey;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;

public abstract class AbstractTransformer
implements Transformer {
    protected Transpiler transpiler;
    protected JavaParser javaParser = new JavaParser(new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.JAVA_17_PREVIEW));
    protected Logger logger;

    public AbstractTransformer(Transpiler transpiler) {
        this.transpiler = transpiler;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public abstract Node transform(BoxNode var1, TransformerContext var2) throws IllegalStateException;

    @Override
    public Node transform(BoxNode node) throws IllegalStateException {
        return this.transform(node, TransformerContext.NONE);
    }

    protected Expression parseExpression(String template, Map<String, String> values) {
        String code = PlaceholderHelper.resolve(template, values);
        try {
            ParseResult result = this.javaParser.parseExpression(code);
            if (!result.isSuccessful()) {
                throw new IllegalStateException(result.toString());
            }
            return (Expression)result.getResult().get();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error parsing expression: " + code, e);
        }
    }

    protected Statement parseStatement(String template, Map<String, String> values) {
        String code = PlaceholderHelper.resolve(template, values);
        ParseResult<Statement> result = this.javaParser.parseStatement(code);
        if (!result.isSuccessful()) {
            throw new IllegalStateException(result.toString());
        }
        return result.getResult().get();
    }

    public Expression createKey(BoxExpression expr) {
        if (expr instanceof BoxStringLiteral || expr instanceof BoxIntegerLiteral) {
            int pos = this.transpiler.registerKey(expr);
            return this.parseExpression(this.transpiler.getProperty("classname") + ".keys[" + pos + "]", new HashMap<String, String>());
        }
        NameExpr nameExpr = new NameExpr("Key");
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)nameExpr, "of");
        methodCallExpr.addArgument((Expression)this.transpiler.transform(expr));
        return methodCallExpr;
    }

    public Expression createKey(String expr) {
        return this.createKey(new BoxStringLiteral(expr, null, expr));
    }

    protected boolean requiresBooleanCaster(BoxExpression condition) {
        BoxExpression op;
        if (condition instanceof BoxBinaryOperation) {
            op = (BoxBinaryOperation)condition;
            if (((BoxBinaryOperation)op).getOperator() == BoxBinaryOperator.Or) {
                return false;
            }
            if (((BoxBinaryOperation)op).getOperator() == BoxBinaryOperator.And) {
                return false;
            }
            if (((BoxBinaryOperation)op).getOperator() == BoxBinaryOperator.Contains) {
                return false;
            }
            if (((BoxBinaryOperation)op).getOperator() == BoxBinaryOperator.InstanceOf) {
                return false;
            }
            if (((BoxBinaryOperation)op).getOperator() == BoxBinaryOperator.NotContains) {
                return false;
            }
            if (((BoxBinaryOperation)op).getOperator() == BoxBinaryOperator.Xor) {
                return false;
            }
        }
        if (condition instanceof BoxUnaryOperation && ((BoxUnaryOperation)(op = (BoxUnaryOperation)condition)).getOperator() == BoxUnaryOperator.Not) {
            return false;
        }
        return !(condition instanceof BoxComparisonOperation);
    }

    protected Node addIndex(Node javaNode, BoxNode boxNode) {
        javaNode.setData(BoxNodeKey.BOX_NODE_DATA_KEY, boxNode);
        return javaNode;
    }

    public Expression transformDocumentation(List<BoxDocumentationAnnotation> documentation) {
        ArrayList members = new ArrayList();
        documentation.forEach(doc -> {
            Expression annotationKey = this.createKey(doc.getKey().getValue());
            members.add(annotationKey);
            Expression value = (Expression)this.transpiler.transform(doc.getValue());
            members.add(value);
        });
        if (members.isEmpty()) {
            return this.parseExpression("Struct.EMPTY", new HashMap<String, String>());
        }
        MethodCallExpr documentationStruct = (MethodCallExpr)this.parseExpression("Struct.linkedOf()", new HashMap<String, String>());
        documentationStruct.getArguments().addAll(members);
        return documentationStruct;
    }

    public Expression transformAnnotations(List<BoxAnnotation> annotations, Boolean defaultTrue, boolean onlyLiteralValues) {
        ArrayList members = new ArrayList();
        annotations.forEach(annotation -> {
            Expression annotationKey = this.createKey(annotation.getKey().getValue());
            members.add(annotationKey);
            BoxExpression thisValue = annotation.getValue();
            Expression value = thisValue != null ? (thisValue.isLiteral() ? (Expression)this.transpiler.transform(thisValue) : (onlyLiteralValues ? new StringLiteralExpr("<Runtime Expression>") : (Expression)this.transpiler.transform(thisValue))) : (defaultTrue != false ? new BooleanLiteralExpr(true) : new StringLiteralExpr(""));
            members.add(value);
        });
        if (annotations.isEmpty()) {
            return this.parseExpression("new Struct()", new HashMap<String, String>());
        }
        MethodCallExpr annotationStruct = (MethodCallExpr)this.parseExpression("Struct.linkedOf()", new HashMap<String, String>());
        annotationStruct.getArguments().addAll(members);
        return annotationStruct;
    }

    public Expression transformAnnotations(List<BoxAnnotation> annotations) {
        return this.transformAnnotations(annotations, false, true);
    }

    protected String generateArguments(List<BoxArgument> arguments) {
        StringBuilder sb = new StringBuilder("");
        if (arguments.size() == 0) {
            sb.append("new Object[]{}");
        } else if (arguments.get(0).getName() == null) {
            sb.append("new Object[] { ");
            for (int i = 0; i < arguments.size(); ++i) {
                sb.append("${").append("arg").append(i).append("}");
                if (i >= arguments.size() - 1) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            sb.append("new LinkedHashMap<>(){{");
            for (int i = 0; i < arguments.size(); ++i) {
                sb.append("put( ").append(this.createKey(arguments.get(i).getName()).toString()).append(", ${").append("arg").append(i).append("} );");
            }
            sb.append("}}");
        }
        return sb.toString();
    }

    public ExitsAllowed getExitsAllowed(BoxNode node) {
        BoxNode ancestor = (BoxNode)node.getFirstNodeOfTypes(BoxFunctionDeclaration.class, BoxClosure.class, BoxLambda.class, BoxComponent.class, BoxDo.class, BoxForIndex.class, BoxForIn.class, BoxSwitch.class, BoxWhile.class);
        if (ancestor instanceof BoxFunctionDeclaration || ancestor instanceof BoxClosure || ancestor instanceof BoxLambda) {
            return ExitsAllowed.FUNCTION;
        }
        if (ancestor instanceof BoxComponent) {
            return ExitsAllowed.COMPONENT;
        }
        if (ancestor != null) {
            return ExitsAllowed.LOOP;
        }
        return ExitsAllowed.DEFAULT;
    }

    public static enum ExitsAllowed {
        COMPONENT,
        LOOP,
        FUNCTION,
        DEFAULT;

    }
}

