/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxClass;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.Source;
import ortus.boxlang.compiler.ast.SourceFile;
import ortus.boxlang.compiler.ast.expression.BoxBooleanLiteral;
import ortus.boxlang.compiler.ast.expression.BoxFQN;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxNull;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.ast.statement.BoxAnnotation;
import ortus.boxlang.compiler.ast.statement.BoxArgumentDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxFunctionDeclaration;
import ortus.boxlang.compiler.ast.statement.BoxImport;
import ortus.boxlang.compiler.ast.statement.BoxProperty;
import ortus.boxlang.compiler.ast.statement.BoxReturnType;
import ortus.boxlang.compiler.ast.statement.BoxType;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.ProxyTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.context.ScriptingRequestBoxContext;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyDefinition;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.types.util.BLCollector;
import ortus.boxlang.runtime.types.util.ListUtil;

public class BoxClassTransformer
extends AbstractTransformer {
    private static final String CLASS_TEMPLATE = "\tpackage ${packageName};\n\n\t// BoxLang Auto Imports\n\timport ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;\n\timport ortus.boxlang.compiler.parser.BoxSourceType;\n\timport ortus.boxlang.runtime.BoxRuntime;\n\timport ortus.boxlang.runtime.components.Component;\n\timport ortus.boxlang.runtime.context.*;\n\timport ortus.boxlang.runtime.context.ClassBoxContext;\n\timport ortus.boxlang.runtime.context.FunctionBoxContext;\n\timport ortus.boxlang.runtime.dynamic.casters.*;\n\timport ortus.boxlang.runtime.dynamic.ExpressionInterpreter;\n\timport ortus.boxlang.runtime.dynamic.IReferenceable;\n\timport ortus.boxlang.runtime.dynamic.Referencer;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.loader.ClassLocator;\n\timport ortus.boxlang.runtime.loader.ImportDefinition;\n\timport ortus.boxlang.runtime.operators.*;\n\timport ortus.boxlang.runtime.runnables.BoxClassSupport;\n\timport ortus.boxlang.runtime.runnables.BoxInterface;\n\timport ortus.boxlang.runtime.runnables.BoxScript;\n\timport ortus.boxlang.runtime.runnables.BoxTemplate;\n\timport ortus.boxlang.runtime.runnables.IClassRunnable;\n\timport ortus.boxlang.runtime.scopes.*;\n\timport ortus.boxlang.runtime.types.*;\n\timport ortus.boxlang.runtime.types.exceptions.*;\n\timport ortus.boxlang.runtime.types.meta.BoxMeta;\n\timport ortus.boxlang.runtime.types.meta.ClassMeta;\n\timport ortus.boxlang.runtime.types.Property;\n\timport ortus.boxlang.runtime.types.util.*;\n\timport ortus.boxlang.runtime.util.*;\n\timport ortus.boxlang.runtime.util.conversion.ObjectMarshaller;\n\n\t// Java Imports\n\timport java.io.*;\n\timport java.lang.invoke.MethodHandle;\n\timport java.lang.invoke.MethodHandles;\n\timport java.lang.invoke.MethodType;\n\timport java.lang.reflect.Field;\n\timport java.lang.reflect.Method;\n\timport java.nio.file.Path;\n\timport java.nio.file.Paths;\n\timport java.time.LocalDateTime;\n\timport java.util.ArrayList;\n\timport java.util.Collections;\n\timport java.util.HashMap;\n\timport java.util.Iterator;\n\timport java.util.LinkedHashMap;\n\timport java.util.LinkedHashMap;\n\timport java.util.List;\n\timport java.util.Map;\n\timport java.util.Set;\n\timport java.util.Optional;\n\n\n\tpublic class ${className} ${extendsTemplate} implements ${interfaceList} {\n\n\t\t// Public static fields\n\t\tpublic static final Key[] keys = new Key[] {};\n\n\t\t// Private Static fields\n\t\tprivate static final long serialVersionUID = ${compileVersion};\n\t\tprivate static final List<ImportDefinition>\timports\t= List.of();\n\t\tprivate static final ResolvedFilePath path = ${resolvedFilePath};\n\t\tprivate static final BoxSourceType sourceType = BoxSourceType.${sourceType};\n\t\tprivate static final long compileVersion = ${compileVersion};\n\t\tprivate static final LocalDateTime compiledOn = ${compiledOnTimestamp};\n\t\tprivate static final Object\tast\t= null;\n\t\tprivate static final IStruct annotations;\n\t\tprivate static final IStruct documentation;\n\t\tprivate static final Map<Key,Property>\tproperties;\n\t\tprivate static final Map<Key,Property>\tgetterLookup=null;\n\t\tprivate static final Map<Key,Property>\tsetterLookup=null;\n\t\tprivate static Map<Key, AbstractFunction>\tabstractMethods\t= new LinkedHashMap<>();\n\t\tprivate static Set<Key> compileTimeMethodNames = ${compileTimeMethodNames};\n\t\tprivate static final boolean isJavaExtends=${isJavaExtends};\n\t\tprivate static StaticScope staticScope = new StaticScope();\n\t\t// This is public so the ClassLocator can check it easily\n\t\tpublic static boolean staticInitialized = false;\n\n\t\t// Private instance fields\n\t\tprivate VariablesScope variablesScope = new ClassVariablesScope(this);\n\t\tprivate ThisScope thisScope = new ThisScope();\n\t\tprivate Key name = ${boxFQN};\n\t\tprivate IClassRunnable _super = null;\n\t\tprivate IClassRunnable child = null;\n\t\tprivate Boolean canOutput = null;\n\t\tprivate Boolean canInvokeImplicitAccessor = null;\n\t\tprivate List<BoxInterface> interfaces = new ArrayList<>();\n\n\t\t// Public instance fields\n\t\tpublic BoxMeta\t\t$bx;\n\n\t\tpublic ${className}() {\n\t\t}\n\n\t\tpublic static void staticInitializer( IBoxContext context ) {\n\t\t\tClassLocator classLocator = ClassLocator.getInstance();\n\t\t}\n\n\t\tpublic Map<Key,Property> getGetterLookup() {\n\t\t\treturn getterLookup;\n\t\t}\n\t\tpublic Map<Key,Property> getSetterLookup() {\n\t\t\treturn setterLookup;\n\t\t}\n\n\t\tpublic Map<Key, AbstractFunction> getAbstractMethods() {\n\t\t\treturn this.abstractMethods;\n\t\t}\n\n\t\tpublic Map<Key, AbstractFunction> getAllAbstractMethods() {\n\t\t\t// get from parent and override\n\t\t\tMap<Key, AbstractFunction> allAbstractMethods = new LinkedHashMap<>();\n\t\t\tif ( this._super != null ) {\n\t\t\t\tallAbstractMethods.putAll( this._super.getAllAbstractMethods() );\n\t\t\t}\n\t\t\tallAbstractMethods.putAll( this.abstractMethods );\n\t\t\treturn allAbstractMethods;\n\t\t}\n\n\t\tpublic Set<Key> getCompileTimeMethodNames() {\n\t\t\treturn compileTimeMethodNames;\n\t\t}\n\n\t\tpublic BoxMeta _getbx() {\n\t\t\treturn this.$bx;\n\t\t}\n\n\t\tpublic void _setbx( BoxMeta bx ) {\n\t\t\tthis.$bx = bx;\n\t\t}\n\n\t\tpublic void pseudoConstructor( IBoxContext context ) {\n\t\t\tBoxClassSupport.pseudoConstructor( this, context );\n\t\t}\n\n\t\tpublic void _pseudoConstructor( IBoxContext context ) {\n\t\t\tClassLocator classLocator = ClassLocator.getInstance();\n\t\t}\n\n\t\t// ITemplateRunnable implementation methods\n\n\t\tpublic long getRunnableCompileVersion() {\n\t\t\treturn ${className}.compileVersion;\n\t\t}\n\n\t\tpublic LocalDateTime getRunnableCompiledOn() {\n\t\t\treturn ${className}.compiledOn;\n\t\t}\n\n\t\tpublic Object getRunnableAST() {\n\t\t\treturn ${className}.ast;\n\t\t}\n\n\t\tpublic ResolvedFilePath getRunnablePath() {\n\t\t\treturn ${className}.path;\n\t\t}\n\n\t\tpublic BoxSourceType getSourceType() {\n\t\t\treturn sourceType;\n\t\t}\n\n\t\tpublic List<ImportDefinition> getImports() {\n\t\t\treturn imports;\n\t\t}\n\n\t\tpublic VariablesScope getVariablesScope() {\n\t\t\treturn variablesScope;\n\t\t}\n\n\t\tpublic ThisScope getThisScope() {\n\t\t\treturn thisScope;\n\t\t}\n\n\t\t// Instance method required to get from IClassRunnable\n\t\tpublic static StaticScope getStaticScopeStatic() {\n\t\t\treturn staticScope;\n\t\t}\n\n\t\t// Static method required to get statically\n\t\tpublic StaticScope getStaticScope() {\n\t\t\treturn ${className}.staticScope;\n\t\t}\n\n\t\tpublic IStruct getAnnotations() {\n\t\t\treturn annotations;\n\t\t}\n\n\t\tpublic static IStruct getAnnotationsStatic() {\n\t\t\treturn ${className}.annotations;\n\t\t}\n\n\t\tpublic IStruct getDocumentation() {\n\t\t\treturn documentation;\n\t\t}\n\n\t\tpublic Key getName() {\n\t\t\treturn this.name;\n\t\t}\n\n\t\tpublic Map<Key,Property> getProperties() {\n\t\t\treturn this.properties;\n\t\t}\n\n\t\tpublic BoxMeta getBoxMeta() {\n\t\t\treturn BoxClassSupport.getBoxMeta( this );\n\t\t}\n\n\t\tpublic String asString() {\n\t\t\treturn BoxClassSupport.asString( this );\n\t\t}\n\n\t\tpublic Boolean canOutput() {\n\t\t\treturn BoxClassSupport.canOutput( this );\n\t\t}\n\n\t\tpublic Boolean getCanOutput() {\n\t\t\treturn this.canOutput;\n\t\t}\n\n\t\tpublic void setCanOutput( Boolean canOutput ) {\n\t\t\tthis.canOutput = canOutput;\n\t\t}\n\n\t\tpublic Boolean canInvokeImplicitAccessor( IBoxContext context ) {\n\t\t\treturn BoxClassSupport.canInvokeImplicitAccessor( this, context );\n\t\t}\n\n\t\tpublic Boolean getCanInvokeImplicitAccessor() {\n\t\t\treturn this.canInvokeImplicitAccessor;\n\t\t}\n\n\t\tpublic void setCanInvokeImplicitAccessor( Boolean canInvokeImplicitAccessor ) {\n\t\t\tthis.canInvokeImplicitAccessor = canInvokeImplicitAccessor;\n\t\t}\n\n\t\tpublic IClassRunnable getSuper() {\n\t\t\treturn this._super;\n\t\t}\n\n\t\tpublic void setSuper( IClassRunnable _super ) {\n\t\t\tBoxClassSupport.setSuper( this, _super );\n\t\t}\n\n\t\tpublic void _setSuper( IClassRunnable _super ) {\n\t\t\tthis._super = _super;\n\t\t}\n\n\t\tpublic IClassRunnable getChild() {\n\t\t\treturn this.child;\n\t\t}\n\n\t\tpublic void setChild( IClassRunnable child ) {\n\t\t\tthis.child = child;\n\t\t}\n\n\t\tpublic IClassRunnable getBottomClass() {\n\t\t\treturn BoxClassSupport.getBottomClass( this );\n\t\t}\n\n\t\t/**\n\t\t * --------------------------------------------------------------------------\n\t\t * Serialize Methods\n\t\t * --------------------------------------------------------------------------\n\t\t * We only use the serialize, since we wrap the state into a\n\t\t * BoxClassState class.\n\t\t */\n\n\t\tprivate Object writeReplace() throws ObjectStreamException {\n\t\t\treturn ObjectMarshaller.serializeClass( this );\n\t\t}\n\n\t\t/**\n\t\t * --------------------------------------------------------------------------\n\t\t * IReferenceable Interface Methods\n\t\t * --------------------------------------------------------------------------\n\t\t */\n\n\t\tpublic Object assign( IBoxContext context, Key key, Object value ) {\n\t\t\treturn BoxClassSupport.assign( this, context, key, value );\n\t\t}\n\n\t\tpublic Object dereference( IBoxContext context, Key key, Boolean safe ) {\n\t\t\treturn BoxClassSupport.dereference( this, context, key, safe );\n\t\t}\n\n\t\tpublic Object dereferenceAndInvoke( IBoxContext context, Key name, Object[] positionalArguments, Boolean safe ) {\n\t\t\treturn BoxClassSupport.dereferenceAndInvoke( this, context, name, positionalArguments, safe );\n\t\t}\n\n\t\tpublic Object dereferenceAndInvoke( IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe ) {\n\t\t\t\treturn BoxClassSupport.dereferenceAndInvoke( this, context, name, namedArguments, safe );\n\t\t}\n\n\t\tpublic IStruct getMetaData() {\n\t\t\treturn BoxClassSupport.getMetaData( this );\n\t\t}\n\n\t\tpublic void registerInterface( BoxInterface _interface ) {\n\t\t\tBoxClassSupport.registerInterface( this, _interface );\n\t\t}\n\n\t\tpublic List<BoxInterface> getInterfaces() {\n\t\t\treturn this.interfaces;\n\t\t}\n\n\t\tpublic boolean isJavaExtends() {\n\t\t\treturn isJavaExtends;\n\t\t}\n\n\t\t/**\n\t\t * This code MUST be inside the class to allow for the lookupPrivate method to work\n\t\t * This proxy is called from the dynamic interop service when calling a super method\n\t\t * while using java extends, and it will return the method handle for the corresponding\n\t\t * method in the super class.\n\t\t */\n\t\tpublic MethodHandle lookupPrivateMethod( Method method ) {\n\t\t\ttry {\n\t\t\t\treturn MethodHandles.lookup().findSpecial(\n\t\t\t\t\tmethod.getDeclaringClass(),\n\t\t\t\t\tmethod.getName(),\n\t\t\t\t\tMethodType.methodType(method.getReturnType(), method.getParameterTypes()),\n\t\t\t\t\tthis.getClass()\n\t\t\t\t);\n\t\t\t} catch (NoSuchMethodException | IllegalAccessException e) {\n\t\t\t\tthrow new BoxRuntimeException( \"Error getting Java super class method \" + method.getName(), e );\n\t\t\t}\n\t\t}\n\n\t\t/**\n\t\t * Same as above\n\t\t */\n\t\tpublic MethodHandle lookupPrivateField( Field field ) {\n\t\t\ttry {\n\t\t\t\treturn MethodHandles.lookup().unreflectGetter( field );\n\t\t\t} catch ( IllegalAccessException e) {\n\t\t\t\tthrow new BoxRuntimeException( \"Error getting Java super class field \" + field.getName(), e );\n\t\t\t}\n\t\t}\n\n\t\t${interfaceMethods}\n\n\t\t${extendsMethods}\n\n\t}\n";
    private static final String EXTENDS_ANNOTATION_MARKER = "overrideJava";

    public BoxClassTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        ParseResult<CompilationUnit> result;
        SourceFile file;
        SourceFile file2;
        BoxStringLiteral str;
        String extendsStringValue;
        BoxExpression extendsValue;
        BoxClass boxClass = (BoxClass)node;
        Source source = boxClass.getPosition().getSource();
        String packageName = this.transpiler.getProperty("packageName");
        String boxFQN = this.transpiler.getProperty("boxFQN");
        String className = this.transpiler.getProperty("classname");
        String mappingName = this.transpiler.getProperty("mappingName");
        String mappingPath = this.transpiler.getProperty("mappingPath");
        String relativePath = this.transpiler.getProperty("relativePath");
        String interfaceMethods = "";
        Object extendsTemplate = "";
        String extendsMethods = "";
        String isJavaExtends = "false";
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.add("IClassRunnable");
        interfaces.add("IReferenceable");
        interfaces.add("IType");
        interfaces.add("Serializable");
        BoxExpression implementsValue = boxClass.getAnnotations().stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("implements")).findFirst().map(it -> it.getValue()).orElse(null);
        if (implementsValue instanceof BoxStringLiteral) {
            BoxStringLiteral str2 = (BoxStringLiteral)implementsValue;
            String implementsStringList = str2.getValue();
            Array implementsArray = ListUtil.asList(implementsStringList, ",").stream().map(String::valueOf).map(String::trim).filter(it -> it.toLowerCase().startsWith("java:")).map(it -> it.substring(5)).collect(BLCollector.toArray());
            InterfaceProxyDefinition interfaceProxyDefinition = InterfaceProxyService.generateDefinition(new ScriptingRequestBoxContext(), implementsArray);
            interfaces.addAll(interfaceProxyDefinition.interfaces());
            interfaceMethods = ProxyTransformer.generateInterfaceMethods(interfaceProxyDefinition.methods(), "this");
        }
        if ((extendsValue = (BoxExpression)boxClass.getAnnotations().stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("extends")).findFirst().map(it -> it.getValue()).orElse(null)) instanceof BoxStringLiteral && (extendsStringValue = (str = (BoxStringLiteral)extendsValue).getValue().trim()).toLowerCase().startsWith("java:")) {
            extendsStringValue = extendsStringValue.substring(5);
            extendsTemplate = "extends " + extendsStringValue;
            isJavaExtends = "true";
            extendsMethods = boxClass.getDescendantsOfType(BoxFunctionDeclaration.class).stream().filter(it -> it.getAnnotations().stream().anyMatch(anno -> anno.getKey().getValue().equalsIgnoreCase(EXTENDS_ANNOTATION_MARKER))).map(this::createJavaMethodStub).collect(Collectors.joining("\n"));
        }
        String fileName = source instanceof SourceFile && (file2 = (SourceFile)source).getFile() != null ? file2.getFile().getName() : "unknown";
        String filePath = source instanceof SourceFile && (file = (SourceFile)source).getFile() != null ? file.getFile().getAbsolutePath() : "unknown";
        String sourceType = this.transpiler.getProperty("sourceType");
        Map<String, String> values = Map.ofEntries(Map.entry("packagename", packageName), Map.entry("className", className), Map.entry("fileName", fileName), Map.entry("interfaceMethods", interfaceMethods), Map.entry("interfaceList", interfaces.stream().collect(Collectors.joining(", "))), Map.entry("extendsTemplate", extendsTemplate), Map.entry("extendsMethods", extendsMethods), Map.entry("isJavaExtends", isJavaExtends), Map.entry("sourceType", sourceType), Map.entry("resolvedFilePath", this.transpiler.getResolvedFilePath(mappingName, mappingPath, relativePath, filePath)), Map.entry("compiledOnTimestamp", this.transpiler.getDateTime(LocalDateTime.now())), Map.entry("compileVersion", "1L"), Map.entry("boxFQN", this.createKey(boxFQN).toString()), Map.entry("compileTimeMethodNames", this.generateCompileTimeMethodNames(boxClass)));
        String code = PlaceholderHelper.resolve(CLASS_TEMPLATE, values);
        try {
            result = this.javaParser.parse(code);
        }
        catch (Exception e) {
            throw new BoxRuntimeException(code, e);
        }
        if (!result.isSuccessful()) {
            throw new BoxRuntimeException("Error parsing class" + packageName + "." + className + ". The message received was:" + result.toString() + "\n" + code);
        }
        CompilationUnit entryPoint = result.getResult().get();
        MethodDeclaration pseudoConstructorMethod = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getMethodsByName("_pseudoConstructor").get(0);
        MethodDeclaration staticInitializerMethod = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getMethodsByName("staticInitializer").get(0);
        FieldDeclaration imports = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getFieldByName("imports").orElseThrow();
        FieldDeclaration keys = entryPoint.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getFieldByName("keys").orElseThrow();
        Expression annotationStruct = this.transformAnnotations(boxClass.getAnnotations());
        result.getResult().orElseThrow().getType(0).getFieldByName("annotations").orElseThrow().getVariable(0).setInitializer(annotationStruct);
        Expression documentationStruct = this.transformDocumentation(boxClass.getDocumentation());
        result.getResult().orElseThrow().getType(0).getFieldByName("documentation").orElseThrow().getVariable(0).setInitializer(documentationStruct);
        List<Expression> propertyStructs = this.transformProperties(boxClass.getProperties(), sourceType);
        result.getResult().orElseThrow().getType(0).getFieldByName("properties").orElseThrow().getVariable(0).setInitializer(propertyStructs.get(0));
        result.getResult().orElseThrow().getType(0).getFieldByName("getterLookup").orElseThrow().getVariable(0).setInitializer(propertyStructs.get(1));
        result.getResult().orElseThrow().getType(0).getFieldByName("setterLookup").orElseThrow().getVariable(0).setInitializer(propertyStructs.get(2));
        this.transpiler.pushContextName("context");
        BlockStmt pseudoConstructorBody = pseudoConstructorMethod.getBody().orElseThrow();
        for (BoxImport boxImport : boxClass.getImports()) {
            this.transpiler.transform(boxImport);
        }
        for (BoxStatement boxStatement : boxClass.getBody()) {
            BoxFunctionDeclaration bfd;
            if (boxStatement instanceof BoxFunctionDeclaration && (bfd = (BoxFunctionDeclaration)boxStatement).getBody() == null) {
                pseudoConstructorBody.addStatement(0, ((JavaTranspiler)this.transpiler).createAbstractMethod(bfd, this, className, "class"));
                continue;
            }
            Node javaASTNode = this.transpiler.transform(boxStatement);
            if (javaASTNode instanceof EmptyStmt) continue;
            if (javaASTNode instanceof BlockStmt) {
                BlockStmt stmt = (BlockStmt)javaASTNode;
                stmt.getStatements().forEach(it -> pseudoConstructorBody.addStatement((Statement)it));
                continue;
            }
            pseudoConstructorBody.addStatement((Statement)javaASTNode);
        }
        pseudoConstructorBody.addStatement(0, new MethodCallExpr((Expression)new NameExpr("BoxClassSupport"), "defaultProperties", (NodeList<Expression>)NodeList.nodeList((Node[])new Expression[]{new NameExpr("this"), new NameExpr("context")})));
        ((JavaTranspiler)this.transpiler).getUDFDeclarations().forEach(it -> pseudoConstructorBody.addStatement(0, (Statement)it));
        ((JavaTranspiler)this.transpiler).getStaticUDFDeclarations().forEach(it -> staticInitializerMethod.getBody().get().addStatement((Statement)it));
        MethodCallExpr imp = (MethodCallExpr)imports.getVariable(0).getInitializer().orElseThrow();
        imp.getArguments().addAll((Collection<Expression>)this.transpiler.getJImports());
        this.transpiler.getStaticInitializers().forEach(it -> staticInitializerMethod.getBody().get().addStatement((Statement)it));
        ArrayCreationExpr arrayCreationExpr = (ArrayCreationExpr)keys.getVariable(0).getInitializer().orElseThrow();
        for (Map.Entry<String, BoxExpression> entry : this.transpiler.getKeys().entrySet()) {
            MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new NameExpr("Key"), "of");
            BoxExpression boxExpression = entry.getValue();
            if (boxExpression instanceof BoxStringLiteral) {
                BoxStringLiteral str3 = (BoxStringLiteral)boxExpression;
                methodCallExpr.addArgument(new StringLiteralExpr(str3.getValue()));
            } else {
                boxExpression = entry.getValue();
                if (boxExpression instanceof BoxIntegerLiteral) {
                    BoxIntegerLiteral id = (BoxIntegerLiteral)boxExpression;
                    methodCallExpr.addArgument(new IntegerLiteralExpr(id.getValue()));
                } else {
                    throw new ExpressionException("Unsupported key type: " + entry.getValue().getClass().getSimpleName(), entry.getValue());
                }
            }
            arrayCreationExpr.getInitializer().get().getValues().add(methodCallExpr);
        }
        this.transpiler.popContextName();
        return entryPoint;
    }

    private String generateCompileTimeMethodNames(BoxClass boxClass) {
        List methodNames = boxClass.getDescendantsOfType(BoxFunctionDeclaration.class).stream().map(BoxFunctionDeclaration::getName).map(this::createKey).map(String::valueOf).collect(Collectors.toList());
        return "Set.of(" + methodNames.stream().collect(Collectors.joining(", ")) + ")";
    }

    private List<Expression> transformProperties(List<BoxProperty> properties, String sourceType) {
        ArrayList members = new ArrayList();
        ArrayList getterLookup = new ArrayList();
        ArrayList setterLookup = new ArrayList();
        properties.forEach(prop -> {
            boolean setter;
            boolean getter;
            String type;
            BoxExpression patt1$temp;
            String name;
            BoxExpression patt0$temp;
            List<BoxAnnotation> finalAnnotations = BoxClassTransformer.normlizePropertyAnnotations(prop);
            BoxAnnotation nameAnnotation = finalAnnotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("name")).findFirst().orElseThrow(() -> new ExpressionException("Property [" + prop.getSourceText() + "] missing name annotation", (BoxNode)prop));
            BoxAnnotation typeAnnotation = finalAnnotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("type")).findFirst().orElseThrow(() -> new ExpressionException("Property [" + prop.getSourceText() + "] missing type annotation", (BoxNode)prop));
            BoxAnnotation defaultAnnotation = finalAnnotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("default")).findFirst().orElse(null);
            Expression documentationStruct = this.transformDocumentation(prop.getDocumentation());
            Expression annotationStruct = this.transformAnnotations(finalAnnotations);
            String defaultValue = "null";
            String defaultExpression = "null";
            if (defaultAnnotation != null && defaultAnnotation.getValue() != null) {
                if (defaultAnnotation.getValue().isLiteral()) {
                    Node defaultValueExpr = this.transpiler.transform(defaultAnnotation.getValue());
                    defaultValue = defaultValueExpr.toString();
                } else {
                    String lambdaContextName = "lambdaContext" + this.transpiler.incrementAndGetLambdaContextCounter();
                    this.transpiler.pushContextName(lambdaContextName);
                    Node initExpr = this.transpiler.transform(defaultAnnotation.getValue());
                    this.transpiler.popContextName();
                    LambdaExpr lambda = new LambdaExpr();
                    lambda.setParameters(new NodeList((Node[])new Parameter[]{new Parameter((Type)new UnknownType(), lambdaContextName)}));
                    BlockStmt body = new BlockStmt();
                    body.addStatement(this.parseStatement("ClassLocator classLocator = ClassLocator.getInstance();", Map.of()));
                    body.addStatement(new ReturnStmt((Expression)initExpr));
                    lambda.setBody(body);
                    defaultExpression = lambda.toString();
                }
            }
            if (nameAnnotation != null && (patt0$temp = nameAnnotation.getValue()) instanceof BoxStringLiteral) {
                BoxStringLiteral namelit = (BoxStringLiteral)patt0$temp;
                name = namelit.getValue().trim();
                if (name.isEmpty()) {
                    throw new ExpressionException("Property [" + prop.getSourceText() + "] name cannot be empty", nameAnnotation);
                }
            } else {
                throw new ExpressionException("Property [" + prop.getSourceText() + "] name must be a simple value", nameAnnotation);
            }
            if (typeAnnotation != null && (patt1$temp = typeAnnotation.getValue()) instanceof BoxStringLiteral) {
                BoxStringLiteral typelit = (BoxStringLiteral)patt1$temp;
                type = typelit.getValue().trim();
                if (type.isEmpty()) {
                    throw new ExpressionException("Property [" + prop.getSourceText() + "] type cannot be empty", typeAnnotation);
                }
            } else {
                throw new ExpressionException("Property [" + prop.getSourceText() + "] type must be a simple value", typeAnnotation);
            }
            Expression jNameKey = this.createKey(name);
            Expression jGetNameKey = this.createKey("get" + name);
            Expression jSetNameKey = this.createKey("set" + name);
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("type", type);
            values.put("name", jNameKey.toString());
            values.put("defaultValue", defaultValue);
            values.put("defaultExpression", defaultExpression);
            values.put("annotations", annotationStruct.toString());
            values.put("documentation", documentationStruct.toString());
            values.put("sourceType", sourceType);
            String template = "\t\t\t\tnew Property( ${name}, \"${type}\", ${defaultValue}, ${defaultExpression}, ${annotations} ,${documentation}, BoxSourceType.${sourceType} )\n";
            Expression javaExpr = this.parseExpression(template, values);
            members.add(jNameKey);
            members.add(javaExpr);
            boolean bl = getter = !finalAnnotations.stream().anyMatch(it -> it.getKey().getValue().equalsIgnoreCase("getter") && BooleanCaster.cast(this.getBoxExprAsString(it.getValue())) == false);
            if (getter) {
                getterLookup.add(jGetNameKey);
                getterLookup.add(this.parseExpression("properties.get( ${name} )", values));
            }
            boolean bl2 = setter = !finalAnnotations.stream().anyMatch(it -> it.getKey().getValue().equalsIgnoreCase("setter") && BooleanCaster.cast(this.getBoxExprAsString(it.getValue())) == false);
            if (setter) {
                setterLookup.add(jSetNameKey);
                setterLookup.add(this.parseExpression("properties.get( ${name} )", values));
            }
        });
        if (members.isEmpty()) {
            Expression emptyMap = this.parseExpression("MapHelper.LinkedHashMapOfProperties()", new HashMap<String, String>());
            Expression emptyMap2 = this.parseExpression("MapHelper.HashMapOfProperties()", new HashMap<String, String>());
            return List.of(emptyMap, emptyMap2, emptyMap2);
        }
        MethodCallExpr propertiesStruct = (MethodCallExpr)this.parseExpression("MapHelper.LinkedHashMapOfProperties()", new HashMap<String, String>());
        MethodCallExpr getterStruct = (MethodCallExpr)this.parseExpression("MapHelper.HashMapOfProperties()", new HashMap<String, String>());
        MethodCallExpr setterStruct = (MethodCallExpr)this.parseExpression("MapHelper.HashMapOfProperties()", new HashMap<String, String>());
        propertiesStruct.getArguments().addAll(members);
        getterStruct.getArguments().addAll(getterLookup);
        setterStruct.getArguments().addAll(setterLookup);
        return List.of(propertiesStruct, getterStruct, setterStruct);
    }

    public static List<BoxAnnotation> normlizePropertyAnnotations(BoxProperty prop) {
        ArrayList<BoxAnnotation> finalAnnotations = new ArrayList<BoxAnnotation>();
        List<BoxAnnotation> annotations = prop.getPostAnnotations();
        annotations.addAll(prop.getAnnotations().stream().filter(it -> it.getValue() != null).toList());
        int namePosition = annotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("name") && it.getValue() != null).findFirst().map(annotations::indexOf).orElse(-1);
        int typePosition = annotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("type") && it.getValue() != null).findFirst().map(annotations::indexOf).orElse(-1);
        int defaultPosition = annotations.stream().filter(it -> it.getKey().getValue().equalsIgnoreCase("default") && it.getValue() != null).findFirst().map(annotations::indexOf).orElse(-1);
        int numberOfNonValuedKeys = (int)annotations.stream().map(BoxAnnotation::getValue).filter(Objects::isNull).count();
        List nonValuedKeys = annotations.stream().filter(it -> it.getValue() == null).collect(Collectors.toList());
        BoxAnnotation nameAnnotation = null;
        BoxAnnotation typeAnnotation = null;
        BoxAnnotation defaultAnnotation = null;
        if (namePosition > -1) {
            nameAnnotation = annotations.get(namePosition);
        }
        if (typePosition > -1) {
            typeAnnotation = annotations.get(typePosition);
        }
        if (defaultPosition > -1) {
            defaultAnnotation = annotations.get(defaultPosition);
        }
        if (namePosition == -1) {
            if (numberOfNonValuedKeys > 1 && typePosition == -1) {
                typeAnnotation = new BoxAnnotation(new BoxFQN("type", null, null), new BoxStringLiteral(((BoxAnnotation)nonValuedKeys.get(0)).getKey().getValue(), null, null), null, null);
                nameAnnotation = new BoxAnnotation(new BoxFQN("name", null, null), new BoxStringLiteral(((BoxAnnotation)nonValuedKeys.get(1)).getKey().getValue(), null, null), null, null);
                finalAnnotations.add(nameAnnotation);
                finalAnnotations.add(typeAnnotation);
                annotations.remove(nonValuedKeys.get(0));
                annotations.remove(nonValuedKeys.get(1));
            } else if (numberOfNonValuedKeys > 0) {
                nameAnnotation = new BoxAnnotation(new BoxFQN("name", null, null), new BoxStringLiteral(((BoxAnnotation)nonValuedKeys.get(0)).getKey().getValue(), null, null), null, null);
                finalAnnotations.add(nameAnnotation);
                annotations.remove(nonValuedKeys.get(0));
            } else {
                throw new ExpressionException("Property [" + prop.getSourceText() + "] has no name", prop);
            }
        }
        if (typeAnnotation == null) {
            typeAnnotation = new BoxAnnotation(new BoxFQN("type", null, null), new BoxStringLiteral("any", null, null), null, null);
            finalAnnotations.add(typeAnnotation);
        }
        if (defaultPosition == -1) {
            defaultAnnotation = new BoxAnnotation(new BoxFQN("default", null, null), new BoxNull(null, null), null, null);
            finalAnnotations.add(defaultAnnotation);
        }
        finalAnnotations.addAll(annotations);
        finalAnnotations.addAll(prop.getAnnotations().stream().filter(it -> it.getValue() == null).toList());
        return finalAnnotations;
    }

    private String getBoxExprAsString(BoxExpression expr) {
        if (expr == null) {
            return "";
        }
        if (expr instanceof BoxStringLiteral) {
            BoxStringLiteral str = (BoxStringLiteral)expr;
            return str.getValue();
        }
        if (expr instanceof BoxBooleanLiteral) {
            BoxBooleanLiteral bool = (BoxBooleanLiteral)expr;
            return bool.getValue() != false ? "true" : "false";
        }
        throw new ExpressionException("Unsupported BoxExpr type: " + expr.getClass().getSimpleName(), expr);
    }

    private String createJavaMethodStub(BoxFunctionDeclaration func) {
        BoxArgumentDeclaration parameter;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        BoxReturnType boxReturnType = func.getType();
        BoxType returnType = BoxType.Any;
        String fqn = null;
        if (boxReturnType != null && (returnType = boxReturnType.getType()).equals((Object)BoxType.Fqn)) {
            fqn = boxReturnType.getFqn();
        }
        String returnValue = returnType.equals((Object)BoxType.Fqn) ? fqn : returnType.getSymbol();
        sb.append(returnValue);
        sb.append(" ");
        sb.append(func.getName());
        sb.append("(");
        List<BoxArgumentDeclaration> parameters = func.getArgs();
        for (i = 0; i < parameters.size(); ++i) {
            parameter = parameters.get(i);
            sb.append(parameter.getType());
            sb.append(" ");
            sb.append(parameter.getName());
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(") {\n");
        sb.append("    Object[] ___args = new Object[] {");
        for (i = 0; i < parameters.size(); ++i) {
            parameter = parameters.get(i);
            sb.append(parameter.getName());
            if (i >= parameters.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("};\n");
        sb.append("    IBoxContext context = RequestBoxContext.getCurrent();\n");
        sb.append("    if( context == null ) {\n");
        sb.append("      context = new ScriptingRequestBoxContext( BoxRuntime.getInstance().getRuntimeContext() );\n");
        sb.append("    }\n");
        sb.append("    Object result = this.dereferenceAndInvoke( context, Key.of( \"");
        sb.append(func.getName());
        sb.append("\" ), ___args, false );\n");
        if (!returnValue.equals("void")) {
            sb.append("    return (");
            sb.append(returnValue);
            sb.append(") result;\n");
        }
        sb.append("}\n");
        return sb.toString();
    }
}

