/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ClassInfo;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;

public class ProxyTransformer {
    private static final String template = "\tpackage ${packageName};\n\n\n\t// BoxLang Auto Imports\n\timport ortus.boxlang.runtime.BoxRuntime;\n\timport ortus.boxlang.runtime.components.Component;\n\timport ortus.boxlang.runtime.context.*;\n\timport ortus.boxlang.runtime.context.ClassBoxContext;\n\timport ortus.boxlang.runtime.context.FunctionBoxContext;\n\timport ortus.boxlang.runtime.context.RequestBoxContext;\n\timport ortus.boxlang.runtime.dynamic.casters.*;\n\timport ortus.boxlang.runtime.dynamic.ExpressionInterpreter;\n\timport ortus.boxlang.runtime.dynamic.IReferenceable;\n\timport ortus.boxlang.runtime.dynamic.Referencer;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.interop.DynamicObject;\n\timport ortus.boxlang.runtime.loader.ClassLocator;\n\timport ortus.boxlang.runtime.loader.ImportDefinition;\n\timport ortus.boxlang.runtime.operators.*;\n\timport ortus.boxlang.runtime.runnables.BoxScript;\n\timport ortus.boxlang.runtime.runnables.BoxTemplate;\n\timport ortus.boxlang.runtime.runnables.IClassRunnable;\n\timport ortus.boxlang.runtime.runnables.IProxyRunnable;\n\timport ortus.boxlang.runtime.scopes.*;\n\timport ortus.boxlang.runtime.scopes.Key;\n\timport ortus.boxlang.runtime.types.*;\n\timport ortus.boxlang.runtime.types.util.*;\n\timport ortus.boxlang.runtime.types.exceptions.*;\n\timport ortus.boxlang.runtime.types.exceptions.ExceptionUtil;\n\timport ortus.boxlang.runtime.types.meta.BoxMeta;\n\timport ortus.boxlang.runtime.types.meta.ClassMeta;\n\timport ortus.boxlang.runtime.types.Property;\n\timport ortus.boxlang.runtime.util.*;\n\timport ortus.boxlang.compiler.parser.BoxSourceType;\n\timport ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;\n\timport ortus.boxlang.runtime.runnables.BoxClassSupport;\n\n\t// Java Imports\n\timport java.nio.file.Path;\n\timport java.nio.file.Paths;\n\timport java.time.LocalDateTime;\n\timport java.util.ArrayList;\n\timport java.util.Collections;\n\timport java.util.HashMap;\n\timport java.util.Iterator;\n\timport java.util.LinkedHashMap;\n\timport java.util.LinkedHashMap;\n\timport java.util.List;\n\timport java.util.Map;\n\timport java.util.Optional;\n\n\tpublic class ${className} implements IProxyRunnable, ${interfaceList} {\n\n\t\tprivate static final long\t\t\t\t\tcompileVersion\t= ${compileVersion};\n\n\t\t/**\n\t\t * The box class being proxied to\n\t\t */\n\t\tpublic IClassRunnable\t\t\t\t\t\tboxClass;\n\n\t\tpublic ${className}() {\n\t\t}\n\n\t\t// IProxyRunnable implementation methods\n\n\t\t/**\n\t\t\t* The version of the BoxLang runtime\n\t\t*/\n\t\tpublic long getBXRunnableCompileVersion() {\n\t\t\treturn ${className}.compileVersion;\n\t\t}\n\n\t\t/**\n\t\t * Set the proxy object\n\t\t */\n\t\tpublic void setBXProxy( IClassRunnable boxClass ) {\n\t\t\tthis.boxClass = boxClass;\n\t\t}\n\n\t\t${interfaceMethods}\n\n\n\t}\n";

    public static String transform(ClassInfo classInfo) {
        String packageName = classInfo.packageName().toString();
        String className = classInfo.className();
        String interfaceList = classInfo.interfaceProxyDefinition().interfaces().stream().collect(Collectors.joining(", "));
        String interfaceMethods = ProxyTransformer.generateInterfaceMethods(classInfo.interfaceProxyDefinition().methods(), "boxClass");
        Map<String, String> values = Map.ofEntries(Map.entry("packagename", packageName), Map.entry("className", className), Map.entry("compileVersion", "1L"), Map.entry("interfaceList", interfaceList), Map.entry("interfaceMethods", interfaceMethods));
        String code = PlaceholderHelper.resolve(template, values);
        return code;
    }

    public static String generateInterfaceMethods(List<Method> methods, String classReferenceName) {
        StringBuilder sb = new StringBuilder();
        for (Method method : methods) {
            Parameter parameter;
            int i;
            sb.append("public ");
            sb.append(method.getReturnType().getCanonicalName());
            sb.append(" ");
            sb.append(method.getName());
            sb.append("(");
            Parameter[] parameters = method.getParameters();
            for (i = 0; i < parameters.length; ++i) {
                parameter = parameters[i];
                sb.append(parameter.getType().getCanonicalName());
                sb.append(" ");
                sb.append(parameter.getName());
                if (i >= parameters.length - 1) continue;
                sb.append(", ");
            }
            sb.append(") {\n");
            sb.append("    Object[] ___args = new Object[] {");
            for (i = 0; i < parameters.length; ++i) {
                parameter = parameters[i];
                sb.append(parameter.getName());
                if (i >= parameters.length - 1) continue;
                sb.append(", ");
            }
            sb.append("};\n");
            sb.append("    IBoxContext context = RequestBoxContext.getCurrent();\n");
            sb.append("    if( context == null ) {\n");
            sb.append("      context = new ScriptingRequestBoxContext( BoxRuntime.getInstance().getRuntimeContext() );\n");
            sb.append("    }\n");
            sb.append("    Object result = ");
            sb.append(classReferenceName);
            sb.append(".dereferenceAndInvoke( context, Key.of( \"");
            sb.append(method.getName());
            sb.append("\" ), ___args, false );\n");
            if (!method.getReturnType().equals(Void.TYPE)) {
                sb.append("    return (");
                sb.append(method.getReturnType().getCanonicalName());
                sb.append(") result;\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

