/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxAccess;
import ortus.boxlang.compiler.ast.expression.BoxArgument;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxAccessTransformer
extends AbstractTransformer {
    public BoxAccessTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxFunctionInvocation bfun;
        BoxArgument barg;
        BoxNode boxNode;
        BoxAccess ba;
        Object template;
        Expression jContext;
        Expression accessKey;
        BoxAccess objectAccess = (BoxAccess)node;
        Boolean safe = objectAccess.isSafe() != false || context == TransformerContext.SAFE;
        if (objectAccess instanceof BoxDotAccess) {
            BoxDotAccess dotAccess = (BoxDotAccess)objectAccess;
            BoxExpression boxExpression = dotAccess.getAccess();
            if (boxExpression instanceof BoxIdentifier) {
                BoxIdentifier id = (BoxIdentifier)boxExpression;
                accessKey = this.createKey(id.getName());
            } else {
                boxExpression = dotAccess.getAccess();
                if (!(boxExpression instanceof BoxIntegerLiteral)) throw new ExpressionException("Unsupported access type: " + dotAccess.getAccess().getClass().getName(), dotAccess.getAccess());
                BoxIntegerLiteral il = (BoxIntegerLiteral)boxExpression;
                accessKey = this.createKey(il);
            }
        } else {
            accessKey = this.createKey(objectAccess.getAccess());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("contextName", this.transpiler.peekContextName());
        values.put("safe", safe.toString());
        values.put("accessKey", accessKey.toString());
        if (objectAccess.getContext() instanceof BoxScope) {
            jContext = (Expression)this.transpiler.transform(objectAccess.getContext(), TransformerContext.NONE);
            values.put("scopeReference", jContext.toString());
            template = "                ${scopeReference}.dereference(\n${contextName},\n                  ${accessKey},\n                  ${safe}\n                  )\n";
            Expression javaExpr = this.parseExpression((String)template, values);
            this.addIndex(javaExpr, node);
            return javaExpr;
        }
        jContext = (Expression)this.transpiler.transform(objectAccess.getContext(), context);
        values.put("scopeReference", jContext.toString());
        template = "                Referencer.get(\n${contextName},\n                \t  ${scopeReference},\n                      ${accessKey},\n                      ${safe}\n                            )\n";
        BoxNode parent = objectAccess.getParent();
        if (!(parent instanceof BoxAccess && (ba = (BoxAccess)parent).getContext() == objectAccess || parent instanceof BoxArgument && (boxNode = (barg = (BoxArgument)parent).getParent()) instanceof BoxFunctionInvocation && (bfun = (BoxFunctionInvocation)boxNode).getName().toLowerCase().contains("array"))) {
            template = "${contextName}.unwrapQueryColumn( " + (String)template + " )";
        }
        Expression javaExpr = this.parseExpression((String)template, values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }
}

