/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxArrayLiteral;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxArrayLiteralTransformer
extends AbstractTransformer {
    public BoxArrayLiteralTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxArrayLiteral arrayLiteral = (BoxArrayLiteral)node;
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxArrayLiteralTransformer.this.transpiler.peekContextName());
            }
        };
        if (arrayLiteral.getValues().isEmpty()) {
            Expression javaExpr = this.parseExpression("new Array()", (Map<String, String>)values);
            this.addIndex(javaExpr, node);
            return javaExpr;
        }
        MethodCallExpr javaExpr = (MethodCallExpr)this.parseExpression("Array.of()", (Map<String, String>)values);
        for (BoxExpression expr : arrayLiteral.getValues()) {
            Expression value = (Expression)this.transpiler.transform(expr, context);
            javaExpr.getArguments().add(value);
        }
        this.addIndex(javaExpr, node);
        return javaExpr;
    }
}

