/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxExpression;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxAccess;
import ortus.boxlang.compiler.ast.expression.BoxAssignment;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentModifier;
import ortus.boxlang.compiler.ast.expression.BoxAssignmentOperator;
import ortus.boxlang.compiler.ast.expression.BoxDotAccess;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxIntegerLiteral;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.ast.expression.BoxStringInterpolation;
import ortus.boxlang.compiler.ast.expression.BoxStringLiteral;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxAssignmentTransformer
extends AbstractTransformer {
    public BoxAssignmentTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxAssignment assignment = (BoxAssignment)node;
        if (assignment.getOp() == null) {
            BoxExpression boxExpression = assignment.getLeft();
            if (!(boxExpression instanceof BoxIdentifier)) {
                throw new ExpressionException("You cannot declare a variable using " + assignment.getLeft().getClass().getSimpleName(), assignment.getPosition(), assignment.getSourceText());
            }
            BoxIdentifier id = (BoxIdentifier)boxExpression;
            final Expression key = this.createKey(id.getName());
            HashMap<String, String> values = new HashMap<String, String>(){
                {
                    this.put("contextName", BoxAssignmentTransformer.this.transpiler.peekContextName());
                    this.put("accessKey", key.toString());
                }
            };
            String template = "Referencer.setDeep(\n\t${contextName},\n\t${contextName}.scopeFindNearby( LocalScope.name, null ),\n\tnull,\n\t${accessKey}\n)\n";
            Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
            this.addIndex(javaExpr, node);
            return javaExpr;
        }
        if (assignment.getOp() == BoxAssignmentOperator.Equal) {
            Expression jRight = (Expression)this.transpiler.transform(assignment.getRight(), TransformerContext.NONE);
            return this.transformEquals(assignment.getLeft(), jRight, assignment.getOp(), assignment.getModifiers(), assignment.getSourceText(), context);
        }
        return this.transformCompoundEquals(assignment, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node transformEquals(BoxExpression left, final Expression jRight, BoxAssignmentOperator op, List<BoxAssignmentModifier> modifiers, String sourceText, TransformerContext context) throws IllegalStateException {
        String template;
        BoxIdentifier id;
        BoxScope scope;
        boolean hasVar = this.hasVar(modifiers);
        boolean hasStatic = this.hasStatic(modifiers);
        boolean hasFinal = this.hasFinal(modifiers);
        String mustBeScopeName = null;
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxAssignmentTransformer.this.transpiler.peekContextName());
                this.put("right", jRight.toString());
            }
        };
        if (left instanceof BoxStringInterpolation || left instanceof BoxStringLiteral) {
            if (hasVar) {
                throw new ExpressionException("You cannot use the [var] keyword with a quoted string on the left hand side of your assignment", left.getPosition(), left.getSourceText());
            }
            if (hasStatic) {
                throw new ExpressionException("You cannot use the [static] keyword with a quoted string on the left hand side of your assignment", left.getPosition(), left.getSourceText());
            }
            if (hasFinal) {
                throw new ExpressionException("You cannot use the [final] keyword with a quoted string on the left hand side of your assignment", left.getPosition(), left.getSourceText());
            }
            values.put("left", this.transpiler.transform(left).toString());
            String template2 = "ExpressionInterpreter.setVariable(\n${contextName},\n${left},\n${right}\n)\n";
            return this.parseExpression(template2, (Map<String, String>)values);
        }
        ArrayList<Expression> accessKeys = new ArrayList<Expression>();
        BoxExpression furthestLeft = left;
        while (furthestLeft instanceof BoxAccess) {
            BoxAccess currentObjectAccess = (BoxAccess)furthestLeft;
            if (currentObjectAccess instanceof BoxDotAccess) {
                BoxDotAccess dotAccess = (BoxDotAccess)currentObjectAccess;
                BoxExpression boxExpression = dotAccess.getAccess();
                if (boxExpression instanceof BoxIdentifier) {
                    BoxIdentifier id2 = (BoxIdentifier)boxExpression;
                    accessKeys.add(0, this.createKey(id2.getName()));
                } else {
                    boxExpression = dotAccess.getAccess();
                    if (!(boxExpression instanceof BoxIntegerLiteral)) throw new ExpressionException("Unexpected element [" + currentObjectAccess.getAccess().getClass().getSimpleName() + "] in dot access expression.", currentObjectAccess.getAccess().getPosition(), currentObjectAccess.getAccess().getSourceText());
                    BoxIntegerLiteral intl = (BoxIntegerLiteral)boxExpression;
                    accessKeys.add(0, this.createKey(intl.getValue()));
                }
            } else {
                accessKeys.add(0, this.createKey(currentObjectAccess.getAccess()));
            }
            furthestLeft = currentObjectAccess.getContext();
        }
        if (hasStatic && hasVar) {
            throw new ExpressionException("You cannot use the [var] and [static] keywords together", left.getPosition(), left.getSourceText());
        }
        if (hasVar) {
            mustBeScopeName = "local";
            if (furthestLeft instanceof BoxScope) {
                scope = (BoxScope)furthestLeft;
                accessKeys.add(0, this.createKey(scope.getName()));
            } else {
                if (!(furthestLeft instanceof BoxIdentifier)) throw new ExpressionException("You cannot use the [var] keyword before " + furthestLeft.getClass().getSimpleName(), furthestLeft.getPosition(), furthestLeft.getSourceText());
                id = (BoxIdentifier)furthestLeft;
                accessKeys.add(0, this.createKey(id.getName()));
            }
            furthestLeft = new BoxIdentifier("local", null, null);
        }
        if (hasStatic) {
            mustBeScopeName = "static";
            if (furthestLeft instanceof BoxScope) {
                scope = (BoxScope)furthestLeft;
                accessKeys.add(0, this.createKey(scope.getName()));
            } else {
                if (!(furthestLeft instanceof BoxIdentifier)) throw new ExpressionException("You cannot use the [static] keyword before " + furthestLeft.getClass().getSimpleName(), furthestLeft.getPosition(), furthestLeft.getSourceText());
                id = (BoxIdentifier)furthestLeft;
                accessKeys.add(0, this.createKey(id.getName()));
            }
            furthestLeft = new BoxIdentifier("static", null, null);
        }
        if (furthestLeft instanceof BoxIdentifier) {
            id = (BoxIdentifier)furthestLeft;
            if (this.transpiler.matchesImport(id.getName()) && this.transpiler.getProperty("sourceType").toLowerCase().startsWith("box")) {
                throw new ExpressionException("You cannot assign a variable with the same name as an import: [" + id.getName() + "]", furthestLeft.getPosition(), furthestLeft.getSourceText());
            }
            Expression keyNode = this.createKey(id.getName());
            String thisKey = keyNode.toString();
            values.put("accessKey", thisKey);
            values.put("mustBeScopeName", mustBeScopeName == null ? "null" : this.createKey(mustBeScopeName).toString());
            values.put("hasFinal", hasFinal ? "true" : "false");
            values.put("furthestLeft", PlaceholderHelper.resolve(".scope()", (Map<String, String>)values));
            values.put("accessKeys", (accessKeys.size() > 0 ? "," : "") + accessKeys.stream().map(it -> it.toString()).collect(Collectors.joining(",")));
            template = "Referencer.setDeep(\n\t${contextName},\n\t${hasFinal},\n\t${mustBeScopeName},\n\t${contextName}.scopeFindNearby( ${accessKey}, ${contextName}.getDefaultAssignmentScope() ),\n\t${right}\n\t${accessKeys}\n)\n";
            return this.parseExpression(template, (Map<String, String>)values);
        } else {
            if (accessKeys.size() == 0) {
                throw new ExpressionException("You cannot assign a value to " + left.getClass().getSimpleName(), left.getPosition(), left.getSourceText());
            }
            values.put("furthestLeft", this.transpiler.transform(furthestLeft, TransformerContext.NONE).toString());
            values.put("accessKeys", accessKeys.stream().map(it -> it.toString()).collect(Collectors.joining(",")));
            values.put("mustBeScopeName", mustBeScopeName == null ? "null" : this.createKey(mustBeScopeName).toString());
            values.put("hasFinal", hasFinal ? "true" : "false");
            template = "Referencer.setDeep(\n\t${contextName},\n\t${hasFinal},\n\t${mustBeScopeName},\n\t${furthestLeft},\n\t${right},\n\t${accessKeys}\n)\n";
        }
        return this.parseExpression(template, (Map<String, String>)values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node transformCompoundEquals(BoxAssignment assignment, TransformerContext context) throws IllegalStateException {
        final Expression right = (Expression)this.transpiler.transform(assignment.getRight(), TransformerContext.NONE);
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxAssignmentTransformer.this.transpiler.peekContextName());
                this.put("right", right.toString());
            }
        };
        BoxExpression boxExpression = assignment.getLeft();
        if (boxExpression instanceof BoxIdentifier) {
            BoxIdentifier id = (BoxIdentifier)boxExpression;
            Expression accessKey = this.createKey(id.getName());
            values.put("accessKey", accessKey.toString());
            obj = PlaceholderHelper.resolve("${contextName}.scopeFindNearby( ${accessKey}, ${contextName}.getDefaultAssignmentScope() ).scope()", (Map<String, String>)values);
            values.put("obj", (String)obj);
        } else {
            Expression accessKey;
            obj = assignment.getLeft();
            if (!(obj instanceof BoxAccess)) throw new ExpressionException("You cannot assign a value to " + assignment.getLeft().getClass().getSimpleName(), assignment.getPosition(), assignment.getSourceText());
            BoxAccess objectAccess = (BoxAccess)obj;
            values.put("obj", this.transpiler.transform(objectAccess.getContext()).toString());
            if (objectAccess instanceof BoxDotAccess) {
                BoxDotAccess dotAccess = (BoxDotAccess)objectAccess;
                BoxExpression boxExpression2 = dotAccess.getAccess();
                if (boxExpression2 instanceof BoxIdentifier) {
                    BoxIdentifier id = (BoxIdentifier)boxExpression2;
                    accessKey = this.createKey(id.getName());
                } else {
                    boxExpression2 = dotAccess.getAccess();
                    if (!(boxExpression2 instanceof BoxIntegerLiteral)) throw new ExpressionException("Unexpected element [" + dotAccess.getAccess().getClass().getSimpleName() + "] in dot access expression.", dotAccess.getAccess().getPosition(), dotAccess.getAccess().getSourceText());
                    BoxIntegerLiteral intl = (BoxIntegerLiteral)boxExpression2;
                    accessKey = this.createKey(intl.getValue());
                }
            } else {
                accessKey = this.createKey(objectAccess.getAccess());
            }
            values.put("accessKey", accessKey.toString());
        }
        String template = this.getMethodCallTemplate(assignment);
        return this.parseExpression(template, (Map<String, String>)values);
    }

    private boolean hasVar(List<BoxAssignmentModifier> modifiers) {
        return modifiers.stream().anyMatch(it -> it == BoxAssignmentModifier.VAR);
    }

    private boolean hasStatic(List<BoxAssignmentModifier> modifiers) {
        return modifiers.stream().anyMatch(it -> it == BoxAssignmentModifier.STATIC);
    }

    private boolean hasFinal(List<BoxAssignmentModifier> modifiers) {
        return modifiers.stream().anyMatch(it -> it == BoxAssignmentModifier.FINAL);
    }

    private String getMethodCallTemplate(BoxAssignment assignment) {
        BoxAssignmentOperator operator = assignment.getOp();
        return switch (operator) {
            case BoxAssignmentOperator.PlusEqual -> "Plus.invoke( ${contextName}, ${obj}, ${accessKey}, ${right} )";
            case BoxAssignmentOperator.MinusEqual -> "Minus.invoke( ${contextName}, ${obj}, ${accessKey}, ${right} )";
            case BoxAssignmentOperator.StarEqual -> "Multiply.invoke( ${contextName}, ${obj}, ${accessKey}, ${right} )";
            case BoxAssignmentOperator.SlashEqual -> "Divide.invoke( ${contextName}, ${obj}, ${accessKey}, ${right} )";
            case BoxAssignmentOperator.ModEqual -> "Modulus.invoke( ${contextName}, ${obj}, ${accessKey}, ${right} )";
            case BoxAssignmentOperator.ConcatEqual -> "Concat.invoke( ${contextName}, ${obj}, ${accessKey}, ${right} )";
            default -> throw new ExpressionException("Unknown assingment operator " + operator.toString(), assignment.getPosition(), assignment.getSourceText());
        };
    }
}

