/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import javax.annotation.Nonnull;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperation;
import ortus.boxlang.compiler.ast.expression.BoxBinaryOperator;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxBinaryOperationTransformer
extends AbstractTransformer {
    public BoxBinaryOperationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxBinaryOperation operation = (BoxBinaryOperation)node;
        TransformerContext safe = operation.getOperator() == BoxBinaryOperator.Elvis ? TransformerContext.SAFE : context;
        Expression left = (Expression)this.transpiler.transform(operation.getLeft(), safe);
        Expression right = (Expression)this.transpiler.transform(operation.getRight(), context);
        Expression javaExpr = switch (operation.getOperator()) {
            case BoxBinaryOperator.Plus -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Plus", left, right);
            case BoxBinaryOperator.Minus -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Minus", left, right);
            case BoxBinaryOperator.Star -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Multiply", left, right);
            case BoxBinaryOperator.Slash -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Divide", left, right);
            case BoxBinaryOperator.Backslash -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("IntegerDivide", left, right);
            case BoxBinaryOperator.Power -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Power", left, right);
            case BoxBinaryOperator.Xor -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("XOR", left, right);
            case BoxBinaryOperator.Mod -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Modulus", left, right);
            case BoxBinaryOperator.And -> {
                BinaryExpr binaryExpr = new BinaryExpr();
                NameExpr booleanNameExpr = new NameExpr("BooleanCaster");
                MethodCallExpr leftExpr = new MethodCallExpr((Expression)booleanNameExpr, "cast");
                leftExpr.addArgument(left);
                binaryExpr.setLeft(leftExpr);
                binaryExpr.setOperator(BinaryExpr.Operator.AND);
                MethodCallExpr rightExpr = new MethodCallExpr((Expression)booleanNameExpr, "cast");
                rightExpr.addArgument(right);
                binaryExpr.setRight(rightExpr);
                yield binaryExpr;
            }
            case BoxBinaryOperator.Or -> {
                BinaryExpr binaryExpr = new BinaryExpr();
                NameExpr booleanNameExpr = new NameExpr("BooleanCaster");
                MethodCallExpr leftExpr = new MethodCallExpr((Expression)booleanNameExpr, "cast");
                leftExpr.addArgument(left);
                binaryExpr.setLeft(leftExpr);
                binaryExpr.setOperator(BinaryExpr.Operator.OR);
                MethodCallExpr rightExpr = new MethodCallExpr((Expression)booleanNameExpr, "cast");
                rightExpr.addArgument(right);
                binaryExpr.setRight(rightExpr);
                yield binaryExpr;
            }
            case BoxBinaryOperator.Equivalence -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Equivalence", left, right);
            case BoxBinaryOperator.Implies -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Implies", left, right);
            case BoxBinaryOperator.Elvis -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Elvis", left, right);
            case BoxBinaryOperator.InstanceOf -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("InstanceOf", this.transpiler.peekContextName(), left, right);
            case BoxBinaryOperator.Contains -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Contains", left, right);
            case BoxBinaryOperator.NotContains -> new UnaryExpr(BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("Contains", left, right), UnaryExpr.Operator.LOGICAL_COMPLEMENT);
            case BoxBinaryOperator.CastAs -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("CastAs", this.transpiler.peekContextName(), left, right);
            case BoxBinaryOperator.BitwiseAnd -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("BitwiseAnd", left, right);
            case BoxBinaryOperator.BitwiseOr -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("BitwiseOr", left, right);
            case BoxBinaryOperator.BitwiseXor -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("BitwiseXor", left, right);
            case BoxBinaryOperator.BitwiseSignedLeftShift -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("BitwiseSignedLeftShift", left, right);
            case BoxBinaryOperator.BitwiseSignedRightShift -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("BitwiseSignedRightShift", left, right);
            case BoxBinaryOperator.BitwiseUnsignedRightShift -> BoxBinaryOperationTransformer.generateBinaryMethodCallExpr("BitwiseUnsignedRightShift", left, right);
            default -> throw new ExpressionException("not implemented", operation);
        };
        return javaExpr;
    }

    @Nonnull
    private static MethodCallExpr generateBinaryMethodCallExpr(String methodName, Object ... args) {
        NameExpr nameExpr = new NameExpr(methodName);
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)nameExpr, "invoke");
        for (Object o : args) {
            if (o instanceof Expression) {
                Expression expr = (Expression)o;
                methodCallExpr.addArgument(expr);
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                methodCallExpr.addArgument(s);
                continue;
            }
            String type = "null";
            if (o != null) {
                type = o.getClass().getName();
            }
            throw new IllegalStateException("Invalid argument type: " + type);
        }
        return methodCallExpr;
    }
}

