/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.time.LocalDateTime;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.BoxStatement;
import ortus.boxlang.compiler.ast.expression.BoxClosure;
import ortus.boxlang.compiler.ast.statement.BoxExpressionStatement;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.config.util.PlaceholderHelper;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class BoxClosureTransformer
extends AbstractTransformer {
    private String template = "package ${packageName};\n\nimport ortus.boxlang.runtime.scopes.IScope;\nimport ortus.boxlang.runtime.scopes.Key;\nimport ortus.boxlang.runtime.context.FunctionBoxContext;\nimport ortus.boxlang.runtime.types.exceptions.*;\nimport ortus.boxlang.runtime.context.ClassBoxContext;\nimport ortus.boxlang.runtime.runnables.IBoxRunnable;\nimport ortus.boxlang.runtime.context.IBoxContext;\nimport ortus.boxlang.runtime.loader.ImportDefinition;\nimport ortus.boxlang.runtime.interop.DynamicObject;\nimport ortus.boxlang.runtime.dynamic.ExpressionInterpreter;\nimport java.util.Optional;\nimport ortus.boxlang.runtime.components.Component;\nimport ortus.boxlang.compiler.parser.BoxSourceType;\nimport ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;\nimport ortus.boxlang.runtime.runnables.BoxClassSupport;\n\n// Classes Auto-Imported on all Templates and Classes by BoxLang\nimport java.time.LocalDateTime;\nimport java.time.Instant;\nimport java.lang.System;\nimport java.lang.String;\nimport java.lang.Character;\nimport java.lang.Boolean;\nimport java.lang.Double;\nimport java.lang.Integer;\nimport java.util.*;\nimport ortus.boxlang.runtime.types.*;\nimport ortus.boxlang.runtime.types.util.*;\nimport java.util.LinkedHashMap;\nimport java.nio.file.*;\n\n\t\tpublic class ${classname} extends Closure {\n\tprivate static ${classname}\t\t\t\tinstance;\n\tprivate final static Key\t\t\t\tname\t\t= Closure.defaultName;\n\tprivate final static Argument[]\t\t\targuments\t= new Argument[] {};\n\tprivate final static String\t\t\t\treturnType\t= \"any\";\n\n    private final static IStruct\t\t\tannotations\t\t\t= Struct.EMPTY;\n\tprivate final static IStruct\t\t\tdocumentation\t\t= Struct.EMPTY;\n\n\tprivate static final long\t\t\t\t\tcompileVersion\t= ${compileVersion};\n\tprivate static final LocalDateTime\t\t\tcompiledOn\t\t= ${compiledOnTimestamp};\n\tprivate static final Object\t\t\t\t\tast\t\t\t\t= null;\n\n\n\tpublic Key getName() {\n\t\treturn name;\n\t}\n\tpublic Argument[] getArguments() {\n\t\treturn arguments;\n\t}\n\tpublic String getReturnType() {\n\t\treturn returnType;\n\t}\n\n\tpublic Access getAccess() {\n \t\t\t\treturn Access.PUBLIC;\n \t\t\t}\n\n\tpublic  long getRunnableCompileVersion() {\n\t\treturn ${className}.compileVersion;\n\t}\n\n\tpublic LocalDateTime getRunnableCompiledOn() {\n\t\treturn ${className}.compiledOn;\n\t}\n\n\tpublic Object getRunnableAST() {\n\t\treturn ${className}.ast;\n\t}\n\n\tpublic ${classname}( IBoxContext declaringContext  ) {\n\t\tsuper( declaringContext );\n\t}\n\n\t@Override\n\tpublic List<ImportDefinition> getImports() {\n\t\treturn imports;\n    \t\t}\n\n\t@Override\n\tpublic IStruct getAnnotations() {\n\t\treturn annotations;\n\t}\n\n\t@Override\n\tpublic IStruct getDocumentation() {\n\t\treturn documentation;\n\t}\n\t@Override\n\tpublic Object _invoke( FunctionBoxContext context ) {\n\t\tClassLocator classLocator = ClassLocator.getInstance();\n\n\t}\n\n\tpublic ResolvedFilePath getRunnablePath() {\n\t\treturn ${enclosingClassName}.path;\n\t}\n\n\t/**\n\t * The original source type\n\t */\n\tpublic BoxSourceType getSourceType() {\n\t\treturn ${enclosingClassName}.sourceType;\n\t}\n\n\t\t}\n";

    public BoxClosureTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        ParseResult<CompilationUnit> result;
        BoxClosure boxClosure = (BoxClosure)node;
        String packageName = this.transpiler.getProperty("packageName");
        String closureName = "Closure_" + this.transpiler.incrementAndGetClosureCounter();
        String enclosingClassName = this.transpiler.getProperty("classname");
        String className = closureName;
        Map<String, String> values = Map.ofEntries(Map.entry("packageName", packageName), Map.entry("className", className), Map.entry("closureName", closureName), Map.entry("enclosingClassName", enclosingClassName), Map.entry("contextName", this.transpiler.peekContextName()), Map.entry("compiledOnTimestamp", this.transpiler.getDateTime(LocalDateTime.now())), Map.entry("compileVersion", "1L"));
        this.transpiler.pushContextName("context");
        String code = PlaceholderHelper.resolve(this.template, values);
        try {
            result = this.javaParser.parse(code);
        }
        catch (Exception e) {
            throw new BoxRuntimeException(code, e);
        }
        if (!result.isSuccessful()) {
            throw new BoxRuntimeException(String.valueOf(result) + "\n" + code);
        }
        CompilationUnit javaClass = result.getResult().get();
        ArrayInitializerExpr argInitializer = new ArrayInitializerExpr();
        boxClosure.getArgs().forEach(arg -> {
            Expression argument = (Expression)this.transpiler.transform((BoxNode)arg);
            argInitializer.getValues().add(argument);
        });
        javaClass.getType(0).getFieldByName("arguments").orElseThrow().getVariable(0).setInitializer(argInitializer);
        Expression annotationStruct = this.transformAnnotations(boxClosure.getAnnotations());
        result.getResult().orElseThrow().getType(0).getFieldByName("annotations").orElseThrow().getVariable(0).setInitializer(annotationStruct);
        MethodDeclaration invokeMethod = javaClass.findCompilationUnit().orElseThrow().getClassByName(className).orElseThrow().getMethodsByName("_invoke").get(0);
        BlockStmt body = invokeMethod.getBody().get();
        this.transpiler.pushfunctionBodyCounter();
        int componentCounter = this.transpiler.getComponentCounter();
        this.transpiler.setComponentCounter(0);
        BoxStatement boxStatement = boxClosure.getBody();
        if (boxStatement instanceof BoxExpressionStatement) {
            BoxExpressionStatement boxExpr = (BoxExpressionStatement)boxStatement;
            body.addStatement(new ReturnStmt(new EnclosedExpr((Expression)this.transpiler.transform(boxExpr.getExpression()))));
        } else {
            body.addStatement((Statement)this.transpiler.transform(boxClosure.getBody()));
            invokeMethod.getBody().get().addStatement(new ReturnStmt(new NullLiteralExpr()));
        }
        this.transpiler.setComponentCounter(componentCounter);
        this.transpiler.popfunctionBodyCounter();
        this.transpiler.popContextName();
        ((JavaTranspiler)this.transpiler).getCallables().add(javaClass);
        return this.parseExpression("new ${enclosingClassName}.${closureName}( ${contextName} )", values);
    }
}

