/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperation;
import ortus.boxlang.compiler.ast.expression.BoxComparisonOperator;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxComparisonOperationTransformer
extends AbstractTransformer {
    public BoxComparisonOperationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxComparisonOperation operation = (BoxComparisonOperation)node;
        final Expression left = (Expression)this.transpiler.transform(operation.getLeft());
        final Expression right = (Expression)this.transpiler.transform(operation.getRight());
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("left", left.toString());
                this.put("right", right.toString());
                this.put("contextName", BoxComparisonOperationTransformer.this.transpiler.peekContextName());
            }
        };
        String template = "";
        if (operation.getOperator() == BoxComparisonOperator.Equal) {
            template = "EqualsEquals.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.NotEqual) {
            template = "!EqualsEquals.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.TEqual) {
            template = "EqualsEqualsEquals.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.TNotEqual) {
            template = "!EqualsEqualsEquals.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.Contains) {
            template = "Contains.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.GreaterThan) {
            template = "GreaterThan.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.GreaterThanEquals) {
            template = "GreaterThanEqual.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.LessThan) {
            template = "LessThan.invoke(${left},${right})";
        } else if (operation.getOperator() == BoxComparisonOperator.LessThanEquals) {
            template = "LessThanEqual.invoke(${left},${right})";
        } else {
            throw new ExpressionException("not implemented", operation);
        }
        Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }
}

