/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxExpressionInvocation;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxExpressionInvocationTransformer
extends AbstractTransformer {
    public BoxExpressionInvocationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxExpressionInvocation invocation = (BoxExpressionInvocation)node;
        final Expression expr = (Expression)this.transpiler.transform(invocation.getExpr(), context);
        final String args = invocation.getArguments().stream().map(it -> this.transpiler.transform((BoxNode)it).toString()).collect(Collectors.joining(", "));
        String template = "${contextName}.invokeFunction(\n  ${expr},\n  new Object[] { ${args} }\n)\n";
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxExpressionInvocationTransformer.this.transpiler.peekContextName());
                this.put("expr", expr.toString());
                this.put("args", args);
            }
        };
        Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }
}

