/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFunctionInvocation;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxFunctionInvocationTransformer
extends AbstractTransformer {
    public BoxFunctionInvocationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxFunctionInvocation function = (BoxFunctionInvocation)node;
        final String methodName = function.getName();
        boolean isSafeMethodCall = methodName.equalsIgnoreCase("isnull");
        TransformerContext safe = isSafeMethodCall ? TransformerContext.SAFE : context;
        String side = safe == TransformerContext.NONE ? "" : "(" + safe.toString() + ") ";
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("functionName", BoxFunctionInvocationTransformer.this.createKey(methodName).toString());
                this.put("contextName", BoxFunctionInvocationTransformer.this.transpiler.peekContextName());
            }
        };
        for (int i = 0; i < function.getArguments().size(); ++i) {
            Expression expr = (Expression)this.transpiler.transform(function.getArguments().get(i), safe);
            values.put("arg" + i, expr.toString());
        }
        String template = this.getTemplate(function);
        Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }

    private String getTemplate(BoxFunctionInvocation function) {
        StringBuilder sb = new StringBuilder("${contextName}.invokeFunction( ${functionName}, ");
        sb.append(this.generateArguments(function.getArguments()));
        sb.append(")");
        return sb.toString();
    }
}

