/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxFunctionalMemberAccess;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxFunctionalMemberAccessTransformer
extends AbstractTransformer {
    public BoxFunctionalMemberAccessTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxFunctionalMemberAccess boxFunctionalMemberAccess = (BoxFunctionalMemberAccess)node;
        final String name = boxFunctionalMemberAccess.getName();
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("name", BoxFunctionalMemberAccessTransformer.this.createKey(name).toString());
                this.put("contextName", BoxFunctionalMemberAccessTransformer.this.transpiler.peekContextName());
            }
        };
        if (boxFunctionalMemberAccess.getArguments() == null || boxFunctionalMemberAccess.getArguments().isEmpty()) {
            String template = "FunctionalMemberAccess.of( ${name} )";
            Expression javaStmt = this.parseExpression(template, (Map<String, String>)values);
            this.addIndex(javaStmt, node);
            return javaStmt;
        }
        boolean isNamed = boxFunctionalMemberAccess.getArguments().get(0).getName() != null;
        NullLiteralExpr _null = new NullLiteralExpr();
        for (int i = 0; i < boxFunctionalMemberAccess.getArguments().size(); ++i) {
            Expression expr = (Expression)this.transpiler.transform(boxFunctionalMemberAccess.getArguments().get(i));
            values.put("arg" + i, expr.toString());
        }
        String template = "new FunctionalMemberAccessArgs( ${name}, ${contextName} )";
        ObjectCreationExpr javaExpr = (ObjectCreationExpr)this.parseExpression(template, (Map<String, String>)values);
        String lambdaContextName = "lambdaContext" + this.transpiler.incrementAndGetLambdaContextCounter();
        this.transpiler.pushContextName(lambdaContextName);
        Expression argExpression = this.parseExpression(this.generateArguments(boxFunctionalMemberAccess.getArguments()), (Map<String, String>)values);
        this.transpiler.popContextName();
        LambdaExpr lambda = new LambdaExpr();
        lambda.setParameters(new NodeList((Node[])new Parameter[]{new Parameter((Type)new UnknownType(), lambdaContextName)}));
        BlockStmt body = new BlockStmt();
        body.addStatement(new ReturnStmt(argExpression));
        lambda.setBody(body);
        if (isNamed) {
            javaExpr.addArgument(lambda);
            javaExpr.addArgument(_null);
        } else {
            javaExpr.addArgument(_null);
            javaExpr.addArgument(lambda);
        }
        this.addIndex(javaExpr, node);
        return javaExpr;
    }
}

