/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxIdentifierTransformer
extends AbstractTransformer {
    public BoxIdentifierTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        String template;
        final BoxIdentifier identifier = (BoxIdentifier)node;
        String side = context == TransformerContext.NONE ? "" : "(" + context.toString() + ") ";
        final Expression accessKey = this.createKey(identifier.getName());
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("accessKey", accessKey.toString());
                this.put("id", identifier.getName());
                this.put("contextName", BoxIdentifierTransformer.this.transpiler.peekContextName());
            }
        };
        if (this.transpiler.matchesImport(identifier.getName()) && this.transpiler.getProperty("sourceType").toLowerCase().startsWith("box")) {
            template = "classLocator.load( ${contextName}, \"${id}\", imports )";
        } else {
            template = switch (context) {
                case TransformerContext.SAFE -> "${contextName}.scopeFindNearby( ${accessKey}, ${contextName}.getDefaultAssignmentScope()).value()";
                default -> "${contextName}.scopeFindNearby( ${accessKey}, null).value()";
            };
        }
        Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
        return javaExpr;
    }
}

