/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxIdentifier;
import ortus.boxlang.compiler.ast.expression.BoxMethodInvocation;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxMethodInvocationTransformer
extends AbstractTransformer {
    public BoxMethodInvocationTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        BoxMethodInvocation invocation = (BoxMethodInvocation)node;
        final Boolean safe = invocation.isSafe() != false || context == TransformerContext.SAFE;
        String side = context == TransformerContext.NONE ? "" : "(" + context.toString() + ") ";
        Expression expr = (Expression)this.transpiler.transform(invocation.getObj(), context);
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("contextName", BoxMethodInvocationTransformer.this.transpiler.peekContextName());
                this.put("safe", safe.toString());
            }
        };
        Object target = null;
        for (int i = 0; i < invocation.getArguments().size(); ++i) {
            Expression expr2 = (Expression)this.transpiler.transform(invocation.getArguments().get(i), context);
            values.put("arg" + i, expr2.toString());
        }
        values.put("expr", expr.toString());
        Expression accessKey = invocation.getUsedDotAccess() != false ? this.createKey(((BoxIdentifier)invocation.getName()).getName()) : this.createKey(invocation.getName());
        values.put("methodKey", accessKey.toString());
        String template = this.getTemplate(invocation);
        Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
        this.addIndex(javaExpr, node);
        return javaExpr;
    }

    private String getTemplate(BoxMethodInvocation function) {
        StringBuilder sb = new StringBuilder("Referencer.getAndInvoke(${contextName},${expr},${methodKey},");
        sb.append(this.generateArguments(function.getArguments()));
        sb.append(", ${safe})");
        return sb.toString();
    }
}

