/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.NameExpr;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxNew;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;

public class BoxNewTransformer
extends AbstractTransformer {
    public BoxNewTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        final BoxNew boxNew = (BoxNew)node;
        Expression expr = (Expression)this.transpiler.transform(boxNew.getExpression(), TransformerContext.RIGHT);
        Object fqn = expr.toString();
        if (expr instanceof NameExpr) {
            fqn = ((String)fqn).startsWith("\"") ? fqn : "\"" + (String)fqn + "\"";
        }
        final String finalFqn = ((String)fqn).replace("java:", "");
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("expr", finalFqn);
                this.put("contextName", BoxNewTransformer.this.transpiler.peekContextName());
                this.put("prefix", boxNew.getPrefix() == null ? "" : boxNew.getPrefix().getName() + ":");
            }
        };
        for (int i = 0; i < boxNew.getArguments().size(); ++i) {
            Expression expr2 = (Expression)this.transpiler.transform(boxNew.getArguments().get(i), context);
            values.put("arg" + i, expr2.toString());
        }
        String template = "classLocator.load(${contextName},\"${prefix}\".concat( StringCaster.cast(${expr})),imports).invokeConstructor( ${contextName}, " + this.generateArguments(boxNew.getArguments()) + " ).unWrapBoxLangClass()";
        Expression javaStmt = this.parseExpression(template, (Map<String, String>)values);
        this.addIndex(javaStmt, node);
        return javaStmt;
    }
}

