/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.compiler.javaboxpiler.transformer.expression;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.BoxNode;
import ortus.boxlang.compiler.ast.expression.BoxScope;
import ortus.boxlang.compiler.javaboxpiler.JavaTranspiler;
import ortus.boxlang.compiler.javaboxpiler.transformer.AbstractTransformer;
import ortus.boxlang.compiler.javaboxpiler.transformer.TransformerContext;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;

public class BoxScopeTransformer
extends AbstractTransformer {
    public BoxScopeTransformer(JavaTranspiler transpiler) {
        super(transpiler);
    }

    @Override
    public Node transform(BoxNode node, TransformerContext context) throws IllegalStateException {
        final BoxScope scope = (BoxScope)node;
        String side = context == TransformerContext.NONE ? "" : "(" + context.toString() + ") ";
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("scope", scope.getName());
                this.put("contextName", BoxScopeTransformer.this.transpiler.peekContextName());
            }
        };
        String template = "";
        if ("variables".equalsIgnoreCase(scope.getName())) {
            template = "${contextName}.getScopeNearby( VariablesScope.name )";
        } else if ("request".equalsIgnoreCase(scope.getName())) {
            template = "${contextName}.getScopeNearby( RequestScope.name )";
        } else if ("server".equalsIgnoreCase(scope.getName())) {
            template = "${contextName}.getScopeNearby( ServerScope.name )";
        } else {
            throw new ExpressionException("Scope transformation not implemented: " + scope.getName(), scope);
        }
        Expression javaExpr = this.parseExpression(template, (Map<String, String>)values);
        return javaExpr;
    }
}

